/*
 * Decompiled with CFR 0.152.
 */
package me.unfear.Slayer.mobtypes;

import java.io.File;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import me.unfear.Slayer.Main;
import me.unfear.Slayer.mobtypes.EnumTypes;
import me.unfear.Slayer.mobtypes.MobType;
import me.unfear.Slayer.mobtypes.VanillaMobType;
import me.unfear.Slayer.mobtypes.mythic.MythicMobsLoader;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.EntityType;
import org.bukkit.plugin.Plugin;

public class MobTypeLoader {
    private final Set<MobType> mobTypes = new HashSet<MobType>();

    public MobTypeLoader() {
        this.reloadConfig();
    }

    public void reloadConfig() {
        YamlConfiguration config;
        this.mobTypes.clear();
        File file = new File(Main.inst.getDataFolder(), "mob-types.yml");
        if (!file.exists()) {
            file.getParentFile().mkdirs();
            Main.inst.saveResource(file.getName(), false);
        }
        if ((config = YamlConfiguration.loadConfiguration((File)file)).getConfigurationSection("mob-types") == null) {
            Main.inst.getLogger().severe("No mob types registered in mob-types.yml, disabling...");
            Main.inst.getPluginLoader().disablePlugin((Plugin)Main.inst);
            return;
        }
        ConfigurationSection mobTypesSection = config.getConfigurationSection("mob-types");
        if (mobTypesSection != null) {
            for (String key : mobTypesSection.getKeys(false)) {
                ConfigurationSection section = config.getConfigurationSection("mob-types." + key);
                try {
                    EnumTypes.valueOf(Objects.requireNonNull(section).getString("type"));
                }
                catch (NullPointerException e) {
                    Main.inst.getLogger().severe("Unable to load mob-type, no type defined (id: " + key + ")");
                    Main.inst.getPluginLoader().disablePlugin((Plugin)Main.inst);
                    return;
                }
                catch (IllegalArgumentException e) {
                    Main.inst.getLogger().severe("Unable to load mob-type, type is invalid (id: " + key + ")");
                    Main.inst.getPluginLoader().disablePlugin((Plugin)Main.inst);
                    return;
                }
                EnumTypes type = EnumTypes.valueOf(section.getString("type"));
                this.mobTypes.add(this.load(section, type, key));
            }
        }
    }

    public Set<MobType> getMobTypes() {
        return this.mobTypes;
    }

    public MobType getMobType(Integer id) {
        for (MobType type : this.getMobTypes()) {
            if (type.getId() != id.intValue()) continue;
            return type;
        }
        return null;
    }

    private MobType load(ConfigurationSection section, EnumTypes type, String key) {
        switch (type) {
            case VANILLA: {
                return this.loadVanilla(section, key);
            }
            case MYTHIC_MOBS: {
                if (Main.inst.getServer().getPluginManager().getPlugin("MythicMobs") == null) {
                    Main.inst.getLogger().severe("Unable to load mob-type, type was MYTHIC_MOBS but MythicMobs isn't installed. (id: " + key + ")");
                    Main.inst.getPluginLoader().disablePlugin((Plugin)Main.inst);
                    return null;
                }
                return MythicMobsLoader.load(section, key);
            }
        }
        Main.inst.getLogger().severe("Something went really wrong! Please contact unfear_#8046 and send a copy of your configuration files.");
        Main.inst.getPluginLoader().disablePlugin((Plugin)Main.inst);
        return null;
    }

    private VanillaMobType loadVanilla(ConfigurationSection section, String key) {
        try {
            Integer.parseInt(key);
        }
        catch (NumberFormatException e) {
            Main.inst.getLogger().severe("Unable to load mob-type, id isn't an integer (id: " + key + ")");
            Main.inst.getPluginLoader().disablePlugin((Plugin)Main.inst);
            return null;
        }
        int id = Integer.parseInt(key);
        String name = section.getString("name");
        String entityTypeString = section.getString("entity");
        if (name == null || entityTypeString == null) {
            Main.inst.getLogger().severe("Unable to load VANILLA mob-type, missing value (id: " + key + ")");
            Main.inst.getPluginLoader().disablePlugin((Plugin)Main.inst);
            return null;
        }
        try {
            EntityType.valueOf((String)entityTypeString);
        }
        catch (IllegalArgumentException e) {
            Main.inst.getLogger().severe("Unable to load VANILLA mob-type, entity is invalid (id: " + key + ")");
            Main.inst.getPluginLoader().disablePlugin((Plugin)Main.inst);
            return null;
        }
        String materialString = section.getString("material");
        try {
            return new VanillaMobType(id, name, Material.valueOf((String)materialString), EntityType.valueOf((String)entityTypeString));
        }
        catch (IllegalArgumentException | NullPointerException e) {
            Main.inst.getLogger().warning("Invalid material for VANILLA mob-type, defaulting to skeleton skull (id: " + key + ")");
            return new VanillaMobType(id, name, Material.SKELETON_SKULL, EntityType.valueOf((String)entityTypeString));
        }
    }
}

