/*
 * Decompiled with CFR 0.152.
 */
package me.unfear.Slayer.mobtypes.mythic;

import io.lumine.mythic.api.mobs.MythicMob;
import io.lumine.mythic.bukkit.MythicBukkit;
import me.unfear.Slayer.Main;
import me.unfear.Slayer.mobtypes.MobType;
import me.unfear.Slayer.mobtypes.mythic.MythicMobType;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.plugin.Plugin;

public class MythicMobsLoader {
    public static final MythicBukkit mythicMobs = (MythicBukkit)Main.inst.getServer().getPluginManager().getPlugin("MythicMobs");

    public static MobType load(ConfigurationSection section, String key) {
        if (mythicMobs == null || !mythicMobs.isEnabled()) {
            Main.inst.getLogger().severe("Failed to hook into MythicMobs");
            return null;
        }
        try {
            Integer.parseInt(key);
        }
        catch (NumberFormatException e) {
            Main.inst.getLogger().severe("Unable to load mob-type, id isn't an integer (id: " + key + ")");
            Main.inst.getPluginLoader().disablePlugin((Plugin)Main.inst);
            return null;
        }
        int id = Integer.parseInt(key);
        String name = section.getString("name");
        String mythicMob = section.getString("mythicmob");
        if (name == null || mythicMob == null) {
            Main.inst.getLogger().severe("Unable to load MYTHIC_MOBS mob-type, missing value (id: " + key + ")");
            Main.inst.getPluginLoader().disablePlugin((Plugin)Main.inst);
            return null;
        }
        boolean validMob = false;
        for (MythicMob mob : mythicMobs.getMobManager().getMobTypes()) {
            if (!mob.getInternalName().equalsIgnoreCase(mythicMob)) continue;
            validMob = true;
            break;
        }
        if (!validMob) {
            Main.inst.getLogger().severe("Unable to load MYTHIC_MOBS mob-type, mythicmob does not exist (id: " + key + ")");
            Main.inst.getPluginLoader().disablePlugin((Plugin)Main.inst);
            return null;
        }
        String materialString = section.getString("material");
        Material material = Material.SKELETON_SKULL;
        try {
            if (materialString != null) {
                material = Material.valueOf((String)materialString);
            }
        }
        catch (IllegalArgumentException e) {
            Main.inst.getLogger().warning("Invalid material for MYTHIC_MOBS mob-type, defaulting to skeleton skull (id: " + key + ")");
        }
        return new MythicMobType(id, name, material, mythicMob);
    }
}

