/*
 * Decompiled with CFR 0.152.
 */
package ch.andre601.multidh;

import ch.andre601.multidh.commands.CmdReload;
import ch.andre601.multidh.depends.cloud.description.Description;
import ch.andre601.multidh.depends.cloud.execution.ExecutionCoordinator;
import ch.andre601.multidh.depends.cloud.paper.PaperCommandManager;
import ch.andre601.multidh.depends.cloud.permission.Permission;
import ch.andre601.multidh.listeners.DHEvents;
import ch.andre601.multidh.listeners.HologramListener;
import ch.andre601.multidh.listeners.ServerEvents;
import ch.andre601.multidh.manager.ConfigManager;
import ch.andre601.multidh.manager.HologramLoader;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class MultiDH
extends JavaPlugin {
    public static final MiniMessage MM = MiniMessage.miniMessage();
    private ConfigManager configManager;
    private HologramLoader hologramLoader;

    public void onEnable() {
        if (!this.getServer().getPluginManager().isPluginEnabled("DecentHolograms")) {
            this.getLogger().warning("===========================================================");
            this.getLogger().warning("DecentHolograms not found! MultiDH requires it to function!");
            this.getLogger().warning("===========================================================");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.configManager = new ConfigManager(this);
        if (this.configManager.loadHologramsFiles()) {
            int loaded = this.configManager.getHolograms().size();
            if (loaded == 1) {
                this.getLogger().info("Successfully loaded 1 Entry from config.yml!");
            } else {
                this.getSLF4JLogger().info("Successfully loaded {} entries from config.yml!", (Object)loaded);
            }
        } else {
            this.getLogger().warning("There were issues while loading Hologram entries. Check logs for issues.");
        }
        this.hologramLoader = new HologramLoader(this);
        this.loadCommand();
        try {
            Class.forName("eu.decentsoftware.holograms.event.HologramEnableEvent");
            new HologramListener(this);
            this.getLogger().info("Found HologramEnableEvent! Using Event-based Hologram (un)loading...");
        }
        catch (ClassNotFoundException ignored) {
            new ServerEvents(this);
            new DHEvents(this);
            this.getLogger().info("No HologramEnableEvent detected. Using legacy init delay...");
        }
    }

    public void onDisable() {
        this.configManager = null;
        this.hologramLoader = null;
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public HologramLoader getHologramLoader() {
        return this.hologramLoader;
    }

    private void loadCommand() {
        PaperCommandManager<CommandSourceStack> commandManager = PaperCommandManager.builder().executionCoordinator(ExecutionCoordinator.asyncCoordinator()).buildOnEnable((Plugin)this);
        commandManager.command(commandManager.commandBuilder("multidh", new String[0]).literal("reload", new String[0]).permission(Permission.anyOf(Permission.permission("multidh.admin"), Permission.permission("multidh.command.admin"))).commandDescription(Description.description("Reloads the currently synched holograms.")).handler(context -> CmdReload.handle(context, this)).build());
    }
}

