/*
 * Decompiled with CFR 0.152.
 */
package ch.andre601.multidh.depends.cloud.paper.suggestion;

import ch.andre601.multidh.depends.cloud.brigadier.suggestion.TooltipSuggestion;
import ch.andre601.multidh.depends.cloud.paper.LegacyPaperCommandManager;
import ch.andre601.multidh.depends.cloud.paper.suggestion.AsyncCommandSuggestionListener;
import ch.andre601.multidh.depends.cloud.paper.suggestion.tooltips.CompletionMapper;
import ch.andre601.multidh.depends.cloud.paper.suggestion.tooltips.CompletionMapperFactory;
import ch.andre601.multidh.depends.cloud.suggestion.SuggestionFactory;
import ch.andre601.multidh.depends.cloud.suggestion.Suggestions;
import ch.andre601.multidh.depends.cloud.util.StringUtils;
import com.destroystokyo.paper.event.server.AsyncTabCompleteEvent;
import java.util.Objects;
import java.util.stream.Collectors;
import org.bukkit.event.EventHandler;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

class BrigadierAsyncCommandSuggestionListener<C>
extends AsyncCommandSuggestionListener<C> {
    private final CompletionMapperFactory completionMapperFactory = CompletionMapperFactory.detectingRelocation();
    private final SuggestionFactory<C, ? extends TooltipSuggestion> suggestionFactory;

    BrigadierAsyncCommandSuggestionListener(@NonNull LegacyPaperCommandManager<C> paperCommandManager) {
        super(paperCommandManager);
        this.suggestionFactory = paperCommandManager.suggestionFactory().mapped(TooltipSuggestion::tooltipSuggestion);
    }

    @Override
    @EventHandler
    void onTabCompletion(@NonNull AsyncTabCompleteEvent event) {
        super.onTabCompletion(event);
    }

    @Override
    protected Suggestions<C, ? extends TooltipSuggestion> querySuggestions(@NonNull C commandSender, @NonNull String input) {
        return this.suggestionFactory.suggestImmediately(commandSender, input);
    }

    @Override
    protected void setSuggestions(@NonNull AsyncTabCompleteEvent event, @NonNull C commandSender, @NonNull String input) {
        CompletionMapper completionMapper = this.completionMapperFactory.createMapper();
        Suggestions suggestions = this.querySuggestions(commandSender, input);
        event.completions(suggestions.list().stream().map(suggestion -> {
            @Nullable String trim = StringUtils.trimBeforeLastSpace(suggestion.suggestion(), suggestions.commandInput());
            if (trim == null) {
                return null;
            }
            return suggestion.withSuggestion(trim);
        }).filter(Objects::nonNull).map(completionMapper::map).collect(Collectors.toList()));
    }
}

