/*
 * Decompiled with CFR 0.152.
 */
package ch.andre601.multidh.listeners;

import ch.andre601.multidh.MultiDH;
import ch.andre601.multidh.manager.HologramEntry;
import eu.decentsoftware.holograms.event.HologramDisableEvent;
import eu.decentsoftware.holograms.event.HologramEnableEvent;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class HologramListener
implements Listener {
    private final MultiDH plugin;

    public HologramListener(MultiDH plugin) {
        this.plugin = plugin;
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
    }

    @EventHandler
    public void onHologramEnable(HologramEnableEvent event) {
        String name = event.getHologram().getName();
        HologramEntry entry = this.plugin.getConfigManager().getHologram(name);
        if (entry == null) {
            return;
        }
        int loaded = this.plugin.getHologramLoader().loadHologram(entry, event.getHologram());
        if (loaded == 0) {
            this.plugin.getSLF4JLogger().warn("Couldn't load any copies for hologram '{}'.", (Object)name);
        } else if (loaded == 1) {
            this.plugin.getSLF4JLogger().info("Loaded 1 Hologram copy for '{}'.", (Object)name);
        } else {
            this.plugin.getSLF4JLogger().info("Loaded {} Hologram copies for '{}'.", (Object)loaded, (Object)name);
        }
    }

    @EventHandler
    public void onHologramDisable(HologramDisableEvent event) {
        String name = event.getHologram().getName();
        HologramEntry entry = this.plugin.getConfigManager().getHologram(name);
        if (entry == null) {
            return;
        }
        int removed = this.plugin.getHologramLoader().unloadHologram(entry);
        if (removed == 1) {
            this.plugin.getSLF4JLogger().info("Removed 1 Hologram copy for '{}'.", (Object)name);
        } else {
            this.plugin.getSLF4JLogger().info("Removed {} Hologram copies for '{}'.", (Object)removed, (Object)name);
        }
    }
}

