/*
 * Decompiled with CFR 0.152.
 */
package ch.andre601.multidh.manager;

import ch.andre601.multidh.MultiDH;
import ch.andre601.multidh.manager.HologramEntry;
import ch.andre601.multidh.manager.HologramEntrySerializer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.spongepowered.configurate.ConfigurationNode;
import org.spongepowered.configurate.serialize.SerializationException;
import org.spongepowered.configurate.serialize.TypeSerializer;
import org.spongepowered.configurate.yaml.YamlConfigurationLoader;

public class ConfigManager {
    private final MultiDH plugin;
    private final Path hologramsFile;
    private ConfigurationNode node;
    private List<HologramEntry> holograms = new ArrayList<HologramEntry>();

    public ConfigManager(MultiDH plugin) {
        this.plugin = plugin;
        this.hologramsFile = plugin.getDataPath().resolve("config.yml");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean loadHologramsFiles() {
        File pluginFolder = this.plugin.getDataFolder();
        if (!pluginFolder.exists() && !pluginFolder.mkdirs()) {
            this.plugin.getLogger().warning("Cannot create folder for plugin. Does it lack Write permissions?");
            return false;
        }
        if (Files.exists(this.hologramsFile, new LinkOption[0])) return this.reloadHologramsFile();
        try (InputStream stream = ((Object)((Object)this.plugin)).getClass().getResourceAsStream("/config.yml");){
            if (stream == null) {
                this.plugin.getLogger().warning("Cannot create holograms.yml! InputStream was null.");
                boolean bl = false;
                return bl;
            }
            Files.copy(stream, this.hologramsFile, StandardCopyOption.REPLACE_EXISTING);
            this.plugin.getLogger().info("Created holograms.yml!");
            return this.reloadHologramsFile();
        }
        catch (IOException ex) {
            this.plugin.getLogger().log(Level.WARNING, "Encountered IOException while trying to create holograms.yml.", ex);
            return false;
        }
    }

    public boolean reloadHologramsFile() {
        if (!this.createNode()) {
            return false;
        }
        try {
            List entries = this.node.node(new Object[]{"holograms"}).getList(HologramEntry.class);
            if (entries == null) {
                this.plugin.getLogger().warning("Cannot load entries. Holograms option returned null!");
                return false;
            }
            this.holograms = entries;
            return true;
        }
        catch (SerializationException ex) {
            this.plugin.getLogger().log(Level.WARNING, "Encountered IOException while trying to load entries.", ex);
            return false;
        }
    }

    public List<HologramEntry> getHolograms() {
        return this.holograms;
    }

    public HologramEntry getHologram(String name) {
        for (HologramEntry entry : this.holograms) {
            if (!entry.name().equals(name)) continue;
            return entry;
        }
        return null;
    }

    public long getInitDelay() {
        long delay = this.node.node(new Object[]{"initDelay"}).getLong(3L);
        return delay < 3L ? 3L : delay;
    }

    private boolean createNode() {
        YamlConfigurationLoader loader = ((YamlConfigurationLoader.Builder)((YamlConfigurationLoader.Builder)YamlConfigurationLoader.builder().path(this.hologramsFile)).defaultOptions(options -> options.serializers(builder -> builder.register(HologramEntry.class, (TypeSerializer)HologramEntrySerializer.INSTANCE)))).build();
        try {
            this.node = loader.load();
            return this.node != null;
        }
        catch (IOException ex) {
            this.plugin.getLogger().log(Level.WARNING, "Encountered IOException while trying to load holograms.yml!", ex);
            return false;
        }
    }
}

