/*
 * Decompiled with CFR 0.152.
 */
package ch.andre601.multidh.manager;

import ch.andre601.multidh.MultiDH;
import ch.andre601.multidh.manager.HologramEntry;
import eu.decentsoftware.holograms.api.DHAPI;
import eu.decentsoftware.holograms.api.holograms.Hologram;
import eu.decentsoftware.holograms.api.holograms.HologramPage;
import eu.decentsoftware.holograms.api.holograms.enums.EnumFlag;
import eu.decentsoftware.holograms.api.utils.location.LocationUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;

public class HologramLoader {
    private final Map<String, List<KnownHologram>> knownHolograms = new HashMap<String, List<KnownHologram>>();
    private final MultiDH plugin;

    public HologramLoader(MultiDH plugin) {
        this.plugin = plugin;
    }

    public void loadHolograms(CommandSender sender) {
        int synced = 0;
        for (HologramEntry entry : this.plugin.getConfigManager().getHolograms()) {
            Hologram source = DHAPI.getHologram((String)entry.name());
            if (source == null) {
                sender.sendMessage(MultiDH.MM.deserialize((Object)("<red>Cannot load copies for " + entry.name() + ". No Hologram with that name exists.")));
                continue;
            }
            synced += this.loadHologram(entry, source);
        }
        if (synced == 0) {
            sender.sendMessage(MultiDH.MM.deserialize((Object)"<red>Couldn't synchronize any Hologram Copies."));
        } else if (synced == 1) {
            sender.sendMessage(MultiDH.MM.deserialize((Object)"<green>Synchronized <white>1</white> Hologram Copy."));
        } else {
            sender.sendMessage(MultiDH.MM.deserialize((Object)("<green>Synchronized <white>" + synced + "</white> Hologram Copies.")));
        }
    }

    public int loadHologram(HologramEntry entry, Hologram hologram) {
        List<KnownHologram> oldHolograms = this.knownHolograms.get(entry.name());
        ArrayList<KnownHologram> newHolograms = new ArrayList<KnownHologram>();
        if (oldHolograms == null) {
            oldHolograms = new ArrayList<KnownHologram>();
        }
        oldHolograms.forEach(oldHologram -> oldHologram.hologram().delete());
        for (int i = 0; i < entry.locations().size(); ++i) {
            String name = this.getHologramName(entry, i);
            String loc = entry.locations().get(i);
            Location location = LocationUtils.asLocation((String)loc);
            if (location == null) {
                this.plugin.getSLF4JLogger().warn("Cannot create Hologram Copy '{}'. Location '{}' was invalid.", (Object)name, (Object)loc);
                continue;
            }
            newHolograms.add(new KnownHologram(loc, hologram.clone(name, location, true)));
        }
        this.knownHolograms.remove(entry.name());
        this.knownHolograms.put(entry.name(), newHolograms);
        return this.synchronizeHologram(hologram, entry);
    }

    public int unloadHologram(HologramEntry entry) {
        List<KnownHologram> holograms = this.knownHolograms.get(entry.name());
        if (holograms == null || holograms.isEmpty()) {
            return 0;
        }
        int removed = 0;
        for (KnownHologram holo : holograms) {
            holo.hologram().delete();
            ++removed;
        }
        return removed;
    }

    private int synchronizeHologram(Hologram source, HologramEntry entry) {
        List<KnownHologram> holograms = this.knownHolograms.get(entry.name());
        if (holograms == null || holograms.isEmpty()) {
            this.plugin.getSLF4JLogger().warn("Cannot sync Holograms for '{}'. No such Hologram found.", (Object)entry.name());
            return 0;
        }
        int synced = 0;
        for (int i = 0; i < holograms.size(); ++i) {
            KnownHologram knownHologram = holograms.get(i);
            String name = this.getHologramName(entry, i);
            if (knownHologram.hologram() == null) {
                this.plugin.getSLF4JLogger().warn("Cannot sync Hologram copy '{}'. Hologram was null.", (Object)name);
                continue;
            }
            String loc = knownHologram.loc();
            Location location = LocationUtils.asLocation((String)loc);
            if (location == null) {
                this.plugin.getSLF4JLogger().warn("Cannot sync Hologram copy '{}'. Location '{}' was invalid.", (Object)name, (Object)loc);
                continue;
            }
            this.syncCopy(source, knownHologram.hologram(), location);
            ++synced;
        }
        return synced;
    }

    private void syncCopy(Hologram source, Hologram target, Location location) {
        target.setLocation(location);
        target.setDownOrigin(source.isDownOrigin());
        target.setPermission(source.getPermission());
        target.setFacing(source.getFacing());
        target.setDisplayRange(source.getDisplayRange());
        target.setUpdateRange(source.getUpdateRange());
        target.setUpdateInterval(source.getUpdateInterval());
        target.addFlags(source.getFlags().toArray(new EnumFlag[0]));
        target.setDefaultVisibleState(source.isDefaultVisibleState());
        target.getShowPlayers().clear();
        target.getHidePlayers().clear();
        target.getShowPlayers().addAll(source.getShowPlayers());
        target.getHidePlayers().addAll(source.getHidePlayers());
        for (int i = 0; i < source.size(); ++i) {
            HologramPage page = source.getPage(i);
            HologramPage clone = page.clone(target, i);
            if (target.getPages().size() > i) {
                target.getPages().set(i, clone);
                continue;
            }
            target.getPages().add(clone);
        }
    }

    private String getHologramName(HologramEntry entry, int i) {
        return String.format("multidh_%s_%d", entry.name(), i);
    }

    private record KnownHologram(String loc, Hologram hologram) {
    }
}

