/*
 * Decompiled with CFR 0.152.
 */
package com.cake.trading_floor.foundation.advancement;

import com.cake.trading_floor.foundation.TFPlatformPredicates;
import com.cake.trading_floor.foundation.advancement.TFAdvancement;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class TFAdvancementBehaviour
extends BlockEntityBehaviour {
    public static final BehaviourType<TFAdvancementBehaviour> TYPE = new BehaviourType();
    private UUID playerId;
    private final Set<TFAdvancement> advancements = new HashSet<TFAdvancement>();

    public static void create(List<BlockEntityBehaviour> behaviours, SmartBlockEntity be, TFAdvancement ... advancements) {
        TFAdvancementBehaviour existing = behaviours.stream().filter(blockEntityBehaviour -> blockEntityBehaviour instanceof TFAdvancementBehaviour).findFirst().orElse(null);
        if (existing != null) {
            existing.advancements.addAll(List.of(advancements));
        } else {
            behaviours.add(new TFAdvancementBehaviour(be, advancements));
        }
    }

    protected TFAdvancementBehaviour(SmartBlockEntity be, TFAdvancement ... advancements) {
        super(be);
        this.add(advancements);
    }

    public void add(TFAdvancement ... advancements) {
        this.advancements.addAll(Arrays.asList(advancements));
    }

    public boolean isOwnerPresent() {
        return this.playerId != null;
    }

    public void setPlayer(UUID id) {
        Player player = this.getWorld().getPlayerByUUID(id);
        if (player == null) {
            return;
        }
        this.playerId = id;
        this.removeAwarded();
        this.blockEntity.setChanged();
    }

    public void initialize() {
        super.initialize();
        this.removeAwarded();
    }

    private void removeAwarded() {
        Player player = this.getPlayer();
        if (player == null) {
            return;
        }
        this.advancements.removeIf(c -> c.isAlreadyAwardedTo(player));
        if (this.advancements.isEmpty()) {
            this.playerId = null;
            this.blockEntity.setChanged();
        }
    }

    public void awardPlayerIfNear(TFAdvancement advancement, int maxDistance) {
        Player player = this.getPlayer();
        if (player == null) {
            return;
        }
        if (player.distanceToSqr(Vec3.atCenterOf((Vec3i)this.getPos())) > (double)(maxDistance * maxDistance)) {
            return;
        }
        this.award(advancement, player);
    }

    public void awardPlayer(TFAdvancement advancement) {
        Player player = this.getPlayer();
        if (player == null) {
            return;
        }
        this.award(advancement, player);
    }

    private void award(TFAdvancement advancement, Player player) {
        if (this.advancements.contains(advancement)) {
            advancement.awardTo(player);
        }
        this.removeAwarded();
    }

    private Player getPlayer() {
        if (this.playerId == null) {
            return null;
        }
        return this.getWorld().getPlayerByUUID(this.playerId);
    }

    public void write(CompoundTag nbt, HolderLookup.Provider registries, boolean clientPacket) {
        super.write(nbt, registries, clientPacket);
        if (this.playerId != null) {
            nbt.putUUID("Owner", this.playerId);
        }
    }

    public void read(CompoundTag nbt, HolderLookup.Provider registries, boolean clientPacket) {
        super.read(nbt, registries, clientPacket);
        if (nbt.contains("Owner")) {
            this.playerId = nbt.getUUID("Owner");
        }
    }

    public BehaviourType<?> getType() {
        return TYPE;
    }

    public static void tryAward(BlockGetter reader, BlockPos pos, TFAdvancement advancement) {
        TFAdvancementBehaviour behaviour = (TFAdvancementBehaviour)BlockEntityBehaviour.get((BlockGetter)reader, (BlockPos)pos, TYPE);
        if (behaviour != null) {
            behaviour.awardPlayer(advancement);
        }
    }

    public static void setPlacedBy(Level worldIn, BlockPos pos, LivingEntity placer) {
        TFAdvancementBehaviour behaviour = (TFAdvancementBehaviour)BlockEntityBehaviour.get((BlockGetter)worldIn, (BlockPos)pos, TYPE);
        if (behaviour == null) {
            return;
        }
        if (TFPlatformPredicates.isFakePlayer(placer)) {
            return;
        }
        if (placer instanceof ServerPlayer) {
            behaviour.setPlayer(placer.getUUID());
        }
    }
}

