package net.mehvahdjukaar.sawmill;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import net.mehvahdjukaar.moonlight.api.platform.network.NetworkHelper;
import net.mehvahdjukaar.moonlight.api.trades.SimpleItemListing;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_3222;
import net.minecraft.class_5455;
import net.minecraft.class_7701;
import net.minecraft.class_7706;
import net.minecraft.class_7923;
import net.minecraft.class_8786;
import org.jetbrains.annotations.Nullable;

import java.util.*;

public class RecipeSorter {

    private static final List<class_1792> ITEM_ORDER = new ArrayList<>();
    private static final Set<class_1792> UNSORTED = new HashSet<>();


    //called from server side by recipe stuff.
    public static void accept(List<class_8786<WoodcuttingRecipe>> sawmillRecipes) {
        UNSORTED.clear();
        sawmillRecipes.forEach(r -> UNSORTED.add(r.comp_1933().method_8110(class_5455.field_40585).method_7909()));
    }

    public static void acceptOrder(IntList list) {
        UNSORTED.clear();
        ITEM_ORDER.clear();
        list.forEach(i -> ITEM_ORDER.add(class_7923.field_41178.method_10200(i)));
    }

    // don't think we can repopulate off-thread
    public static void refreshIfNeeded(class_5455 reg) {
        if (UNSORTED.isEmpty()) return;
        ITEM_ORDER.clear();
        if (!class_7706.method_47328().method_47310()) {
            // this is NOT a client only method. Calling on server thread is valid.
            class_7706.method_47330(class_7701.field_40182, false, reg);
        }
        for (var t : class_7706.method_47335()) {
            List<class_1792> found = new ArrayList<>();
            var list = t.method_47313().stream().map(class_1799::method_7909).toList();
            for (class_1792 tabItem : list) {
                if (UNSORTED.contains(tabItem)) {
                    // if the item is in the tab, we can use its index to sort it
                    found.add(tabItem);
                    UNSORTED.remove(tabItem);
                }
            }
            ITEM_ORDER.addAll(found);
        }

        UNSORTED.clear();
    }


    public static void sort(List<class_8786<WoodcuttingRecipe>> recipes, class_1937 level) {
        if (CommonConfigs.SORT_RECIPES.get()) {
            //Just runs once if needed. Needs to be the same from server and client
            refreshIfNeeded(level.method_30349());

            recipes.sort(Comparator.comparingInt(r ->
                    ITEM_ORDER.indexOf(r.comp_1933().method_8110(class_5455.field_40585).method_7909())));
        }
    }

    public static void sendOrderToClient(@Nullable class_3222 player) {
        refreshIfNeeded(Utils.hackyGetRegistryAccess());
        IntList list = new IntArrayList();
        ITEM_ORDER.forEach(i -> list.add(class_7923.field_41178.method_10206(i)));
        NetworkStuff.SyncRecipeOrder message = new NetworkStuff.SyncRecipeOrder(list);
        if (player != null) {
            NetworkHelper.sendToClientPlayer(player, message);
        } else {
            NetworkHelper.sendToAllClientPlayers(message);
        }
    }
}
