package net.mehvahdjukaar.sawmill;

import net.mehvahdjukaar.moonlight.api.block.WaterBlock;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2498;
import net.minecraft.class_2561;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2766;
import net.minecraft.class_3620;
import net.minecraft.class_3726;
import net.minecraft.class_3908;
import net.minecraft.class_3914;
import net.minecraft.class_3965;
import net.minecraft.class_747;
import net.minecraft.world.level.block.*;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SawmillBlock extends WaterBlock {

    private static final class_2561 CONTAINER_TITLE = class_2561.method_43471("container.sawmill.sawmill");
    protected static final class_265 SHAPE_Z =
            class_259.method_1084(class_2248.method_9541(0.0, 0.0, 0.0, 16.0, 7.0, 16.0),
                    class_2248.method_9541(6.0, 7.0, 0.0, 10.0, 16.0, 16.0));
    protected static final class_265 SHAPE_X =
            class_259.method_1084(class_2248.method_9541(0.0, 0.0, 0.0, 16.0, 7.0, 16.0),
                    class_2248.method_9541(0.0, 7.0, 6.0, 16.0, 16.0, 10.0));

    protected static final class_265 SHAPE_Z_UP =
            class_259.method_1084(class_2248.method_9541(0.0, 9.0, 0.0, 16.0, 16.0, 16.0),
                    class_2248.method_9541(6.0, 0.0, 0.0, 10.0, 9.0, 16.0));
    protected static final class_265 SHAPE_X_UP =
            class_259.method_1084(class_2248.method_9541(0.0, 9.0, 0.0, 16.0, 16.0, 16.0),
                    class_2248.method_9541(0.0, 0.0, 6.0, 16.0, 9.0, 10.0));

    public static final class_2746 BOTTOM = class_2741.field_16562;
    public static final class_2753 FACING = class_2741.field_12481;

    public SawmillBlock() {
        super(class_2251.method_9637()
                .method_36557(2.5f)
                .method_36558(2.5f)
                .method_9626(class_2498.field_11547).method_31710(class_3620.field_15996).method_51368(class_2766.field_12651));
        this.method_9590(this.field_10647.method_11664().method_11657(FACING, class_2350.field_11043)
                .method_11657(WATERLOGGED, false)
                .method_11657(BOTTOM, true));

    }

    @Override
    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return state.method_11657(FACING, rotation.method_10503(state.method_11654(FACING)));
    }

    @Override
    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return state.method_26186(mirror.method_10345(state.method_11654(FACING)));
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(FACING, BOTTOM);
    }

    @Override
    public class_2680 method_9605(class_1750 context) {
        class_2680 blockState = super.method_9605(context)
                .method_11657(FACING, context.method_8042().method_10153());
        class_2338 blockPos = context.method_8037();
        class_2350 direction = context.method_8038();
        return direction != class_2350.field_11033 && (direction == class_2350.field_11036 ||
                context.method_17698().field_1351 - blockPos.method_10264() <= 0.5) ? blockState :
                blockState.method_11657(BOTTOM, false);
    }

    @Override
    protected class_1269 method_55766(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_3965 hitResult) {
        if (level.field_9236) {
            return class_1269.field_5812;
        } else {
            player.method_17355(state.method_26196(level, pos));
            //player.awardStat(Stats.INTERACT_WITH_STONECUTTER);
            return class_1269.field_21466;
        }
    }

    @Nullable
    public class_3908 method_17454(class_2680 state, class_1937 level, class_2338 pos) {
        return new class_747((i, inventory, player) ->
                new SawmillMenu(i, inventory, class_3914.method_17392(level, pos)), CONTAINER_TITLE);
    }

    @Override
    public class_265 method_9530(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        if (state.method_11654(BOTTOM)) {
            return state.method_11654(FACING).method_10166() == class_2350.class_2351.field_11048 ? SHAPE_Z : SHAPE_X;
        } else {
            return state.method_11654(FACING).method_10166() == class_2350.class_2351.field_11048 ? SHAPE_Z_UP : SHAPE_X_UP;
        }
    }

    @Override
    public boolean method_9526(class_2680 state) {
        return true;
    }

}
