package net.mehvahdjukaar.sawmill.integration.rei;

import com.google.common.collect.Lists;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.util.EntryStacks;
import net.mehvahdjukaar.sawmill.SawmillMod;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import java.util.List;


public class WoodcuttingCategory implements DisplayCategory<WoodcuttingDisplay> {
    @Override
    public CategoryIdentifier<? extends WoodcuttingDisplay> getCategoryIdentifier() {
        return REIPlugin.WOODCUTTING_DISPLAY;
    }

    @Override
    public Renderer getIcon() {
        return EntryStacks.of(SawmillMod.SAWMILL_BLOCK.get());
    }

    @Override
    public class_2561 getTitle() {
        return class_2561.method_43471("sawmill.category.wood_cutting");
    }

    @Override
    public List<Widget> setupDisplay(WoodcuttingDisplay display, Rectangle bounds) {
        Point startPoint = new Point(bounds.getCenterX() - 41, bounds.getCenterY() - 13);
        List<Widget> widgets = Lists.newArrayList();
        widgets.add(Widgets.createRecipeBase(bounds));
        widgets.add(Widgets.createArrow(new Point(startPoint.x + 27, startPoint.y + 4)));
        widgets.add(Widgets.createResultSlotBackground(new Point(startPoint.x + 61, startPoint.y + 5)));
        widgets.add(Widgets.createSlot(new Point(startPoint.x + 61, startPoint.y + 5))
                .entries(display.getOutputEntries().get(0))
                .disableBackground()
                .markOutput());
        Point point = new Point(startPoint.x + 4, startPoint.y + 5);
        widgets.add(Widgets.createSlot(point)
                .entries(display.getInputEntries().get(0)).markInput());
        widgets.add(new Widget() {
            @Override
            public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
                guiGraphics.method_51431(class_310.method_1551().field_1772,
                        new class_1799(class_1802.field_8831, display.getInputCount()), point.x,point.y);
            }

            @Override
            public List<? extends class_364> method_25396() {
                return List.of();
            }
        });
        return widgets;
    }

    @Override
    public int getDisplayHeight() {
        return 36;
    }

}
