package net.mehvahdjukaar.sawmill.mixins.fabric;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.JsonElement;
import net.mehvahdjukaar.sawmill.SawmillRecipeGenerator;
import net.minecraft.class_1863;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_3956;
import net.minecraft.class_8786;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.Map;

@Mixin(class_1863.class)
public class RecipeManagerMixin {
    @Shadow
    private Map<class_2960, class_8786<?>> byName;

    @Shadow
    private Multimap<class_3956<?>, class_8786<?>> byType;

    @Inject(method = "apply(Ljava/util/Map;Lnet/minecraft/server/packs/resources/ResourceManager;Lnet/minecraft/util/profiling/ProfilerFiller;)V",
            at = @At(value = "INVOKE_ASSIGN",
                    target = "Lcom/google/common/collect/ImmutableMap$Builder;build()Lcom/google/common/collect/ImmutableMap;",
                    shift = At.Shift.AFTER))
    public void sawmill$addRecipes(Map<class_2960, JsonElement> object, class_3300 resourceManager, class_3695 profiler, CallbackInfo ci) {
        ImmutableMap.Builder<class_2960, class_8786<?>> byNameCopy = ImmutableMap.builder();
        ImmutableMultimap.Builder<class_3956<?>, class_8786<?>> byTypeCopy = ImmutableMultimap.builder();
        this.byName.values().forEach(r -> {
            byNameCopy.put(r.comp_1932(), r);
            byTypeCopy.put(r.comp_1933().method_17716(), r);
        });
        SawmillRecipeGenerator.INSTANCE.process(this.byName.values(), byNameCopy, byTypeCopy);
        this.byName = byNameCopy.build();
        this.byType = byTypeCopy.build();
    }
}
