/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.sawmill;

import com.google.common.collect.ImmutableSet;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.mehvahdjukaar.moonlight.api.platform.PlatHelper;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.sawmill.CommonConfigs;
import net.mehvahdjukaar.sawmill.NetworkStuff;
import net.mehvahdjukaar.sawmill.SawmillBlock;
import net.mehvahdjukaar.sawmill.SawmillClient;
import net.mehvahdjukaar.sawmill.SawmillMenu;
import net.mehvahdjukaar.sawmill.SawmillRecipeGenerator;
import net.mehvahdjukaar.sawmill.WoodcuttingRecipe;
import net.mehvahdjukaar.sawmill.fabric.SawmillModImpl;
import net.mehvahdjukaar.sawmill.trades.CarpenterTrades;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3505;
import net.minecraft.class_3852;
import net.minecraft.class_3917;
import net.minecraft.class_3956;
import net.minecraft.class_4158;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7706;
import net.minecraft.class_7924;
import net.minecraft.class_8786;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SawmillMod {
    public static final String MOD_ID = "sawmill";
    public static final Logger LOGGER = LogManager.getLogger((String)"Sawmill");
    private static final boolean RS_ON = PlatHelper.isModLoaded((String)"repurposed_structures");
    public static final Supplier<class_2248> SAWMILL_BLOCK = RegHelper.registerBlockWithItem((class_2960)SawmillMod.res("sawmill"), SawmillBlock::new);
    public static final Supplier<class_3917<SawmillMenu>> SAWMILL_MENU = RegHelper.registerMenuType((class_2960)SawmillMod.res("sawmill"), SawmillMenu::new);
    public static final Supplier<class_3414> SAWMILL_TAKE = RegHelper.registerSound((class_2960)SawmillMod.res("ui.sawmill.take_result"));
    public static final Supplier<class_3414> SAWMILL_SELECT = RegHelper.registerSound((class_2960)SawmillMod.res("ui.sawmill.select_recipe"));
    public static final Supplier<class_3414> CARPENTER_WORK = RegHelper.registerSound((class_2960)SawmillMod.res("entity.villager.work_carpenter"));
    public static final Supplier<class_1865<WoodcuttingRecipe>> WOODCUTTING_RECIPE_SERIALIZER = RegHelper.registerRecipeSerializer((class_2960)SawmillMod.res("woodcutting"), WoodcuttingRecipe.Serializer::new);
    public static final Supplier<class_3956<WoodcuttingRecipe>> WOODCUTTING_RECIPE = RegHelper.registerRecipeType((class_2960)SawmillMod.res("woodcutting"));
    public static final class_5321<class_4158> CARPENTER_POI_KEY = class_5321.method_29179((class_5321)class_7924.field_41212, (class_2960)SawmillMod.res("carpenter"));
    public static final Supplier<class_4158> CARPENTER_POI = RegHelper.registerPOI((class_2960)SawmillMod.res("carpenter"), () -> new class_4158(new HashSet(SAWMILL_BLOCK.get().method_9595().method_11662()), 1, 1));
    public static final Supplier<class_3852> CARPENTER = SawmillMod.registerVillager("carpenter", CARPENTER_POI_KEY, CARPENTER_WORK);
    public static final class_6862<class_1792> BLACKLIST = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)SawmillMod.res("blacklist"));
    private static final Object lock = new Object();
    private static boolean receivedTags = false;
    private static final Map<class_2960, Collection<class_6880<?>>> tags = new HashMap();
    private static final Map<class_6862<class_1792>, List<class_1799>> cachedTags = new HashMap<class_6862<class_1792>, List<class_1799>>();
    private static final Map<class_3956<?>, Boolean> cachedWhitelist = new HashMap();
    private static final List<class_6880<class_3956<?>>> whitelist = new ArrayList();

    private static Supplier<class_3852> registerVillager(String name, class_5321<class_4158> jobSite, Supplier<class_3414> workSound) {
        return RegHelper.register((class_2960)SawmillMod.res(name), () -> new class_3852(name, holder -> holder.method_40225(jobSite), holder -> holder.method_40225(jobSite), ImmutableSet.of(), ImmutableSet.of(), (class_3414)workSound.get()), (class_5321)class_7924.field_41234);
    }

    public static void init() {
        if (PlatHelper.getPhysicalSide().isClient()) {
            SawmillClient.init();
        }
        NetworkStuff.init();
        CarpenterTrades.init();
        CommonConfigs.init();
        RegHelper.registerSimpleRecipeCondition((class_2960)SawmillMod.res("flag"), ignored -> {
            if (ignored.equals("rs_compat")) {
                return CommonConfigs.RS_COMPAT.get();
            }
            return false;
        });
        RegHelper.addItemsToTabsRegistration(event -> event.addAfter(class_7706.field_40197, stack -> stack.method_31574(class_1802.field_16305), new class_1935[]{SAWMILL_BLOCK.get().method_8389()}));
        SawmillRecipeGenerator.init();
    }

    public static class_2960 res(String name) {
        return class_2960.method_60655((String)MOD_ID, (String)name);
    }

    public static Collection<class_1799> getTagElements(class_6862<class_1792> tag) {
        return cachedTags.computeIfAbsent(tag, t -> {
            Collection<class_6880<?>> tagList = tags.get(t.comp_327());
            if (tagList == null) {
                return List.of();
            }
            return tagList.stream().map(h -> ((class_1792)h.comp_349()).method_7854()).toList();
        });
    }

    public static void clearTagHacks() {
        whitelist.clear();
        cachedTags.clear();
        cachedWhitelist.clear();
        receivedTags = false;
    }

    public static boolean isWhitelisted(class_8786<?> recipe) {
        boolean ret = cachedWhitelist.computeIfAbsent(recipe.comp_1933().method_17716(), recipeType -> whitelist.stream().anyMatch(h -> h.comp_349() == recipeType));
        if (ret && CommonConfigs.MOD_BLACKLIST.get().contains(recipe.comp_1932().method_12836())) {
            return false;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setTagManagerResults(List<class_3505.class_6863<?>> results) {
        Object object = lock;
        synchronized (object) {
            tags.clear();
            for (class_3505.class_6863<?> r : results) {
                if (r.comp_328() != class_7924.field_41197) continue;
                for (Map.Entry e : r.comp_329().entrySet()) {
                    tags.computeIfAbsent((class_2960)e.getKey(), y -> new ArrayList()).addAll((Collection)e.getValue());
                }
            }
            for (class_3505.class_6863<?> r : results) {
                if (r.comp_328() != class_7924.field_41217) continue;
                Collection whitelistTag = (Collection)r.comp_329().get(SawmillMod.res("whitelist"));
                whitelist.addAll(whitelistTag.stream().map(holder -> holder).toList());
                break;
            }
            receivedTags = true;
            lock.notifyAll();
        }
        LOGGER.info("Intercepted tag results");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForTags() {
        Object object = lock;
        synchronized (object) {
            if (!receivedTags) {
                try {
                    LOGGER.info("Waiting for tags");
                    lock.wait();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("Sawmill error:", e);
                }
            }
        }
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isVanillaIngredient(class_1856 ing) {
        return SawmillModImpl.isVanillaIngredient(ing);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Object getCustomIngredient(class_1856 ing) {
        return SawmillModImpl.getCustomIngredient(ing);
    }
}

