/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.sawmill;

import com.google.common.base.Stopwatch;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.mehvahdjukaar.moonlight.api.platform.RegHelper;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicResourcesProvider;
import net.mehvahdjukaar.moonlight.api.resources.pack.DynamicServerResourceProvider;
import net.mehvahdjukaar.moonlight.api.resources.pack.IEditablePackResources;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceGenTask;
import net.mehvahdjukaar.moonlight.api.resources.pack.ResourceSink;
import net.mehvahdjukaar.moonlight.api.resources.recipe.BlockTypeSwapIngredient;
import net.mehvahdjukaar.moonlight.api.set.wood.VanillaWoodTypes;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.sawmill.CommonConfigs;
import net.mehvahdjukaar.sawmill.RecipeSorter;
import net.mehvahdjukaar.sawmill.SawmillMod;
import net.mehvahdjukaar.sawmill.WoodcuttingRecipe;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_3489;
import net.minecraft.class_3532;
import net.minecraft.class_3956;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8786;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SawmillRecipeGenerator
extends DynamicServerResourceProvider {
    public static final SawmillRecipeGenerator INSTANCE = new SawmillRecipeGenerator();
    private boolean willRegenThisReload = false;

    protected SawmillRecipeGenerator() {
        super(SawmillMod.res("sawmill_recipes"), CommonConfigs.GEN_MODE.get().getStrategy());
    }

    public boolean willGeneratingRecipesThisReload() {
        return this.willRegenThisReload;
    }

    public static void init() {
        RegHelper.registerDynamicResourceProvider((DynamicResourcesProvider)INSTANCE);
    }

    protected Collection<String> gatherSupportedNamespaces() {
        return List.of("c");
    }

    public void regenerateDynamicAssets(Consumer<ResourceGenTask> executor) {
        executor.accept((a, b) -> SawmillMod.LOGGER.info("Scheduling Sawmill recipe generation"));
        this.willRegenThisReload = true;
    }

    private void saveRecipesToPack(List<class_8786<WoodcuttingRecipe>> sawmillRecipes) {
        SawmillMod.LOGGER.info("Saving {} Sawmill Recipes to resource pack", (Object)sawmillRecipes.size());
        ResourceSink sink = new ResourceSink("dummy", "dummy");
        for (class_8786<WoodcuttingRecipe> r : sawmillRecipes) {
            sink.addRecipe(r);
        }
        ResourceSink.acceptSinks((IEditablePackResources)this.packResources, List.of(sink));
        this.packResources.commitChanges();
    }

    public void process(Collection<class_8786<?>> recipes, ImmutableMap.Builder<class_2960, class_8786<?>> byName, ImmutableMultimap.Builder<class_3956<?>, class_8786<?>> byType) {
        SawmillMod.LOGGER.info("Processing Sawmill Recipes into Recipe Manager");
        List<class_8786<WoodcuttingRecipe>> sawmillRecipes = this.process(recipes);
        for (class_8786<WoodcuttingRecipe> r : sawmillRecipes) {
            try {
                byName.put((Object)r.comp_1932(), r);
                byType.put((Object)((WoodcuttingRecipe)r.comp_1933()).method_17716(), r);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to add sawmill recipe " + String.valueOf(r.comp_1932()), e);
            }
        }
    }

    public List<class_8786<WoodcuttingRecipe>> process(Collection<class_8786<?>> recipes) {
        if (!this.willRegenThisReload) {
            SawmillMod.LOGGER.info("Skipping Sawmill recipe generation as packs didn't change");
            ArrayList<class_8786<WoodcuttingRecipe>> existing = new ArrayList<class_8786<WoodcuttingRecipe>>();
            for (class_8786<?> r : recipes) {
                if (!(r.comp_1933() instanceof WoodcuttingRecipe)) continue;
                existing.add(r);
            }
            RecipeSorter.accept(existing);
            return List.of();
        }
        this.willRegenThisReload = false;
        SawmillMod.waitForTags();
        SawmillMod.LOGGER.info("Generating Sawmill Recipes");
        Stopwatch stopwatch = Stopwatch.createStarted();
        Map<class_1792, Map<WoodType, LogCost>> costs = SawmillRecipeGenerator.createIngredientList(recipes, true);
        int maxWoods = WoodTypeRegistry.INSTANCE.method_10204();
        class_1856 anyPlanks = class_1856.method_8106((class_6862)class_3489.field_15537);
        class_1856 anyWood = class_1856.method_8106((class_6862)class_3489.field_15539);
        ArrayList<class_8786<WoodcuttingRecipe>> sawmillRecipes = new ArrayList<class_8786<WoodcuttingRecipe>>();
        HashMap<WoodType, class_1856> logIngredients = new HashMap<WoodType, class_1856>();
        HashMap<WoodType, class_1856> plankIngredients = new HashMap<WoodType, class_1856>();
        String group = "logs";
        String group2 = "planks";
        for (Map.Entry<class_1792, Map<WoodType, LogCost>> entry : costs.entrySet()) {
            class_1792 result = entry.getKey();
            String itemId = Utils.getID((class_1792)result).method_36181();
            int counter = 0;
            Map<WoodType, LogCost> logCosts = entry.getValue();
            if (!CommonConfigs.ALLOW_NON_VARIANTS.get().booleanValue() && logCosts.size() != 1) continue;
            if (logCosts.size() == maxWoods) {
                LogCost m = logCosts.get(VanillaWoodTypes.OAK);
                SawmillRecipeGenerator.addNewRecipe(sawmillRecipes, anyWood, group, result, itemId, counter++, m.cost, false);
                SawmillRecipeGenerator.addNewRecipe(sawmillRecipes, anyPlanks, group2, result, itemId, counter++, SawmillRecipeGenerator.getPlanksCost(VanillaWoodTypes.OAK, m), true);
                continue;
            }
            for (LogCost m : logCosts.values()) {
                class_1856 plankInput;
                WoodType woodType = m.type;
                class_1856 logInput = SawmillRecipeGenerator.getOrCreateLogIngredient(logIngredients, woodType);
                if (!logInput.method_8093(result.method_7854())) {
                    SawmillRecipeGenerator.addNewRecipe(sawmillRecipes, logInput, group, result, itemId, counter++, m.cost, false);
                }
                if ((plankInput = SawmillRecipeGenerator.getOrCreatePlankIngredient(plankIngredients, woodType)).method_8093(result.method_7854())) continue;
                SawmillRecipeGenerator.addNewRecipe(sawmillRecipes, plankInput, group2, result, itemId, counter++, SawmillRecipeGenerator.getPlanksCost(woodType, m), true);
            }
        }
        for (WoodType type : WoodTypeRegistry.INSTANCE) {
            int counter = 0;
            SawmillRecipeGenerator.addLogRecipe(sawmillRecipes, type, counter++, "log", "stripped_log");
            SawmillRecipeGenerator.addLogRecipe(sawmillRecipes, type, counter++, "log", "stripped_wood");
            SawmillRecipeGenerator.addLogRecipe(sawmillRecipes, type, counter++, "log", "wood");
            SawmillRecipeGenerator.addLogRecipe(sawmillRecipes, type, counter++, "wood", "log");
            SawmillRecipeGenerator.addLogRecipe(sawmillRecipes, type, counter++, "wood", "stripped_wood");
            SawmillRecipeGenerator.addLogRecipe(sawmillRecipes, type, counter++, "wood", "stripped_log");
            SawmillRecipeGenerator.addLogRecipe(sawmillRecipes, type, counter++, "stripped_wood", "stripped_log");
            SawmillRecipeGenerator.addLogRecipe(sawmillRecipes, type, counter++, "stripped_log", "stripped_wood");
        }
        long millis = stopwatch.elapsed().toMillis();
        SawmillMod.LOGGER.info("Generated Sawmill recipes in {} milliseconds (cac mode {})", (Object)millis, (Object)this.generationStrategy);
        SawmillMod.clearTagHacks();
        this.saveRecipesToPack(sawmillRecipes);
        RecipeSorter.accept(sawmillRecipes);
        return sawmillRecipes;
    }

    private static double getPlanksCost(WoodType type, LogCost m) {
        if (type.getTypeName().equals("bamboo")) {
            return m.cost * 2.0;
        }
        return m.cost * 4.0;
    }

    private static void addLogRecipe(List<class_8786<WoodcuttingRecipe>> sawmillRecipes, WoodType type, int counter, String from, String to) {
        class_1792 fromLog = type.getItemOfThis(from);
        class_1792 toLog = type.getItemOfThis(to);
        if (fromLog != null && toLog != null) {
            SawmillRecipeGenerator.addNewRecipe(sawmillRecipes, class_1856.method_8091((class_1935[])new class_1935[]{fromLog}), "log", toLog, type.getAppendableId() + "_log", counter, 1.0, true);
        }
    }

    private static void addNewRecipe(List<class_8786<WoodcuttingRecipe>> sawmillRecipes, class_1856 input, String group, class_1792 result, String itemId, int counter, double cost, boolean only1on1) {
        int maxStackSize = (Integer)result.method_57347().method_57830(class_9334.field_50071, (Object)1);
        InputOutputCost resCost = SawmillRecipeGenerator.getInputOutputCost(cost, maxStackSize);
        int inputCount = resCost.inputCount();
        int outputCount = resCost.outputCount();
        if (only1on1 && inputCount != 1 && CommonConfigs.PLANKS_ONLY_ONE.get().booleanValue()) {
            return;
        }
        if (outputCount > 0) {
            if (!only1on1) {
                // empty if block
            }
            class_2960 res = SawmillMod.res(itemId + "_" + counter);
            if (inputCount <= 64) {
                WoodcuttingRecipe recipe = new WoodcuttingRecipe(group, input, new class_1799((class_1935)result, outputCount), inputCount);
                sawmillRecipes.add((class_8786<WoodcuttingRecipe>)new class_8786(res, (class_1860)recipe));
            }
        }
    }

    @NotNull
    private static InputOutputCost getInputOutputCost(double cost, int maxOutputCount) {
        int inputCount = 1;
        int outputCount = 0;
        double maxDiscount = CommonConfigs.MAX_DISCOUNT.get();
        if (cost > 1.0 + maxDiscount) {
            return new InputOutputCost((int)cost, 1);
        }
        double preciseOutputCount = 1.0 / cost;
        double discountedOutput = 1.0 / (cost /= 1.0 + maxDiscount);
        double considerDiscountThreshold = 0.25;
        if ((outputCount += (int)Math.round(preciseOutputCount % 1.0 > considerDiscountThreshold ? (preciseOutputCount + discountedOutput) / 2.0 : preciseOutputCount)) > maxOutputCount) {
            double ratio = (double)maxOutputCount / (double)outputCount;
            outputCount = maxOutputCount;
            inputCount = class_3532.method_15384((double)((double)inputCount * ratio));
        }
        return new InputOutputCost(inputCount, outputCount);
    }

    private static class_1856 getOrCreatePlankIngredient(Map<WoodType, class_1856> cache, WoodType type) {
        return cache.computeIfAbsent(type, t -> {
            List<class_1792> children = SawmillRecipeGenerator.getAllChildren(type, "planks", "quark:vertical_planks");
            return class_1856.method_8091((class_1935[])((class_1935[])children.toArray(class_1792[]::new)));
        });
    }

    private static class_1856 getOrCreateLogIngredient(Map<WoodType, class_1856> cache, WoodType type) {
        return cache.computeIfAbsent(type, t -> {
            if (t.getTypeName().equals("archwood")) {
                return class_1856.method_8106((class_6862)class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)class_2960.method_60654((String)"c:logs/archwood")));
            }
            List<class_1792> children = SawmillRecipeGenerator.getAllChildren(type, "log", "wood", "stripped_log", "stripped_wood");
            return class_1856.method_8091((class_1935[])((class_1935[])children.toArray(class_1792[]::new)));
        });
    }

    private static Map<class_1792, Map<WoodType, LogCost>> createIngredientList(Collection<class_8786<?>> recipes, boolean optim) {
        HashMap<class_1792, Map<WoodType, LogCost>> itemToPrimitiveCost = new HashMap<class_1792, Map<WoodType, LogCost>>();
        for (WoodType type : WoodTypeRegistry.INSTANCE) {
            Map<WoodType, LogCost> logCostInLog = Map.of(type, LogCost.of(type, 1.0));
            List<class_1792> children = SawmillRecipeGenerator.getAllChildren(type, "log", "wood", "stripped_log", "stripped_wood");
            children.forEach(item -> itemToPrimitiveCost.put((class_1792)item, logCostInLog));
            itemToPrimitiveCost.computeIfAbsent(class_1802.field_8600, s -> new HashMap()).put(type, LogCost.of(type, 0.125));
        }
        SawmillRecipeGenerator.addHardcodedCosts(itemToPrimitiveCost);
        HashSet validRecipes = new HashSet();
        HashSet<class_1792> craftableItems = new HashSet<class_1792>();
        boolean allowNonBlocks = CommonConfigs.ALLOW_NON_BLOCKS.get();
        for (class_8786<?> recipe : recipes) {
            if (!SawmillMod.isWhitelisted(recipe)) continue;
            try {
                class_1860 class_18602 = recipe.comp_1933();
                class_1792 i = class_18602.method_8110((class_7225.class_7874)class_5455.field_40585).method_7909();
                if (!allowNonBlocks && !(i instanceof class_1747)) continue;
                if (!class_18602.method_8117().isEmpty()) {
                    craftableItems.add(i);
                    validRecipes.add(class_18602);
                    continue;
                }
                boolean bl = true;
            }
            catch (Exception exception) {}
        }
        if (optim) {
            SawmillRecipeGenerator.removeUnNeded(itemToPrimitiveCost, validRecipes, craftableItems);
        }
        craftableItems.clear();
        HashMultimap itemsToRecipe = HashMultimap.create();
        for (class_1860 class_18603 : validRecipes) {
            class_1792 res = class_18603.method_8110((class_7225.class_7874)class_5455.field_40585).method_7909();
            itemsToRecipe.put((Object)res, (Object)class_18603);
            craftableItems.add(res);
        }
        for (class_1792 class_17922 : craftableItems) {
            SawmillRecipeGenerator.getPrimitiveCostRecursive(class_17922, itemsToRecipe, itemToPrimitiveCost, new HashSet(), 0);
        }
        itemToPrimitiveCost.values().removeIf(Objects::isNull);
        return itemToPrimitiveCost;
    }

    private static void addHardcodedCosts(Map<class_1792, Map<WoodType, LogCost>> itemToPrimitiveCost) {
        HashMap<String, Double> specialCosts = new HashMap<String, Double>(CommonConfigs.SPECIAL_COSTS.get());
        Iterator iter = specialCosts.entrySet().iterator();
        while (iter.hasNext()) {
            Optional opt;
            Map.Entry c = iter.next();
            String id = (String)c.getKey();
            double costInLogs = (Double)c.getValue() / 4.0;
            boolean hasWood = false;
            for (WoodType type2 : WoodTypeRegistry.INSTANCE) {
                class_1792 woodItem = type2.getItemOfThis(id);
                if (woodItem == null) continue;
                Map<WoodType, LogCost> stairsCostInLog = Map.of(type2, LogCost.of(type2, costInLogs));
                itemToPrimitiveCost.put(woodItem, stairsCostInLog);
                hasWood = true;
            }
            if (!hasWood && (opt = class_7923.field_41178.method_17966(class_2960.method_60654((String)id))).isPresent()) {
                Map cost = WoodTypeRegistry.INSTANCE.getValues().stream().collect(Collectors.toMap(Function.identity(), type -> LogCost.of(type, costInLogs)));
                itemToPrimitiveCost.put((class_1792)opt.get(), cost);
            }
            iter.remove();
        }
    }

    private static void removeUnNeded(Map<class_1792, Map<WoodType, LogCost>> itemToPrimitiveCost, Set<class_1860<?>> validRecipes, Set<class_1792> craftableItems) {
        Iterator<class_1860<?>> iterator = validRecipes.iterator();
        block0: while (iterator.hasNext()) {
            class_1860<?> recipe = iterator.next();
            for (class_1856 ing : recipe.method_8117()) {
                if (ing.method_8103()) continue;
                boolean atLeastOneCorrect = false;
                for (class_1799 alternative : SawmillRecipeGenerator.getIngItems(ing)) {
                    class_1792 a = alternative.method_7909();
                    if (!itemToPrimitiveCost.containsKey(a) && !craftableItems.contains(a)) continue;
                    atLeastOneCorrect = true;
                }
                if (atLeastOneCorrect) continue;
                iterator.remove();
                continue block0;
            }
        }
    }

    @NotNull
    private static class_1799[] getIngItems(class_1856 ing) {
        class_1856.class_1859[] class_1859Array;
        ArrayList<class_1799> stacks = new ArrayList<class_1799>();
        boolean isVanilla = SawmillMod.isVanillaIngredient(ing);
        if (!isVanilla && (class_1859Array = SawmillMod.getCustomIngredient(ing)) instanceof BlockTypeSwapIngredient) {
            BlockTypeSwapIngredient bts = (BlockTypeSwapIngredient)class_1859Array;
            class_1799[] innerConverted = SawmillRecipeGenerator.getIngItems(bts.getInner());
            stacks.addAll(bts.convertItems(Arrays.stream(innerConverted).toList()));
        }
        if (!isVanilla) {
            return (class_1799[])stacks.toArray(class_1799[]::new);
        }
        boolean isTag = false;
        if (isVanilla) {
            for (class_1856.class_1859 v : ing.field_9019) {
                if (!(v instanceof class_1856.class_1858)) continue;
                class_1856.class_1858 tv = (class_1856.class_1858)v;
                isTag = true;
                class_6862 tag = tv.comp_1931;
                stacks.addAll(SawmillMod.getTagElements((class_6862<class_1792>)tag));
            }
        }
        if (!isTag) {
            stacks.addAll(List.of(ing.method_8105()));
            ing.field_9018 = null;
        }
        return (class_1799[])stacks.toArray(class_1799[]::new);
    }

    private static List<class_1792> getAllChildren(WoodType type, String ... keys) {
        ArrayList<class_1792> children = new ArrayList<class_1792>();
        for (String k : keys) {
            Object child = type.getChild(k);
            if (!(child instanceof class_1935)) continue;
            class_1935 il = (class_1935)child;
            children.add(il.method_8389());
        }
        return children;
    }

    @Nullable
    public static Map<WoodType, LogCost> getPrimitiveCostRecursive(class_1792 itemToUncraft, Multimap<class_1792, class_1860<?>> allRecipes, Map<class_1792, Map<WoodType, LogCost>> cache, Set<class_1860<?>> visitedRecipes, int depth) {
        Map<WoodType, LogCost> cached = cache.get(itemToUncraft);
        if (cached != null) {
            return cached;
        }
        if (depth >= 10) {
            return null;
        }
        ArrayList<Map<WoodType, LogCost>> possibleCosts = new ArrayList<Map<WoodType, LogCost>>();
        Collection possibleRecipes = allRecipes.get((Object)itemToUncraft);
        block0: for (class_1860 recipe : possibleRecipes) {
            if (visitedRecipes.contains(recipe)) continue;
            visitedRecipes.add(recipe);
            HashMap recipeCostPerWood = new HashMap();
            for (class_1856 ingredient : recipe.method_8117()) {
                if (ingredient.method_8103()) continue;
                HashMap ingredientPossibleCosts = new HashMap();
                for (class_1799 ing : SawmillRecipeGenerator.getIngItems(ingredient)) {
                    Map<WoodType, LogCost> itemCost = SawmillRecipeGenerator.getPrimitiveCostRecursive(ing.method_7909(), allRecipes, cache, visitedRecipes, depth++);
                    if (itemCost == null) continue;
                    itemCost.forEach((woodType, logCost) -> ingredientPossibleCosts.merge(woodType, logCost, LogCost::min));
                }
                if (ingredientPossibleCosts.isEmpty()) continue block0;
                if (recipeCostPerWood.isEmpty()) {
                    recipeCostPerWood.putAll(ingredientPossibleCosts);
                    continue;
                }
                recipeCostPerWood.keySet().retainAll(ingredientPossibleCosts.keySet());
                if (recipeCostPerWood.isEmpty()) continue block0;
                recipeCostPerWood.forEach((key, val) -> recipeCostPerWood.merge(key, (LogCost)ingredientPossibleCosts.get(key), LogCost::sum));
            }
            int outputCount = recipe.method_8110((class_7225.class_7874)class_5455.field_40585).method_7947();
            recipeCostPerWood.replaceAll((woodType, logCost) -> logCost.divide(outputCount));
            possibleCosts.add(recipeCostPerWood);
        }
        Map<WoodType, LogCost> ret = null;
        if (!possibleCosts.isEmpty()) {
            ret = SawmillRecipeGenerator.chooseMinCost(possibleCosts);
        }
        cache.put(itemToUncraft, ret);
        return ret;
    }

    public static Map<WoodType, LogCost> chooseMinCost(List<Map<WoodType, LogCost>> possibleRecipeCosts) {
        HashMap<WoodType, LogCost> result = new HashMap<WoodType, LogCost>();
        for (Map<WoodType, LogCost> map : possibleRecipeCosts) {
            for (Map.Entry<WoodType, LogCost> entry : map.entrySet()) {
                WoodType key = entry.getKey();
                LogCost value = entry.getValue();
                result.merge(key, value, LogCost::min);
            }
        }
        return result;
    }

    public record LogCost(WoodType type, Double cost) {
        static LogCost of(WoodType type, Double amount) {
            return new LogCost(type, amount);
        }

        public LogCost sum(LogCost logCost) {
            return new LogCost(this.type, logCost.cost + this.cost);
        }

        public LogCost divide(double outputCount) {
            return new LogCost(this.type, this.cost / outputCount);
        }

        public static LogCost min(LogCost first, LogCost second) {
            return first.cost < second.cost ? first : second;
        }
    }

    private record InputOutputCost(int inputCount, int outputCount) {
    }
}

