/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.sawmill;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import net.mehvahdjukaar.sawmill.CommonConfigs;
import net.mehvahdjukaar.sawmill.FilterableRecipe;
import net.mehvahdjukaar.sawmill.SawmillMenu;
import net.mehvahdjukaar.sawmill.SawmillMod;
import net.mehvahdjukaar.sawmill.WoodcuttingRecipe;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_465;
import net.minecraft.class_7225;
import org.jetbrains.annotations.NotNull;

public class SawmillScreen
extends class_465<SawmillMenu> {
    private static final class_2960 BACKGROUND = SawmillMod.res("textures/gui/container/sawmill.png");
    private static final class_2960 BACKGROUND_SEARCH = SawmillMod.res("textures/gui/container/sawmill_search.png");
    private static final class_2960 BACKGROUND_WIDE = SawmillMod.res("textures/gui/container/sawmill_wide.png");
    private static final class_2960 BACKGROUND_WIDE_SEARCH = SawmillMod.res("textures/gui/container/sawmill_search_wide.png");
    private static final class_2960 SCROLLER_SPRITE = class_2960.method_60656((String)"container/stonecutter/scroller");
    private static final class_2960 SCROLLER_DISABLED_SPRITE = class_2960.method_60656((String)"container/stonecutter/scroller_disabled");
    private static final class_2960 RECIPE_SELECTED_SPRITE = class_2960.method_60656((String)"container/stonecutter/recipe_selected");
    private static final class_2960 RECIPE_HIGHLIGHTED_SPRITE = class_2960.method_60656((String)"container/stonecutter/recipe_highlighted");
    private static final class_2960 RECIPE_SPRITE = class_2960.method_60656((String)"container/stonecutter/recipe");
    private float scrollOffs;
    private boolean scrolling;
    private int startIndex;
    private boolean displayRecipes;
    private class_342 searchBox;
    private final List<FilterableRecipe> filteredRecipes = new ArrayList<FilterableRecipe>();
    private int filteredIndex = -1;

    public SawmillScreen(SawmillMenu sawmillMenu, class_1661 inventory, class_2561 component) {
        super((class_1703)sawmillMenu, inventory, component);
        sawmillMenu.registerUpdateListener(this::containerChanged);
        --this.field_25268;
    }

    protected void method_25426() {
        super.method_25426();
        int boxX = this.field_2776 + (((SawmillMenu)this.field_2797).isWide ? 41 : 53);
        int boxY = this.field_2800 + 15;
        this.searchBox = new class_342(this.field_22793, boxX, boxY, 69, 9, (class_2561)class_2561.method_43471((String)"itemGroup.search"));
        this.searchBox.method_1880(50);
        this.searchBox.method_1858(false);
        this.searchBox.method_25365(false);
        this.searchBox.method_1888(false);
        this.searchBox.method_1868(0xFFFFFF);
        this.searchBox.method_1863(s -> this.refreshSearchResults());
        this.method_37063((class_364)this.searchBox);
        this.updateSearchBarVisibility();
    }

    private void updateSearchBarVisibility() {
        boolean hasSearch;
        this.searchBox.field_22764 = hasSearch = CommonConfigs.hasSearchBar(((SawmillMenu)this.field_2797).getRecipes().size());
        this.searchBox.field_22763 = hasSearch;
    }

    protected void method_37432() {
        super.method_37432();
    }

    private void refreshSearchResults() {
        int oldSize = this.filteredRecipes.size();
        this.filteredRecipes.clear();
        String filter = this.searchBox.method_1882().toLowerCase(Locale.ROOT);
        boolean isFiltered = this.searchBox.field_22764 && !filter.equals("");
        for (FilterableRecipe r : ((SawmillMenu)this.field_2797).getRecipes()) {
            if (isFiltered && !r.matchFilter(filter)) continue;
            this.filteredRecipes.add(r);
        }
        if (oldSize != this.filteredRecipes.size()) {
            this.scrollOffs = 0.0f;
            this.startIndex = 0;
        }
        this.updateSelectedIndex();
        if (this.filteredIndex == -1 && ((SawmillMenu)this.field_2797).getSelectedRecipeIndex() != -1 && ((SawmillMenu)this.field_2797).method_7604((class_1657)this.field_22787.field_1724, -1)) {
            this.field_22787.field_1761.method_2900(((SawmillMenu)this.field_2797).field_7763, -1);
        }
        this.updateSearchBarVisibility();
    }

    private void updateSelectedIndex() {
        this.filteredIndex = -1;
        int selectedInd = ((SawmillMenu)this.field_2797).getSelectedRecipeIndex();
        List<FilterableRecipe> recipes = ((SawmillMenu)this.field_2797).getRecipes();
        if (selectedInd > -1 && selectedInd < recipes.size()) {
            this.filteredIndex = this.filteredRecipes.indexOf(recipes.get(selectedInd));
        }
    }

    public void method_25410(class_310 minecraft, int width, int height) {
        String string = this.searchBox.method_1882();
        this.method_25423(minecraft, width, height);
        this.searchBox.method_1852(string);
        this.containerChanged();
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        String string = this.searchBox.method_1882();
        if (this.searchBox.field_22764 && this.searchBox.method_25404(keyCode, scanCode, modifiers)) {
            if (!Objects.equals(string, this.searchBox.method_1882())) {
                this.refreshSearchResults();
            }
            return true;
        }
        return this.searchBox.method_25370() && this.searchBox.method_1885() && keyCode != 256 ? true : super.method_25404(keyCode, scanCode, modifiers);
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        this.method_2380(guiGraphics, mouseX, mouseY);
    }

    protected void method_2389(class_332 guiGraphics, float partialTick, int mouseX, int mouseY) {
        class_2960 bgLocation = this.getBgLocation();
        guiGraphics.method_25302(bgLocation, this.field_2776, this.field_2800, 0, 0, this.field_2792, this.field_2779);
        int barH = this.scrollBarHeight();
        int scrollY = this.minScrollY();
        float barSpan = this.maxScrollY() - scrollY - barH;
        int barPos = (int)(barSpan * this.scrollOffs);
        class_2960 resourceLocation = this.isScrollBarActive() ? SCROLLER_SPRITE : SCROLLER_DISABLED_SPRITE;
        guiGraphics.method_52706(resourceLocation, this.minScrollX(), scrollY + barPos, 12, barH);
        if (!this.displayRecipes) {
            return;
        }
        this.forEachButton((index, buttonX, buttonY) -> {
            class_2960 buttonTexture = index == this.filteredIndex ? RECIPE_SELECTED_SPRITE : (mouseX >= buttonX && mouseY >= buttonY && mouseX < buttonX + 16 && mouseY < buttonY + 18 ? RECIPE_HIGHLIGHTED_SPRITE : RECIPE_SPRITE);
            guiGraphics.method_52706(buttonTexture, buttonX, buttonY, 16, 18);
        });
        this.forEachButton((index, buttonX, buttonY) -> {
            class_1799 item = ((WoodcuttingRecipe)this.filteredRecipes.get(index).recipe().comp_1933()).method_8110((class_7225.class_7874)this.field_22787.field_1687.method_30349());
            guiGraphics.method_51445(item, buttonX, buttonY + 1);
            guiGraphics.method_51431(this.field_22793, item, buttonX, buttonY + 1);
        });
    }

    @NotNull
    private class_2960 getBgLocation() {
        if (((SawmillMenu)this.field_2797).isWide) {
            return this.searchBox.field_22764 ? BACKGROUND_WIDE_SEARCH : BACKGROUND_WIDE;
        }
        return this.searchBox.field_22764 ? BACKGROUND_SEARCH : BACKGROUND;
    }

    protected void method_2380(class_332 guiGraphics, int mouseX, int mouseY) {
        super.method_2380(guiGraphics, mouseX, mouseY);
        if (this.displayRecipes) {
            this.forEachButton((index, buttonX, buttonY) -> {
                if (mouseX >= buttonX && mouseX < buttonX + 16 && mouseY >= buttonY && mouseY < buttonY + 18) {
                    guiGraphics.method_51446(this.field_22793, ((WoodcuttingRecipe)this.filteredRecipes.get(index).recipe().comp_1933()).method_8110((class_7225.class_7874)this.field_22787.field_1687.method_30349()), mouseX, mouseY);
                }
            });
        }
    }

    protected void method_2388(class_332 guiGraphics, int mouseX, int mouseY) {
        int input;
        super.method_2388(guiGraphics, mouseX, mouseY);
        if (this.filteredIndex >= 0 && this.filteredIndex < this.filteredRecipes.size() && (input = ((WoodcuttingRecipe)this.filteredRecipes.get(this.filteredIndex).recipe().comp_1933()).getInputCount()) != 1) {
            String multiplier = input + "x";
            int labelX = this.field_25267 + (((SawmillMenu)this.field_2797).isWide ? -4 : 0);
            guiGraphics.method_51433(this.field_22793, multiplier, labelX, this.field_25268 + 37, 0x404040, false);
        }
    }

    private int getButtonCount() {
        return this.getRowCount() * this.getButtonsPerRow();
    }

    private int getButtonsPerRow() {
        return ((SawmillMenu)this.field_2797).isWide ? 5 : 4;
    }

    private int getRowCount() {
        return this.searchBox.field_22764 ? 2 : 3;
    }

    private int minScrollX() {
        return this.field_2776 + (((SawmillMenu)this.field_2797).isWide ? 123 : 119);
    }

    private int maxScrollX() {
        return this.minScrollX() + 12;
    }

    private int minScrollY() {
        return this.field_2800 + (this.searchBox.field_22764 ? 29 : 15);
    }

    private int maxScrollY() {
        return this.field_2800 + (this.searchBox.field_22764 ? 65 : 70);
    }

    private int scrollBarHeight() {
        return this.searchBox.field_22764 ? 11 : 15;
    }

    private void forEachButton(ButtonConsumer buttonConsumer) {
        int buttonBoxX = this.field_2776 + (((SawmillMenu)this.field_2797).isWide ? 40 : 52);
        int buttonBoxY = this.field_2800 + (this.searchBox.field_22764 ? 27 : 13);
        int lastVisibleElementIndex = this.startIndex + this.getButtonCount();
        int buttonsPerRow = this.getButtonsPerRow();
        for (int index = this.startIndex; index < lastVisibleElementIndex && index < this.filteredRecipes.size(); ++index) {
            int visualIndex = index - this.startIndex;
            int buttonX = buttonBoxX + visualIndex % buttonsPerRow * 16;
            int buttonY = buttonBoxY + visualIndex / buttonsPerRow * 18 + 2;
            buttonConsumer.accept(index, buttonX, buttonY);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        this.scrolling = false;
        if (this.displayRecipes) {
            AtomicReference<Boolean> success = new AtomicReference<Boolean>(false);
            this.forEachButton((index, buttonX, buttonY) -> {
                if (((Boolean)success.get()).booleanValue()) {
                    return;
                }
                int actualIndex = ((SawmillMenu)this.field_2797).getRecipes().indexOf(this.filteredRecipes.get(index));
                if (mouseX >= (double)buttonX && mouseX < (double)(buttonX + 16) && mouseY >= (double)buttonY && mouseY < (double)(buttonY + 18)) {
                    if (((SawmillMenu)this.field_2797).method_7604((class_1657)this.field_22787.field_1724, actualIndex)) {
                        class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)SawmillMod.SAWMILL_SELECT.get(), (float)1.0f));
                        this.field_22787.field_1761.method_2900(((SawmillMenu)this.field_2797).field_7763, actualIndex);
                        this.updateSelectedIndex();
                    }
                    success.set(true);
                }
            });
            if (success.get().booleanValue()) {
                return true;
            }
            if (mouseX >= (double)this.minScrollX() && mouseX < (double)this.maxScrollX() && mouseY >= (double)this.minScrollY() && mouseY < (double)this.maxScrollY()) {
                this.scrolling = true;
            }
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.scrolling && this.isScrollBarActive()) {
            int min = this.minScrollY();
            int max = this.maxScrollY();
            this.scrollOffs = ((float)mouseY - (float)min - 7.5f) / ((float)(max - min) - 15.0f);
            this.scrollOffs = class_3532.method_15363((float)this.scrollOffs, (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffs * (float)this.getOffscreenRows()) + 0.5) * this.getButtonsPerRow();
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.isScrollBarActive()) {
            int i = this.getOffscreenRows();
            float f = (float)scrollY / (float)i;
            this.scrollOffs = class_3532.method_15363((float)(this.scrollOffs - f), (float)0.0f, (float)1.0f);
            this.startIndex = (int)((double)(this.scrollOffs * (float)i) + 0.5) * this.getButtonsPerRow();
        }
        return true;
    }

    private boolean isScrollBarActive() {
        return this.displayRecipes && this.filteredRecipes.size() > this.getButtonCount();
    }

    protected int getOffscreenRows() {
        int buttonsPerRow = this.getButtonsPerRow();
        return (this.filteredRecipes.size() + buttonsPerRow - 1) / buttonsPerRow - this.getRowCount();
    }

    private void containerChanged() {
        this.displayRecipes = ((SawmillMenu)this.field_2797).hasInputItem();
        if (!this.displayRecipes) {
            this.scrollOffs = 0.0f;
            this.startIndex = 0;
            this.searchBox.method_1852("");
        } else {
            this.method_25395((class_364)this.searchBox);
        }
        this.searchBox.method_1888(this.displayRecipes);
        this.searchBox.method_25365(this.displayRecipes);
        this.refreshSearchResults();
    }

    private static interface ButtonConsumer {
        public void accept(int var1, int var2, int var3);
    }
}

