/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.sawmill.trades;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.mehvahdjukaar.moonlight.api.set.wood.VanillaWoodTypes;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.minecraft.class_1959;
import net.minecraft.class_2960;
import net.minecraft.class_3854;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_6899;
import net.minecraft.class_7924;

public final class BiomeToWoodList {
    private final Map<class_3854, List<WoodType>> map = new HashMap<class_3854, List<WoodType>>();
    private static final Codec<Map<class_6880<class_1959>, List<Either<String, Fallback>>>> BIOME_TO_WOODS = Codec.unboundedMap((Codec)class_6899.method_40400((class_5321)class_7924.field_41236), (Codec)Codec.list((Codec)Codec.either((Codec)Codec.STRING, Fallback.CODEC)));
    public static final Codec<BiomeToWoodList> CODEC = BIOME_TO_WOODS.xmap(BiomeToWoodList::new, list -> new HashMap());

    public List<WoodType> getWoodsForType(class_3854 villagerType) {
        return this.map.getOrDefault(villagerType, List.of(VanillaWoodTypes.OAK));
    }

    public BiomeToWoodList(Map<class_6880<class_1959>, List<Either<String, Fallback>>> map) {
        for (Map.Entry<class_6880<class_1959>, List<Either<String, Fallback>>> e : map.entrySet()) {
            WoodType t;
            class_3854 type = class_3854.method_16930(e.getKey());
            if (type == class_3854.field_17073 && e.getKey().method_55840().equals("minecraft:plains")) continue;
            ArrayList<String> tryAdd = new ArrayList<String>();
            ArrayList<Fallback> fallbacks = new ArrayList<Fallback>();
            for (Either<String, Fallback> v : e.getValue()) {
                if (v.left().isPresent()) {
                    tryAdd.add((String)v.left().get());
                    continue;
                }
                if (!v.right().isPresent()) continue;
                fallbacks.add((Fallback)v.right().get());
            }
            ArrayList<WoodType> woods = new ArrayList<WoodType>();
            for (String s : tryAdd) {
                t = null;
                class_2960 res = class_2960.method_12829((String)s);
                if (res != null) {
                    t = (WoodType)WoodTypeRegistry.INSTANCE.get(class_2960.method_60654((String)s));
                }
                if (t == null) {
                    Pattern matcher = Pattern.compile(s);
                    for (WoodType w : WoodTypeRegistry.INSTANCE) {
                        if (!matcher.matcher(w.id.toString()).find()) continue;
                        t = w;
                        break;
                    }
                }
                if (t == null) continue;
                woods.add(t);
            }
            if (woods.isEmpty()) {
                for (Fallback f : fallbacks) {
                    t = (WoodType)WoodTypeRegistry.INSTANCE.get(class_2960.method_60654((String)f.wood));
                    if (t == null) continue;
                    woods.add(t);
                    break;
                }
            }
            if (woods.isEmpty()) continue;
            this.map.put(type, woods);
        }
    }

    private record Fallback(String wood) {
        public static final Codec<Fallback> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.STRING.fieldOf("fallback").forGetter(Fallback::wood)).apply((Applicative)i, Fallback::new));
    }
}

