/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.sawmill.trades;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.set.wood.VanillaWoodTypes;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.trades.ModItemListing;
import net.mehvahdjukaar.sawmill.trades.BiomeToWoodList;
import net.minecraft.class_1297;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1914;
import net.minecraft.class_1935;
import net.minecraft.class_3851;
import net.minecraft.class_5699;
import net.minecraft.class_5819;
import net.minecraft.class_9306;
import org.jetbrains.annotations.Nullable;

public record BiomeWoodToItemListing(boolean buys, String childKey, int woodPrice, class_9306 emeralds, int maxTrades, int xp, float priceMult, int level, BiomeToWoodList biomeWoods) implements ModItemListing
{
    public static final MapCodec<BiomeWoodToItemListing> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Codec.BOOL.optionalFieldOf("buys", (Object)true).forGetter(BiomeWoodToItemListing::buys), (App)Codec.STRING.fieldOf("wood_block").forGetter(BiomeWoodToItemListing::childKey), (App)class_5699.field_33442.fieldOf("wood_block_amount").forGetter(BiomeWoodToItemListing::woodPrice), (App)class_9306.field_49393.fieldOf("emeralds").forGetter(BiomeWoodToItemListing::emeralds), (App)class_5699.field_33442.optionalFieldOf("max_trades", (Object)16).forGetter(BiomeWoodToItemListing::maxTrades), (App)class_5699.field_33442.optionalFieldOf("xp").forGetter(w -> Optional.of(w.xp)), (App)class_5699.field_34387.optionalFieldOf("price_multiplier", (Object)Float.valueOf(0.05f)).forGetter(BiomeWoodToItemListing::priceMult), (App)Codec.intRange((int)1, (int)5).optionalFieldOf("level", (Object)1).forGetter(BiomeWoodToItemListing::level), (App)BiomeToWoodList.CODEC.optionalFieldOf("biome_woods", (Object)new BiomeToWoodList(Map.of())).forGetter(BiomeWoodToItemListing::biomeWoods)).apply((Applicative)i, BiomeWoodToItemListing::createDefault));

    private static BiomeWoodToItemListing createDefault(boolean buys, String wood, int woodAmount, class_9306 emeralds, int maxTrades, Optional<Integer> xp, float priceMult, int level, BiomeToWoodList biomeWoods) {
        return new BiomeWoodToItemListing(buys, wood, woodAmount, emeralds, maxTrades, xp.orElse(ModItemListing.defaultXp((boolean)buys, (int)level)), priceMult, level, biomeWoods);
    }

    public boolean isValid() {
        return VanillaWoodTypes.OAK.getItemOfThis(this.childKey) != null;
    }

    public MapCodec<? extends ModItemListing> getCodec() {
        return CODEC;
    }

    private WoodType getTypeSpecificWoodType(class_1297 trader, class_5819 random) {
        if (trader instanceof class_3851) {
            class_3851 d = (class_3851)trader;
            List<WoodType> list = this.biomeWoods.getWoodsForType(d.method_7231().method_16919());
            return list.get(random.method_43048(list.size()));
        }
        return null;
    }

    @Nullable
    public class_1914 method_7246(class_1297 trader, class_5819 random) {
        WoodType type = this.getTypeSpecificWoodType(trader, random);
        if (type == null) {
            return null;
        }
        class_1792 woodItem = type.getItemOfThis(this.childKey);
        if (woodItem != null && woodItem != class_1802.field_8162) {
            class_9306 itemCost = new class_9306((class_1935)woodItem, this.woodPrice);
            class_9306 emerald = this.emeralds;
            if (this.buys) {
                return new class_1914(itemCost, Optional.empty(), emerald.comp_2427(), this.maxTrades, this.xp, this.priceMult);
            }
            return new class_1914(emerald, Optional.empty(), itemCost.comp_2427(), this.maxTrades, this.xp, this.priceMult);
        }
        return null;
    }

    public int getLevel() {
        return this.level;
    }
}

