/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.sawmill.trades;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.set.wood.VanillaWoodTypes;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodType;
import net.mehvahdjukaar.moonlight.api.set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.moonlight.api.trades.ModItemListing;
import net.minecraft.class_1297;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1914;
import net.minecraft.class_1935;
import net.minecraft.class_5699;
import net.minecraft.class_5819;
import net.minecraft.class_9306;
import org.jetbrains.annotations.Nullable;

public record RandomWoodToItemListing(boolean buys, String childKey, int woodPrice, class_9306 emeralds, int maxTrades, int xp, float priceMult, int level, List<WoodType> blacklist) implements ModItemListing
{
    public static final MapCodec<RandomWoodToItemListing> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)Codec.BOOL.optionalFieldOf("buys", (Object)true).forGetter(RandomWoodToItemListing::buys), (App)Codec.STRING.fieldOf("wood_block").forGetter(RandomWoodToItemListing::childKey), (App)class_5699.field_33442.fieldOf("wood_block_amount").forGetter(RandomWoodToItemListing::woodPrice), (App)class_9306.field_49393.fieldOf("emeralds").forGetter(RandomWoodToItemListing::emeralds), (App)class_5699.field_33442.optionalFieldOf("max_trades", (Object)16).forGetter(RandomWoodToItemListing::maxTrades), (App)class_5699.field_33442.optionalFieldOf("xp").forGetter(w -> Optional.of(w.xp)), (App)class_5699.field_34387.optionalFieldOf("price_multiplier", (Object)Float.valueOf(0.05f)).forGetter(RandomWoodToItemListing::priceMult), (App)Codec.intRange((int)1, (int)5).optionalFieldOf("level", (Object)1).forGetter(RandomWoodToItemListing::level), (App)WoodTypeRegistry.INSTANCE.getCodec().listOf().optionalFieldOf("wood_blacklist", List.of()).forGetter(RandomWoodToItemListing::blacklist)).apply((Applicative)i, RandomWoodToItemListing::createDefault));

    private static RandomWoodToItemListing createDefault(boolean buys, String wood, int woodAmount, class_9306 emeralds, int maxTrades, Optional<Integer> xp, float priceMult, int level, List<WoodType> blacklist) {
        return new RandomWoodToItemListing(buys, wood, woodAmount, emeralds, maxTrades, xp.orElse(ModItemListing.defaultXp((boolean)buys, (int)level)), priceMult, level, blacklist);
    }

    public boolean isValid() {
        return VanillaWoodTypes.OAK.getItemOfThis(this.childKey) != null;
    }

    public MapCodec<? extends ModItemListing> getCodec() {
        return CODEC;
    }

    @Nullable
    public class_1914 method_7246(class_1297 trader, class_5819 random) {
        WoodType type = null;
        ArrayList types = new ArrayList(WoodTypeRegistry.INSTANCE.getValues());
        int tries = 0;
        while (tries < 50 && !types.isEmpty()) {
            ++tries;
            if (type == null) {
                type = (WoodType)types.get(random.method_43048(types.size()));
            }
            types.remove(type);
            if (this.blacklist.contains(type)) {
                type = null;
                continue;
            }
            class_1792 woodItem = type.getItemOfThis(this.childKey);
            if (woodItem == null || woodItem == class_1802.field_8162) continue;
            class_9306 itemCost = new class_9306((class_1935)woodItem, this.woodPrice);
            class_9306 emerald = this.emeralds;
            if (this.buys) {
                return new class_1914(itemCost, Optional.empty(), emerald.comp_2427(), this.maxTrades, this.xp, this.priceMult);
            }
            return new class_1914(emerald, Optional.empty(), itemCost.comp_2427(), this.maxTrades, this.xp, this.priceMult);
        }
        return null;
    }

    public int getLevel() {
        return this.level;
    }
}

