/*
 * Decompiled with CFR 0.152.
 */
package dev.huey.chunkcleaner;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Waterlogged;
import org.bukkit.block.data.type.Chest;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public final class ChunkCleaner
extends JavaPlugin
implements Listener,
CommandExecutor,
TabCompleter {
    int cleanTaskId = -1;
    int y;
    ItemStack silkTouchTool = new ItemStack(Material.DIAMOND_PICKAXE);
    int lastProgress;
    TextComponent chatPrefix = (TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.text((String)"[").color((TextColor)NamedTextColor.GRAY)).append(Component.text((String)"Chunk").color((TextColor)NamedTextColor.YELLOW))).append(Component.text((String)"Cleaner").color((TextColor)NamedTextColor.GOLD))).append(Component.text((String)"] ").color((TextColor)NamedTextColor.GRAY));
    Set<Material> blacklist = Set.of(Material.BEDROCK, Material.AIR, Material.CHEST, Material.TRAPPED_CHEST, Material.BARREL, Material.END_PORTAL_FRAME, Material.SPAWNER, Material.TRIAL_SPAWNER, Material.VAULT);
    String pickDesc = "Mines a whole chunk";
    Map<UUID, Map<Long, Integer>> pickProgress = new HashMap<UUID, Map<Long, Integer>>();

    public void onEnable() {
        PluginCommand command = this.getCommand("chunkcleaner");
        if (command != null) {
            command.setExecutor((CommandExecutor)this);
        }
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.silkTouchTool.addUnsafeEnchantment(Enchantment.SILK_TOUCH, 1);
    }

    public void onDisable() {
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        if (args.length == 1) {
            List<String> completions = List.of("mine", "explode", "vanish", "getpickaxe");
            return completions.stream().filter(s -> s.startsWith(args[0].toLowerCase())).toList();
        }
        return List.of();
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (args.length >= 1) {
            switch (args[0]) {
                case "mine": {
                    if (!(sender instanceof Player)) {
                        return true;
                    }
                    Player pl = (Player)sender;
                    this.cleanChunkCommand(pl);
                    break;
                }
                case "vanish": {
                    if (!(sender instanceof Player)) {
                        return true;
                    }
                    Player pl = (Player)sender;
                    this.vanishChunkCommand(pl);
                    break;
                }
                case "explode": {
                    if (!(sender instanceof Player)) {
                        return true;
                    }
                    Player pl = (Player)sender;
                    this.explodeChunkCommand(pl);
                    break;
                }
                case "getpickaxe": {
                    if (!(sender instanceof Player)) {
                        return true;
                    }
                    Player pl = (Player)sender;
                    pl.getInventory().addItem(new ItemStack[]{this.getPickaxe()});
                }
            }
        }
        return true;
    }

    String progressBar(int times) {
        return "=".repeat(Math.max(0, times));
    }

    void cleanChunkCommand(Player pl) {
        if (this.cleanTaskId != -1) {
            pl.sendMessage(Component.text((String)"Currently cleaning another chunk!").color((TextColor)NamedTextColor.RED));
            return;
        }
        Chunk chunk = pl.getChunk();
        this.y = chunk.getWorld().getMaxHeight() - 1;
        Runnable cleanSingleFloor = () -> {
            boolean hasAnyBlock = false;
            while (!hasAnyBlock) {
                if (this.y < chunk.getWorld().getMinHeight()) {
                    Bukkit.getScheduler().cancelTask(this.cleanTaskId);
                    this.cleanTaskId = -1;
                    return;
                }
                int worldHeight = chunk.getWorld().getMaxHeight() - chunk.getWorld().getMinHeight();
                int progress = (chunk.getWorld().getMaxHeight() - this.y) * 40 / worldHeight;
                if (this.lastProgress != progress) {
                    pl.sendActionBar(((TextComponent)((TextComponent)((TextComponent)this.chatPrefix.append((Component)Component.text((String)" <"))).append(Component.text((String)this.progressBar(progress)).color((TextColor)NamedTextColor.GREEN))).append(Component.text((String)this.progressBar(40 - progress)).color((TextColor)NamedTextColor.DARK_GRAY))).append((Component)Component.text((String)">")));
                }
                this.lastProgress = progress;
                for (int x = 0; x < 16; ++x) {
                    for (int z = 0; z < 16; ++z) {
                        Block block = chunk.getBlock(x, this.y, z);
                        if (this.blacklist.contains(block.getType())) {
                            BlockData patt0$temp = block.getBlockData();
                            if (!(patt0$temp instanceof Waterlogged)) continue;
                            Waterlogged data = (Waterlogged)patt0$temp;
                            data.setWaterlogged(false);
                            block.setBlockData((BlockData)data);
                            continue;
                        }
                        hasAnyBlock = true;
                        if (block.isLiquid()) {
                            block.setType(Material.AIR);
                            continue;
                        }
                        block.breakNaturally(this.silkTouchTool, false, false);
                    }
                }
                --this.y;
            }
        };
        Bukkit.getScheduler().cancelTask(this.cleanTaskId);
        this.cleanTaskId = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this, cleanSingleFloor, 2L, 2L);
    }

    public int putToHolder(Material material, int count, InventoryHolder holder) {
        ItemStack itemStack = new ItemStack(material, count);
        HashMap leftover = holder.getInventory().addItem(new ItemStack[]{itemStack});
        return leftover.values().stream().mapToInt(ItemStack::getAmount).sum();
    }

    void vanishChunkCommand(Player pl) {
        if (this.cleanTaskId != -1) {
            pl.sendMessage(Component.text((String)"Currently cleaning another chunk!").color((TextColor)NamedTextColor.RED));
            return;
        }
        Chunk chunk = pl.getChunk();
        HashMap<Material, Integer> drops = new HashMap<Material, Integer>();
        this.y = chunk.getWorld().getMaxHeight() - 1;
        while (true) {
            Block block;
            if (this.y < chunk.getWorld().getMinHeight()) {
                block1: for (Material material : drops.keySet()) {
                    int count = (Integer)drops.get(material);
                    for (int y = (int)pl.getY() - 2; y < (int)pl.getY() + 2; ++y) {
                        for (int x = 0; x < 16; ++x) {
                            for (int z = 0; z < 16; ++z) {
                                InventoryHolder holder;
                                block = chunk.getBlock(x, y, z);
                                BlockState blockState = block.getState();
                                if (blockState instanceof InventoryHolder && (count = this.putToHolder(material, count, holder = (InventoryHolder)blockState)) <= 0) continue block1;
                            }
                        }
                    }
                    if (count <= 0) continue;
                    pl.getWorld().dropItem(pl.getLocation(), new ItemStack(material, count));
                }
                return;
            }
            int worldHeight = chunk.getWorld().getMaxHeight() - chunk.getWorld().getMinHeight();
            int progress = (chunk.getWorld().getMaxHeight() - this.y) * 40 / worldHeight;
            if (this.lastProgress != progress) {
                pl.sendActionBar(((TextComponent)((TextComponent)((TextComponent)this.chatPrefix.append((Component)Component.text((String)" <"))).append(Component.text((String)this.progressBar(progress)).color((TextColor)NamedTextColor.GREEN))).append(Component.text((String)this.progressBar(40 - progress)).color((TextColor)NamedTextColor.DARK_GRAY))).append((Component)Component.text((String)">")));
            }
            this.lastProgress = progress;
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    Block block2 = chunk.getBlock(x, this.y, z);
                    if (this.blacklist.contains(block2.getType())) {
                        block = block2.getBlockData();
                        if (!(block instanceof Waterlogged)) continue;
                        Waterlogged data = (Waterlogged)block;
                        data.setWaterlogged(false);
                        block2.setBlockData((BlockData)data);
                        continue;
                    }
                    if (!block2.isLiquid()) {
                        for (ItemStack item : block2.getDrops(this.silkTouchTool)) {
                            drops.put(item.getType(), drops.getOrDefault(item.getType(), 0) + item.getAmount());
                        }
                    }
                    block2.setType(Material.AIR);
                }
            }
            --this.y;
        }
    }

    void explodeChunkCommand(Player pl) {
        if (this.cleanTaskId != -1) {
            pl.sendMessage(Component.text((String)"Currently cleaning another chunk!").color((TextColor)NamedTextColor.RED));
            return;
        }
        Chunk chunk = pl.getChunk();
        this.y = chunk.getWorld().getMaxHeight() - 1;
        Runnable cleanSingleFloor = () -> {
            boolean hasAnyBlock = false;
            while (!hasAnyBlock) {
                int z;
                int x;
                if (this.y < chunk.getWorld().getMinHeight()) {
                    Bukkit.getScheduler().cancelTask(this.cleanTaskId);
                    this.cleanTaskId = -1;
                    return;
                }
                int worldHeight = chunk.getWorld().getMaxHeight() - chunk.getWorld().getMinHeight();
                int progress = (chunk.getWorld().getMaxHeight() - this.y) * 40 / worldHeight;
                if (this.lastProgress != progress) {
                    pl.sendActionBar(((TextComponent)((TextComponent)((TextComponent)this.chatPrefix.append((Component)Component.text((String)" <"))).append(Component.text((String)this.progressBar(progress)).color((TextColor)NamedTextColor.GREEN))).append(Component.text((String)this.progressBar(40 - progress)).color((TextColor)NamedTextColor.DARK_GRAY))).append((Component)Component.text((String)">")));
                }
                this.lastProgress = progress;
                for (x = 0; x < 16; ++x) {
                    for (z = 0; z < 16; ++z) {
                        if (this.blacklist.contains(chunk.getBlock(x, this.y, z).getType())) continue;
                        hasAnyBlock = true;
                    }
                }
                if (hasAnyBlock) {
                    for (x = 0; x < 16; x += 3) {
                        for (z = 0; z < 16; z += 3) {
                            chunk.getWorld().createExplosion(chunk.getBlock(x, this.y, z).getLocation(), 5.0f, false, true);
                        }
                    }
                }
                this.y -= 3;
            }
        };
        Bukkit.getScheduler().cancelTask(this.cleanTaskId);
        this.cleanTaskId = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this, cleanSingleFloor, 2L, 10L);
    }

    @EventHandler
    public void onBlockBreak(BlockBreakEvent ev) {
        Chunk chunk = ev.getBlock().getChunk();
        Player pl = ev.getPlayer();
        long chunkKey = chunk.getChunkKey();
        UUID playerId = pl.getUniqueId();
        List lore = pl.getInventory().getItemInMainHand().lore();
        if (lore == null || lore.stream().noneMatch(c -> {
            TextComponent tc;
            return c instanceof TextComponent && (tc = (TextComponent)c).content().equals(this.pickDesc);
        })) {
            return;
        }
        Map chunkMap = this.pickProgress.getOrDefault(playerId, new HashMap());
        int count = chunkMap.getOrDefault(chunkKey, 0) + 1;
        pl.sendActionBar(((TextComponent)((TextComponent)this.chatPrefix.append((Component)Component.text((String)"Mining the chunk: "))).append(Component.text((int)count).color((TextColor)NamedTextColor.GOLD))).append((Component)Component.text((String)"/4")));
        if (count >= 4) {
            this.vanishByPickaxe(chunk, pl);
            count = 0;
        }
        chunkMap.clear();
        chunkMap.put(chunkKey, count);
        this.pickProgress.put(playerId, chunkMap);
    }

    ItemStack getPickaxe() {
        ItemStack pick = new ItemStack(Material.DIAMOND_PICKAXE);
        pick.editMeta(meta -> {
            meta.displayName(Component.text((String)"Chunk Pickaxe").color((TextColor)NamedTextColor.RED));
            meta.lore(List.of((TextComponent)Component.text((String)this.pickDesc).color((TextColor)NamedTextColor.GOLD)));
            meta.setUnbreakable(true);
            meta.setEnchantmentGlintOverride(Boolean.valueOf(true));
        });
        return pick;
    }

    void vanishByPickaxe(Chunk chunk, Player pl) {
        HashMap<Material, Integer> drops = new HashMap<Material, Integer>();
        this.y = chunk.getWorld().getMaxHeight() - 1;
        while (true) {
            Block blockOne;
            if (this.y < chunk.getWorld().getMinHeight()) {
                block1: for (Material material : drops.keySet()) {
                    int count = (Integer)drops.get(material);
                    for (int y = chunk.getWorld().getMinHeight() + 5; y < chunk.getWorld().getMaxHeight(); ++y) {
                        for (int x = 0; x < 16; x += 2) {
                            for (int z = 0; z < 16; ++z) {
                                blockOne = chunk.getBlock(x, y, z);
                                Block blockTwo = chunk.getBlock(x + 1, y, z);
                                if (!blockOne.getType().equals((Object)Material.CHEST)) {
                                    blockOne.setType(Material.CHEST);
                                }
                                if (!blockTwo.getType().equals((Object)Material.CHEST)) {
                                    blockTwo.setType(Material.CHEST);
                                }
                                Chest chestOne = (Chest)blockOne.getBlockData();
                                Chest chestTwo = (Chest)blockOne.getBlockData();
                                chestOne.setFacing(BlockFace.SOUTH);
                                chestTwo.setFacing(BlockFace.SOUTH);
                                chestOne.setType(Chest.Type.RIGHT);
                                chestTwo.setType(Chest.Type.LEFT);
                                blockOne.setBlockData((BlockData)chestOne);
                                blockTwo.setBlockData((BlockData)chestTwo);
                                count = this.putToHolder(material, count, (InventoryHolder)blockOne.getState());
                                if (count <= 0) continue block1;
                            }
                        }
                    }
                }
                return;
            }
            int worldHeight = chunk.getWorld().getMaxHeight() - chunk.getWorld().getMinHeight();
            int progress = (chunk.getWorld().getMaxHeight() - this.y) * 40 / worldHeight;
            if (this.lastProgress != progress) {
                pl.sendActionBar(((TextComponent)((TextComponent)((TextComponent)this.chatPrefix.append((Component)Component.text((String)" <"))).append(Component.text((String)this.progressBar(progress)).color((TextColor)NamedTextColor.GREEN))).append(Component.text((String)this.progressBar(40 - progress)).color((TextColor)NamedTextColor.DARK_GRAY))).append((Component)Component.text((String)">")));
            }
            this.lastProgress = progress;
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    Block block = chunk.getBlock(x, this.y, z);
                    if (this.blacklist.contains(block.getType())) {
                        blockOne = block.getBlockData();
                        if (!(blockOne instanceof Waterlogged)) continue;
                        Waterlogged data = (Waterlogged)blockOne;
                        data.setWaterlogged(false);
                        block.setBlockData((BlockData)data);
                        continue;
                    }
                    if (!block.isLiquid()) {
                        for (ItemStack item : block.getDrops(this.silkTouchTool)) {
                            drops.put(item.getType(), drops.getOrDefault(item.getType(), 0) + item.getAmount());
                        }
                    }
                    block.setType(Material.AIR);
                }
            }
            --this.y;
        }
    }
}

