/*
 * Decompiled with CFR 0.152.
 */
package dev.huey.chunkcleaner;

import java.util.HashMap;
import java.util.Set;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public final class ChunkCleaner
extends JavaPlugin {
    int cleanTaskId = -1;
    int y;
    ItemStack silkTouchTool = new ItemStack(Material.DIAMOND_PICKAXE);
    int lastProgress;
    TextComponent chatPrefix = (TextComponent)((TextComponent)((TextComponent)((TextComponent)Component.text((String)"[").color((TextColor)NamedTextColor.GRAY)).append(Component.text((String)"Chunk").color((TextColor)NamedTextColor.YELLOW))).append(Component.text((String)"Cleaner").color((TextColor)NamedTextColor.GOLD))).append(Component.text((String)"] ").color((TextColor)NamedTextColor.GRAY));
    Set<Material> blacklist = Set.of(Material.BEDROCK, Material.AIR, Material.CHEST, Material.TRAPPED_CHEST, Material.BARREL, Material.END_PORTAL_FRAME, Material.SPAWNER, Material.TRIAL_SPAWNER, Material.VAULT);

    public void onEnable() {
        this.getCommand("cleanchunk").setExecutor((CommandExecutor)this);
        this.getCommand("vanishchunk").setExecutor((CommandExecutor)this);
        this.getCommand("explodechunk").setExecutor((CommandExecutor)this);
        this.silkTouchTool.addUnsafeEnchantment(Enchantment.SILK_TOUCH, 1);
    }

    public void onDisable() {
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        switch (command.getName()) {
            case "cleanchunk": {
                if (!(sender instanceof Player)) {
                    return true;
                }
                Player pl = (Player)sender;
                this.cleanChunkCommand(pl);
                break;
            }
            case "vanishchunk": {
                if (!(sender instanceof Player)) {
                    return true;
                }
                Player pl = (Player)sender;
                this.vanishChunkCommand(pl);
                break;
            }
            case "explodechunk": {
                if (!(sender instanceof Player)) {
                    return true;
                }
                Player pl = (Player)sender;
                this.explodeChunkCommand(pl);
            }
        }
        return true;
    }

    String progressBar(int times) {
        return "=".repeat(Math.max(0, times));
    }

    void cleanChunkCommand(Player pl) {
        if (this.cleanTaskId != -1) {
            pl.sendMessage(Component.text((String)"Currently cleaning another chunk!").color((TextColor)NamedTextColor.RED));
            return;
        }
        Chunk chunk = pl.getChunk();
        this.y = chunk.getWorld().getMaxHeight() - 1;
        Runnable cleanSingleFloor = () -> {
            boolean hasAnyBlock = false;
            while (!hasAnyBlock) {
                if (this.y < chunk.getWorld().getMinHeight()) {
                    Bukkit.getScheduler().cancelTask(this.cleanTaskId);
                    this.cleanTaskId = -1;
                    return;
                }
                int worldHeight = chunk.getWorld().getMaxHeight() - chunk.getWorld().getMinHeight();
                int progress = (chunk.getWorld().getMaxHeight() - this.y) * 40 / worldHeight;
                if (this.lastProgress != progress) {
                    pl.sendActionBar(((TextComponent)((TextComponent)((TextComponent)this.chatPrefix.append((Component)Component.text((String)" <"))).append(Component.text((String)this.progressBar(progress)).color((TextColor)NamedTextColor.GREEN))).append(Component.text((String)this.progressBar(40 - progress)).color((TextColor)NamedTextColor.DARK_GRAY))).append((Component)Component.text((String)">")));
                }
                this.lastProgress = progress;
                for (int x = 0; x < 16; ++x) {
                    for (int z = 0; z < 16; ++z) {
                        if (this.blacklist.contains(chunk.getBlock(x, this.y, z).getType())) continue;
                        hasAnyBlock = true;
                        Block block = chunk.getBlock(x, this.y, z);
                        if (block.isLiquid()) {
                            block.setType(Material.AIR);
                            continue;
                        }
                        block.breakNaturally(this.silkTouchTool, false, false);
                    }
                }
                --this.y;
            }
        };
        Bukkit.getScheduler().cancelTask(this.cleanTaskId);
        this.cleanTaskId = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this, cleanSingleFloor, 2L, 2L);
    }

    public int putToHolder(Material material, int count, InventoryHolder holder) {
        ItemStack itemStack = new ItemStack(material, count);
        HashMap leftover = holder.getInventory().addItem(new ItemStack[]{itemStack});
        return leftover.values().stream().mapToInt(ItemStack::getAmount).sum();
    }

    void vanishChunkCommand(Player pl) {
        if (this.cleanTaskId != -1) {
            pl.sendMessage(Component.text((String)"Currently cleaning another chunk!").color((TextColor)NamedTextColor.RED));
            return;
        }
        Chunk chunk = pl.getChunk();
        HashMap<Material, Integer> drops = new HashMap<Material, Integer>();
        this.y = chunk.getWorld().getMaxHeight() - 1;
        while (true) {
            if (this.y < chunk.getWorld().getMinHeight()) {
                block1: for (Material material : drops.keySet()) {
                    int count = (Integer)drops.get(material);
                    int maxCount = material.getMaxStackSize();
                    for (int y = (int)pl.getY() - 2; y < (int)pl.getY() + 2; ++y) {
                        for (int x = 0; x < 16; ++x) {
                            for (int z = 0; z < 16; ++z) {
                                InventoryHolder holder;
                                Block block = chunk.getBlock(x, y, z);
                                BlockState blockState = block.getState();
                                if (blockState instanceof InventoryHolder && (count = this.putToHolder(material, count, holder = (InventoryHolder)blockState)) <= 0) continue block1;
                            }
                        }
                    }
                    if (count <= 0) continue;
                    pl.getWorld().dropItem(pl.getLocation(), new ItemStack(material, count));
                }
                return;
            }
            int worldHeight = chunk.getWorld().getMaxHeight() - chunk.getWorld().getMinHeight();
            int progress = (chunk.getWorld().getMaxHeight() - this.y) * 40 / worldHeight;
            if (this.lastProgress != progress) {
                pl.sendActionBar(((TextComponent)((TextComponent)((TextComponent)this.chatPrefix.append((Component)Component.text((String)" <"))).append(Component.text((String)this.progressBar(progress)).color((TextColor)NamedTextColor.GREEN))).append(Component.text((String)this.progressBar(40 - progress)).color((TextColor)NamedTextColor.DARK_GRAY))).append((Component)Component.text((String)">")));
            }
            this.lastProgress = progress;
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    if (this.blacklist.contains(chunk.getBlock(x, this.y, z).getType())) continue;
                    Block block = chunk.getBlock(x, this.y, z);
                    if (!block.isLiquid()) {
                        for (ItemStack item : block.getDrops(this.silkTouchTool)) {
                            drops.put(item.getType(), drops.getOrDefault(item.getType(), 0) + item.getAmount());
                        }
                    }
                    block.setType(Material.AIR);
                }
            }
            --this.y;
        }
    }

    void explodeChunkCommand(Player pl) {
        if (this.cleanTaskId != -1) {
            pl.sendMessage(Component.text((String)"Currently cleaning another chunk!").color((TextColor)NamedTextColor.RED));
            return;
        }
        Chunk chunk = pl.getChunk();
        this.y = chunk.getWorld().getMaxHeight() - 1;
        Runnable cleanSingleFloor = () -> {
            boolean hasAnyBlock = false;
            while (!hasAnyBlock) {
                int z;
                int x;
                if (this.y < chunk.getWorld().getMinHeight()) {
                    Bukkit.getScheduler().cancelTask(this.cleanTaskId);
                    this.cleanTaskId = -1;
                    return;
                }
                int worldHeight = chunk.getWorld().getMaxHeight() - chunk.getWorld().getMinHeight();
                int progress = (chunk.getWorld().getMaxHeight() - this.y) * 40 / worldHeight;
                if (this.lastProgress != progress) {
                    pl.sendActionBar(((TextComponent)((TextComponent)((TextComponent)this.chatPrefix.append((Component)Component.text((String)" <"))).append(Component.text((String)this.progressBar(progress)).color((TextColor)NamedTextColor.GREEN))).append(Component.text((String)this.progressBar(40 - progress)).color((TextColor)NamedTextColor.DARK_GRAY))).append((Component)Component.text((String)">")));
                }
                this.lastProgress = progress;
                for (x = 0; x < 16; ++x) {
                    for (z = 0; z < 16; ++z) {
                        if (this.blacklist.contains(chunk.getBlock(x, this.y, z).getType())) continue;
                        hasAnyBlock = true;
                    }
                }
                if (hasAnyBlock) {
                    for (x = 0; x < 16; x += 3) {
                        for (z = 0; z < 16; z += 3) {
                            chunk.getWorld().createExplosion(chunk.getBlock(x, this.y, z).getLocation(), 5.0f, false, true);
                        }
                    }
                }
                this.y -= 3;
            }
        };
        Bukkit.getScheduler().cancelTask(this.cleanTaskId);
        this.cleanTaskId = Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this, cleanSingleFloor, 2L, 10L);
    }
}

