/*
 * Decompiled with CFR 0.152.
 */
package com.ashkiano.mines;

import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;

public class MineZone {
    private final Location corner1;
    private final Location corner2;
    private final Material blockType;
    private final Location teleportLocation;

    public MineZone(Location corner1, Location corner2, Material blockType, Location teleportLocation) {
        this.corner1 = corner1;
        this.corner2 = corner2;
        this.blockType = blockType;
        this.teleportLocation = teleportLocation;
    }

    public void regenerate() {
        int minX = Math.min(this.corner1.getBlockX(), this.corner2.getBlockX());
        int minY = Math.min(this.corner1.getBlockY(), this.corner2.getBlockY());
        int minZ = Math.min(this.corner1.getBlockZ(), this.corner2.getBlockZ());
        int maxX = Math.max(this.corner1.getBlockX(), this.corner2.getBlockX());
        int maxY = Math.max(this.corner1.getBlockY(), this.corner2.getBlockY());
        int maxZ = Math.max(this.corner1.getBlockZ(), this.corner2.getBlockZ());
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    Location loc = new Location(this.corner1.getWorld(), (double)x, (double)y, (double)z);
                    Bukkit.getScheduler().runTask(Bukkit.getPluginManager().getPlugin("Mines"), () -> loc.getBlock().setType(this.blockType));
                }
            }
        }
    }

    public void teleportPlayers() {
        int minX = Math.min(this.corner1.getBlockX(), this.corner2.getBlockX());
        int minY = Math.min(this.corner1.getBlockY(), this.corner2.getBlockY());
        int minZ = Math.min(this.corner1.getBlockZ(), this.corner2.getBlockZ());
        int maxX = Math.max(this.corner1.getBlockX(), this.corner2.getBlockX());
        int maxY = Math.max(this.corner1.getBlockY(), this.corner2.getBlockY());
        int maxZ = Math.max(this.corner1.getBlockZ(), this.corner2.getBlockZ());
        for (Player player : Bukkit.getOnlinePlayers()) {
            Location playerLoc = player.getLocation();
            if (!(playerLoc.getX() >= (double)minX) || !(playerLoc.getX() <= (double)maxX) || !(playerLoc.getY() >= (double)minY) || !(playerLoc.getY() <= (double)maxY) || !(playerLoc.getZ() >= (double)minZ) || !(playerLoc.getZ() <= (double)maxZ)) continue;
            player.teleport(this.teleportLocation);
        }
    }
}

