/*
 * Decompiled with CFR 0.152.
 */
package com.ashkiano.mines;

import com.ashkiano.mines.Metrics;
import com.ashkiano.mines.MineZone;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Mines
extends JavaPlugin {
    private final List<MineZone> mineZones = new ArrayList<MineZone>();

    public void onEnable() {
        this.saveDefaultConfig();
        this.loadMineZones();
        this.startMineTask();
        this.getCommand("reloadMines").setExecutor((sender, command, label, args) -> {
            if (sender.hasPermission("minesplugin.reload")) {
                this.reloadConfig();
                this.loadMineZones();
                sender.sendMessage("Mine zones reloaded!");
                return true;
            }
            return false;
        });
        Metrics metrics = new Metrics(this, 22394);
        this.getLogger().info("Thank you for using the Mines plugin! If you enjoy using this plugin, please consider making a donation to support the development. You can donate at: https://donate.ashkiano.com");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadMineZones() {
        FileConfiguration config = this.getConfig();
        List<MineZone> list = this.mineZones;
        synchronized (list) {
            this.mineZones.clear();
            for (String zone : config.getConfigurationSection("zones").getKeys(false)) {
                String path = "zones." + zone;
                Location corner1 = new Location(Bukkit.getWorld((String)config.getString(path + ".world")), (double)config.getInt(path + ".corner1.x"), (double)config.getInt(path + ".corner1.y"), (double)config.getInt(path + ".corner1.z"));
                Location corner2 = new Location(Bukkit.getWorld((String)config.getString(path + ".world")), (double)config.getInt(path + ".corner2.x"), (double)config.getInt(path + ".corner2.y"), (double)config.getInt(path + ".corner2.z"));
                Material blockType = Material.valueOf((String)config.getString(path + ".block"));
                Location teleportLocation = new Location(Bukkit.getWorld((String)config.getString(path + ".teleport.world")), config.getDouble(path + ".teleport.x"), config.getDouble(path + ".teleport.y"), config.getDouble(path + ".teleport.z"));
                this.mineZones.add(new MineZone(corner1, corner2, blockType, teleportLocation));
            }
        }
    }

    private void startMineTask() {
        new BukkitRunnable(){

            public void run() {
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)Mines.this, () -> {
                    ArrayList copyMineZones;
                    List list = Mines.this.mineZones;
                    synchronized (list) {
                        copyMineZones = new ArrayList(Mines.this.mineZones);
                    }
                    for (MineZone mineZone : copyMineZones) {
                        mineZone.regenerate();
                        Bukkit.getScheduler().runTask((Plugin)Mines.this, mineZone::teleportPlayers);
                    }
                });
            }
        }.runTaskTimer((Plugin)this, 0L, 18000L);
    }
}

