/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.havenbag;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_18;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_4284;
import net.minecraft.class_7225;

public class HavenPocketSavedData
extends class_18 {
    private static final String DATA_NAME = "haven_pocket_data";
    private final Set<UUID> structuresPlaced = new HashSet<UUID>();
    private final Set<String> expansionsPlaced = new HashSet<String>();
    private final Map<UUID, String> pocketColors = new HashMap<UUID, String>();

    public HavenPocketSavedData() {
    }

    private HavenPocketSavedData(class_2487 tag, class_7225.class_7874 lookupProvider) {
        this.loadFromTag(tag);
    }

    private static HavenPocketSavedData load(class_2487 tag, class_7225.class_7874 lookupProvider) {
        return new HavenPocketSavedData(tag, lookupProvider);
    }

    public static HavenPocketSavedData get(class_3218 level) {
        class_18.class_8645 factory = new class_18.class_8645(HavenPocketSavedData::new, HavenPocketSavedData::load, class_4284.field_19212);
        return (HavenPocketSavedData)level.method_17983().method_17924(factory, DATA_NAME);
    }

    private void loadFromTag(class_2487 tag) {
        class_2499 structureList = tag.method_10554("Structures", 8);
        for (int i = 0; i < structureList.size(); ++i) {
            String value = structureList.method_10608(i);
            try {
                this.structuresPlaced.add(UUID.fromString(value));
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        class_2499 expansionList = tag.method_10554("Expansions", 8);
        for (int i = 0; i < expansionList.size(); ++i) {
            this.expansionsPlaced.add(expansionList.method_10608(i));
        }
        class_2499 colorList = tag.method_10554("PocketColors", 10);
        for (int i = 0; i < colorList.size(); ++i) {
            class_2487 entry = colorList.method_10602(i);
            if (!entry.method_10545("Id") || !entry.method_10545("Color")) continue;
            try {
                this.pocketColors.put(UUID.fromString(entry.method_10558("Id")), entry.method_10558("Color"));
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public class_2487 method_75(class_2487 tag, class_7225.class_7874 lookupProvider) {
        class_2499 structureList = new class_2499();
        for (UUID uUID : this.structuresPlaced) {
            structureList.add((Object)class_2519.method_23256((String)uUID.toString()));
        }
        tag.method_10566("Structures", (class_2520)structureList);
        class_2499 expansionList = new class_2499();
        for (String key : this.expansionsPlaced) {
            expansionList.add((Object)class_2519.method_23256((String)key));
        }
        tag.method_10566("Expansions", (class_2520)expansionList);
        class_2499 class_24992 = new class_2499();
        for (Map.Entry<UUID, String> entry : this.pocketColors.entrySet()) {
            class_2487 colored = new class_2487();
            colored.method_10582("Id", entry.getKey().toString());
            colored.method_10582("Color", entry.getValue());
            class_24992.add((Object)colored);
        }
        tag.method_10566("PocketColors", (class_2520)class_24992);
        return tag;
    }

    public boolean isStructurePlaced(UUID uuid) {
        return this.structuresPlaced.contains(uuid);
    }

    public void markStructurePlaced(UUID uuid) {
        if (this.structuresPlaced.add(uuid)) {
            this.method_80();
        }
    }

    public boolean hasExpansion(UUID uuid, String direction) {
        return this.expansionsPlaced.contains(HavenPocketSavedData.expansionKey(uuid, direction));
    }

    public void markExpansion(UUID uuid, String direction) {
        if (this.expansionsPlaced.add(HavenPocketSavedData.expansionKey(uuid, direction))) {
            this.method_80();
        }
    }

    public void registerPocketColor(UUID uuid, String color) {
        String existing = this.pocketColors.get(uuid);
        if (!color.equals(existing)) {
            this.pocketColors.put(uuid, color);
            this.method_80();
        }
    }

    public String getPocketColor(UUID uuid) {
        return this.pocketColors.get(uuid);
    }

    public Set<UUID> getAllPocketIds() {
        return Collections.unmodifiableSet(this.structuresPlaced);
    }

    public Set<String> getAllExpansionKeys() {
        return Collections.unmodifiableSet(this.expansionsPlaced);
    }

    public Map<UUID, String> getPocketColorMap() {
        return Collections.unmodifiableMap(this.pocketColors);
    }

    private static String expansionKey(UUID uuid, String direction) {
        return uuid.toString() + "_" + direction;
    }
}

