/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.havenbag;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_18;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_4284;
import net.minecraft.class_7225;

public class HavenReturnSavedData
extends class_18 {
    private static final String DATA_NAME = "haven_return_data";
    private final Map<String, double[]> returnPositions = new HashMap<String, double[]>();
    private final Map<String, String> returnDimensions = new HashMap<String, String>();

    public HavenReturnSavedData() {
    }

    private HavenReturnSavedData(class_2487 tag, class_7225.class_7874 lookupProvider) {
        this.loadFromTag(tag);
    }

    private static HavenReturnSavedData load(class_2487 tag, class_7225.class_7874 lookupProvider) {
        return new HavenReturnSavedData(tag, lookupProvider);
    }

    public static HavenReturnSavedData get(class_3218 level) {
        class_18.class_8645 factory = new class_18.class_8645(HavenReturnSavedData::new, HavenReturnSavedData::load, class_4284.field_19212);
        return (HavenReturnSavedData)level.method_17983().method_17924(factory, DATA_NAME);
    }

    private void loadFromTag(class_2487 tag) {
        this.returnPositions.clear();
        this.returnDimensions.clear();
        class_2499 list = tag.method_10554("Returns", 10);
        for (int i = 0; i < list.size(); ++i) {
            class_2487 entry = list.method_10602(i);
            if (!entry.method_10545("PlayerId") || !entry.method_10545("BagColor") || !entry.method_10545("Dimension")) continue;
            try {
                String playerId = entry.method_10558("PlayerId");
                String bagColor = entry.method_10558("BagColor");
                String dimension = entry.method_10558("Dimension");
                double x = entry.method_10574("X");
                double y = entry.method_10574("Y");
                double z = entry.method_10574("Z");
                double yaw = entry.method_10574("Yaw");
                double pitch = entry.method_10574("Pitch");
                String key = playerId + "_" + bagColor;
                this.returnPositions.put(key, new double[]{x, y, z, yaw, pitch});
                this.returnDimensions.put(key, dimension);
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public class_2487 method_75(class_2487 tag, class_7225.class_7874 lookupProvider) {
        class_2499 list = new class_2499();
        for (Map.Entry<String, double[]> e : this.returnPositions.entrySet()) {
            String[] parts;
            String key = e.getKey();
            double[] arr = e.getValue();
            if (arr == null || arr.length < 5 || (parts = key.split("_", 2)).length < 2) continue;
            class_2487 entry = new class_2487();
            entry.method_10582("PlayerId", parts[0]);
            entry.method_10582("BagColor", parts[1]);
            entry.method_10549("X", arr[0]);
            entry.method_10549("Y", arr[1]);
            entry.method_10549("Z", arr[2]);
            entry.method_10549("Yaw", arr[3]);
            entry.method_10549("Pitch", arr[4]);
            String dim = this.returnDimensions.getOrDefault(key, "");
            entry.method_10582("Dimension", dim);
            list.add((Object)entry);
        }
        tag.method_10566("Returns", (class_2520)list);
        return tag;
    }

    public void saveReturnPosition(UUID playerId, String bagColor, double[] pos, String dimension) {
        if (playerId == null || bagColor == null || pos == null || pos.length < 5 || dimension == null) {
            return;
        }
        String key = playerId.toString() + "_" + bagColor;
        this.returnPositions.put(key, new double[]{pos[0], pos[1], pos[2], pos[3], pos[4]});
        this.returnDimensions.put(key, dimension);
        this.method_80();
    }

    public double[] getReturnPosition(UUID playerId, String bagColor) {
        double[] dArray;
        if (playerId == null || bagColor == null) {
            return null;
        }
        String key = playerId.toString() + "_" + bagColor;
        double[] v = this.returnPositions.get(key);
        if (v == null) {
            dArray = null;
        } else {
            double[] dArray2 = new double[5];
            dArray2[0] = v[0];
            dArray2[1] = v[1];
            dArray2[2] = v[2];
            dArray2[3] = v[3];
            dArray = dArray2;
            dArray2[4] = v[4];
        }
        return dArray;
    }

    public String getReturnDimension(UUID playerId, String bagColor) {
        if (playerId == null || bagColor == null) {
            return null;
        }
        String key = playerId.toString() + "_" + bagColor;
        return this.returnDimensions.get(key);
    }

    public void clearReturnData(UUID playerId, String bagColor) {
        if (playerId == null || bagColor == null) {
            return;
        }
        String key = playerId.toString() + "_" + bagColor;
        boolean removed = false;
        if (this.returnPositions.containsKey(key)) {
            this.returnPositions.remove(key);
            removed = true;
        }
        if (this.returnDimensions.containsKey(key)) {
            this.returnDimensions.remove(key);
            removed = true;
        }
        if (removed) {
            this.method_80();
        }
    }

    public Set<String> getAllReturnKeys() {
        return Collections.unmodifiableSet(this.returnPositions.keySet());
    }
}

