/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.havenbag.block.entity;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import io.netty.buffer.Unpooled;
import java.util.UUID;
import java.util.stream.IntStream;
import net.mcreator.havenbag.HavenBagGemPersistence;
import net.mcreator.havenbag.init.HavenbagModBlockEntities;
import net.mcreator.havenbag.init.HavenbagModItems;
import net.mcreator.havenbag.world.inventory.BagGUIMenu;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2621;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;

public class BlackBagBlockBlockEntity
extends class_2621
implements class_1278 {
    private class_2371<class_1799> stacks = class_2371.method_10213((int)6, (Object)class_1799.field_8037);
    private class_2371<class_1799> cachedInventory = class_2371.method_10213((int)6, (Object)class_1799.field_8037);
    private UUID pocketUUID = UUID.randomUUID();
    private UUID ownerUUID;
    private boolean merchantGemConsumed = false;
    private boolean decoGemConsumed = false;
    private boolean craftyGemConsumed = false;
    private boolean gardenGemConsumed = false;

    public BlackBagBlockBlockEntity(class_2338 position, class_2680 state) {
        super(HavenbagModBlockEntities.BLACK_BAG_BLOCK, position, state);
    }

    public void method_11014(class_2487 tag, class_7225.class_7874 registries) {
        super.method_11014(tag, registries);
        if (!this.method_54871(tag)) {
            this.stacks = class_2371.method_10213((int)this.method_5439(), (Object)class_1799.field_8037);
        }
        class_1262.method_5429((class_2487)tag, this.stacks, (class_7225.class_7874)registries);
        for (int i = 0; i < Math.min(this.stacks.size(), this.cachedInventory.size()); ++i) {
            this.cachedInventory.set(i, (Object)((class_1799)this.stacks.get(i)).method_7972());
        }
        if (tag.method_10545("PocketUUIDMost") && tag.method_10545("PocketUUIDLeast")) {
            long most = tag.method_10537("PocketUUIDMost");
            long least = tag.method_10537("PocketUUIDLeast");
            this.pocketUUID = new UUID(most, least);
        }
        if (tag.method_10545("OwnerUUIDMost") && tag.method_10545("OwnerUUIDLeast")) {
            long ownerMost = tag.method_10537("OwnerUUIDMost");
            long ownerLeast = tag.method_10537("OwnerUUIDLeast");
            this.ownerUUID = new UUID(ownerMost, ownerLeast);
        }
        this.merchantGemConsumed = tag.method_10537("MerchantGemConsumed") == 1L;
        this.decoGemConsumed = tag.method_10537("DecoGemConsumed") == 1L;
        this.craftyGemConsumed = tag.method_10537("CraftyGemConsumed") == 1L;
        this.gardenGemConsumed = tag.method_10537("GardenGemConsumed") == 1L;
    }

    public void method_11007(class_2487 tag, class_7225.class_7874 registries) {
        super.method_11007(tag, registries);
        if (!this.method_54872(tag)) {
            class_1262.method_5426((class_2487)tag, this.stacks, (class_7225.class_7874)registries);
        }
        tag.method_10544("PocketUUIDMost", this.pocketUUID.getMostSignificantBits());
        tag.method_10544("PocketUUIDLeast", this.pocketUUID.getLeastSignificantBits());
        if (this.ownerUUID != null) {
            tag.method_10544("OwnerUUIDMost", this.ownerUUID.getMostSignificantBits());
            tag.method_10544("OwnerUUIDLeast", this.ownerUUID.getLeastSignificantBits());
        }
        tag.method_10544("MerchantGemConsumed", this.merchantGemConsumed ? 1L : 0L);
        tag.method_10544("DecoGemConsumed", this.decoGemConsumed ? 1L : 0L);
        tag.method_10544("CraftyGemConsumed", this.craftyGemConsumed ? 1L : 0L);
        tag.method_10544("GardenGemConsumed", this.gardenGemConsumed ? 1L : 0L);
    }

    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887(class_7225.class_7874 lookupProvider) {
        return this.method_38242(lookupProvider);
    }

    public int method_5439() {
        return this.stacks.size();
    }

    public boolean method_5442() {
        for (class_1799 itemstack : this.stacks) {
            if (itemstack.method_7960()) continue;
            return false;
        }
        return false;
    }

    public class_2561 method_17823() {
        return class_2561.method_43470((String)"black_bag_block");
    }

    public int method_5444() {
        return 1;
    }

    public class_1703 method_5465(int id, class_1661 inventory) {
        return new BagGUIMenu(id, inventory, (class_1263)this, new class_2540(Unpooled.buffer()).method_10807(this.field_11867));
    }

    public class_2561 method_5476() {
        return class_2561.method_43470((String)"Black Bag Block");
    }

    protected class_2371<class_1799> method_11282() {
        return this.stacks;
    }

    protected void method_11281(class_2371<class_1799> stacks) {
        this.stacks = stacks;
    }

    public void method_5447(int slot, class_1799 stack) {
        super.method_5447(slot, stack);
        if (slot >= 0 && slot < this.cachedInventory.size()) {
            this.cachedInventory.set(slot, (Object)stack.method_7972());
        }
        if (!stack.method_7960()) {
            class_3222 player;
            String gemType = null;
            switch (slot) {
                case 0: {
                    if (this.merchantGemConsumed) break;
                    this.merchantGemConsumed = true;
                    gemType = "merchant";
                    System.out.println("[DEBUG] Merchant gem consumed!");
                    break;
                }
                case 1: {
                    if (this.decoGemConsumed) break;
                    this.decoGemConsumed = true;
                    gemType = "deco";
                    System.out.println("[DEBUG] Deco gem consumed!");
                    break;
                }
                case 2: {
                    if (this.craftyGemConsumed) break;
                    this.craftyGemConsumed = true;
                    gemType = "crafty";
                    System.out.println("[DEBUG] Crafty gem consumed!");
                    break;
                }
                case 3: {
                    if (this.gardenGemConsumed) break;
                    this.gardenGemConsumed = true;
                    gemType = "garden";
                    System.out.println("[DEBUG] Garden gem consumed!");
                }
            }
            if (gemType != null && this.field_11863 != null && !this.field_11863.field_9236 && this.ownerUUID != null && (player = this.field_11863.method_8503().method_3760().method_14602(this.ownerUUID)) != null) {
                HavenBagGemPersistence.saveGemConsumption((class_1657)player, "black", gemType);
                String message = switch (gemType) {
                    case "merchant" -> "\u00a76\u2713 Merchant Gem applied successfully! Base has been expanded!";
                    case "deco" -> "\u00a7d\u2713 Deco Gem applied successfully! Base has been expanded!";
                    case "crafty" -> "\u00a7b\u2713 Crafty Gem applied successfully! Base has been expanded!";
                    case "garden" -> "\u00a7a\u2713 Garden Gem applied successfully! Base has been expanded!";
                    default -> "\u00a77\u2713 Unknown Gem applied!";
                };
                player.method_7353((class_2561)class_2561.method_43470((String)message), false);
            }
        }
        this.method_5431();
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
        }
    }

    public void method_5431() {
        super.method_5431();
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
        }
    }

    public void method_5448() {
    }

    public void method_5435(class_1657 player) {
        super.method_5435(player);
    }

    public void method_5432(class_1657 player) {
        super.method_5432(player);
    }

    public void method_54873(@Nullable class_1657 player) {
    }

    public boolean method_5437(int index, class_1799 stack) {
        return true;
    }

    public int[] method_5494(class_2350 side) {
        return IntStream.range(0, this.method_5439()).toArray();
    }

    public boolean method_5492(int index, class_1799 itemstack, @Nullable class_2350 direction) {
        return this.method_5437(index, itemstack);
    }

    public boolean method_5493(int index, class_1799 itemstack, class_2350 direction) {
        if (index == 0) {
            return false;
        }
        if (index == 1) {
            return false;
        }
        if (index == 2) {
            return false;
        }
        if (index == 3) {
            return false;
        }
        if (index == 4) {
            return false;
        }
        return index != 5;
    }

    public UUID getPocketUUID() {
        return this.pocketUUID;
    }

    public void setPocketUUID(UUID uuid) {
        this.pocketUUID = uuid;
        this.method_5431();
        System.out.println("[DEBUG] Set block UUID to: " + String.valueOf(uuid));
    }

    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    public String getOwnerName() {
        class_3222 player;
        if (this.ownerUUID == null) {
            return "Unknown";
        }
        if (this.field_11863 != null && this.field_11863.method_8503() != null && (player = this.field_11863.method_8503().method_3760().method_14602(this.ownerUUID)) != null) {
            return player.method_5477().getString();
        }
        return "Player";
    }

    public void setOwnerUUID(UUID uuid) {
        this.ownerUUID = uuid;
        this.method_5431();
        System.out.println("[DEBUG] Set owner UUID to: " + String.valueOf(uuid));
    }

    public boolean allowsEntities() {
        class_1799 entitySlot = this.method_5438(5);
        return entitySlot.method_7960() || entitySlot.method_7909() != class_1802.field_8276;
    }

    public boolean allowsPlayers() {
        class_1799 leadSlot = this.method_5438(4);
        return leadSlot.method_7960() || leadSlot.method_7909() != class_1802.field_8719;
    }

    public boolean hasConsumedGem(String gemType) {
        return switch (gemType) {
            case "merchant" -> this.merchantGemConsumed;
            case "deco" -> this.decoGemConsumed;
            case "crafty" -> this.craftyGemConsumed;
            case "garden" -> this.gardenGemConsumed;
            default -> false;
        };
    }

    public void consumeGem(String gemType) {
        switch (gemType) {
            case "merchant": {
                this.merchantGemConsumed = true;
                break;
            }
            case "deco": {
                this.decoGemConsumed = true;
                break;
            }
            case "crafty": {
                this.craftyGemConsumed = true;
                break;
            }
            case "garden": {
                this.gardenGemConsumed = true;
            }
        }
        this.method_5431();
        System.out.println("[DEBUG] Consumed gem: " + gemType);
    }

    public int getConsumedGemCount() {
        return (this.merchantGemConsumed ? 1 : 0) + (this.decoGemConsumed ? 1 : 0) + (this.craftyGemConsumed ? 1 : 0) + (this.gardenGemConsumed ? 1 : 0);
    }

    public class_2499 saveGemsToItem() {
        class_2499 itemsTag = new class_2499();
        System.out.println("[DEBUG SAVE] Checking inventory for gems...");
        System.out.println("[DEBUG SAVE] Live container size: " + this.stacks.size());
        System.out.println("[DEBUG SAVE] Cached container size: " + this.cachedInventory.size());
        class_2371<class_1799> inventoryToSave = this.cachedInventory;
        boolean cacheIsEmpty = true;
        for (class_1799 s : this.cachedInventory) {
            if (s.method_7960()) continue;
            cacheIsEmpty = false;
            break;
        }
        if (cacheIsEmpty) {
            System.out.println("[DEBUG SAVE] Cache is empty, using live inventory as fallback");
            inventoryToSave = this.stacks;
        } else {
            System.out.println("[DEBUG SAVE] Using cached inventory");
        }
        for (int i = 0; i < inventoryToSave.size(); ++i) {
            int slotIndex = i;
            class_1799 stack = (class_1799)inventoryToSave.get(i);
            System.out.println("[DEBUG SAVE] Slot " + i + ": " + (String)(stack.method_7960() ? "EMPTY" : stack.method_7909().toString() + " x" + stack.method_7947()));
            if (!stack.method_7960()) {
                DataResult result = class_1799.field_24671.encodeStart((DynamicOps)class_2509.field_11560, (Object)stack);
                result.result().ifPresent(tag -> {
                    itemsTag.add(tag);
                    System.out.println("[DEBUG SAVE] Successfully encoded gem for slot " + slotIndex);
                });
                result.error().ifPresent(error -> System.out.println("[DEBUG SAVE] ERROR encoding gem for slot " + slotIndex + ": " + String.valueOf(error)));
                continue;
            }
            itemsTag.add((Object)new class_2487());
        }
        System.out.println("[DEBUG SAVE] Saved " + itemsTag.size() + " gem slots to item NBT");
        return itemsTag;
    }

    public void restoreGemsFromItem(class_2499 gemList) {
        System.out.println("[DEBUG RESTORE] Attempting to restore " + gemList.size() + " gems from item NBT");
        System.out.println("[DEBUG RESTORE] Container size: " + this.stacks.size());
        for (int i = 0; i < Math.min(gemList.size(), this.stacks.size()); ++i) {
            class_2487 compound;
            class_2520 itemTag = gemList.method_10534(i);
            System.out.println("[DEBUG RESTORE] Processing slot " + i + ", tag type: " + itemTag.getClass().getSimpleName());
            if (itemTag instanceof class_2487 && !(compound = (class_2487)itemTag).method_33133()) {
                int slot = i;
                DataResult result = class_1799.field_24671.parse((DynamicOps)class_2509.field_11560, (Object)compound);
                result.result().ifPresent(itemStack -> {
                    this.stacks.set(slot, itemStack);
                    this.cachedInventory.set(slot, (Object)itemStack.method_7972());
                    System.out.println("[DEBUG RESTORE] \u2705 Restored gem in slot " + slot + ": " + itemStack.method_7909().toString());
                    System.out.println("[DEBUG RESTORE] \u2705 Cached restored gem in slot " + slot);
                    if (!itemStack.method_7960()) {
                        switch (slot) {
                            case 0: {
                                if (this.merchantGemConsumed) break;
                                this.merchantGemConsumed = true;
                                System.out.println("[DEBUG RESTORE] Set merchantGemConsumed = true");
                                break;
                            }
                            case 1: {
                                if (this.decoGemConsumed) break;
                                this.decoGemConsumed = true;
                                System.out.println("[DEBUG RESTORE] Set decoGemConsumed = true");
                                break;
                            }
                            case 2: {
                                if (this.craftyGemConsumed) break;
                                this.craftyGemConsumed = true;
                                System.out.println("[DEBUG RESTORE] Set craftyGemConsumed = true");
                                break;
                            }
                            case 3: {
                                if (this.gardenGemConsumed) break;
                                this.gardenGemConsumed = true;
                                System.out.println("[DEBUG RESTORE] Set gardenGemConsumed = true");
                            }
                        }
                    }
                });
                result.error().ifPresent(error -> System.out.println("[DEBUG RESTORE] \u274c ERROR restoring gem for slot " + slot + ": " + String.valueOf(error)));
                continue;
            }
            System.out.println("[DEBUG RESTORE] Slot " + i + " is empty or invalid");
        }
        this.method_5431();
        System.out.println("[DEBUG RESTORE] Finished restoring gems, calling setChanged()");
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            this.field_11863.method_8413(this.field_11867, this.method_11010(), this.method_11010(), 3);
            System.out.println("[DEBUG RESTORE] Sent block update to clients");
        }
    }

    public String saveConsumedGemsToItem() {
        StringBuilder sb = new StringBuilder();
        if (this.merchantGemConsumed) {
            sb.append("merchant,");
        }
        if (this.decoGemConsumed) {
            sb.append("deco,");
        }
        if (this.craftyGemConsumed) {
            sb.append("crafty,");
        }
        if (this.gardenGemConsumed) {
            sb.append("garden,");
        }
        String result = sb.length() > 0 ? sb.substring(0, sb.length() - 1) : "";
        System.out.println("[DEBUG] Saved consumed gems to item: " + result);
        return result;
    }

    public void restoreConsumedGemsFromItem(String gemsString) {
        this.merchantGemConsumed = false;
        this.decoGemConsumed = false;
        this.craftyGemConsumed = false;
        this.gardenGemConsumed = false;
        if (gemsString != null && !gemsString.isEmpty()) {
            String[] gemArray;
            block12: for (String gemType : gemArray = gemsString.split(",")) {
                switch (gemType.trim()) {
                    case "merchant": {
                        this.merchantGemConsumed = true;
                        this.method_5447(0, new class_1799((class_1935)HavenbagModItems.MERCHANTHAVENGEM));
                        continue block12;
                    }
                    case "deco": {
                        this.decoGemConsumed = true;
                        this.method_5447(1, new class_1799((class_1935)HavenbagModItems.DECOHAVENGEM));
                        continue block12;
                    }
                    case "crafty": {
                        this.craftyGemConsumed = true;
                        this.method_5447(2, new class_1799((class_1935)HavenbagModItems.CRAFTYHAVENGEM));
                        continue block12;
                    }
                    case "garden": {
                        this.gardenGemConsumed = true;
                        this.method_5447(3, new class_1799((class_1935)HavenbagModItems.GARDENHAVENGEM));
                    }
                }
            }
        }
        this.method_5431();
        int count = this.getConsumedGemCount();
        System.out.println("[DEBUG] Restored " + count + " consumed gems from item");
    }
}

