/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.havenbag.item;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import io.netty.buffer.Unpooled;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.mcreator.havenbag.HavenBagGemPersistence;
import net.mcreator.havenbag.block.entity.BrownBagBlockBlockEntity;
import net.mcreator.havenbag.init.HavenbagModBlocks;
import net.mcreator.havenbag.world.inventory.BagGUIMenu;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1277;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1814;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_9279;
import net.minecraft.class_9334;

public class HavenBagBrownItem
extends class_1792 {
    private static final String BAG_COLOR = "BROWN";

    public HavenBagBrownItem(class_1792.class_1793 properties) {
        super(properties.method_7894(class_1814.field_8904).method_7889(1).method_24359());
    }

    private class_3908 createMenuProvider(final class_1799 stack, final class_1657 entity, final class_1268 hand) {
        return new class_3908(){

            public class_2561 method_5476() {
                return class_2561.method_43470((String)"Haven Bag");
            }

            public class_1703 createMenu(int id, class_1661 invIgnored, class_1657 player) {
                class_2487 rootTag;
                class_2540 packetBuffer = new class_2540(Unpooled.buffer());
                packetBuffer.method_10807(entity.method_24515());
                packetBuffer.method_52997(hand == class_1268.field_5808 ? 0 : 1);
                class_1277 inventory = new class_1277(this, 4){

                    public int method_5444() {
                        return 1;
                    }
                };
                class_9279 nbtComponent = (class_9279)stack.method_57824(class_9334.field_49628);
                if (nbtComponent != null && (rootTag = nbtComponent.method_57461()).method_10545("inventory_haven_bag_brown")) {
                    class_2499 itemsTag = rootTag.method_10554("inventory_haven_bag_brown", 10);
                    for (int i = 0; i < Math.min(itemsTag.size(), 4); ++i) {
                        class_2520 itemTag = itemsTag.method_10534(i);
                        if (!(itemTag instanceof class_2487)) continue;
                        class_2487 compound = (class_2487)itemTag;
                        int slot = i;
                        class_1799.field_24671.parse((DynamicOps)class_2509.field_11560, (Object)compound).result().ifPresent(itemStack -> inventory.method_5447(slot, itemStack));
                    }
                }
                inventory.method_5489(inv -> {
                    class_2499 itemsTag = new class_2499();
                    for (int i = 0; i < inventory.method_5439(); ++i) {
                        class_1799 itemStack = inventory.method_5438(i);
                        if (!itemStack.method_7960()) {
                            DataResult result = class_1799.field_24671.encodeStart((DynamicOps)class_2509.field_11560, (Object)itemStack);
                            result.result().ifPresent(arg_0 -> itemsTag.add(arg_0));
                            continue;
                        }
                        itemsTag.add((Object)new class_2487());
                    }
                    class_2487 rootTag = new class_2487();
                    rootTag.method_10566("inventory_haven_bag_brown", (class_2520)itemsTag);
                    stack.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)rootTag));
                });
                return new BagGUIMenu(id, invIgnored, (class_1263)inventory, packetBuffer);
            }
        };
    }

    public void method_7851(class_1799 itemstack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 flag) {
        Object consumedGemsStr;
        super.method_7851(itemstack, context, tooltip, flag);
        tooltip.add((class_2561)class_2561.method_43471((String)"item.havenbag.haven_bag_brown.description_0"));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.havenbag.haven_bag_brown.description_1"));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.havenbag.haven_bag_brown.description_2"));
        class_9279 customData = (class_9279)itemstack.method_57825(class_9334.field_49628, (Object)class_9279.field_49302);
        class_2487 tag = customData.method_57461();
        int gemCount = 0;
        ArrayList<String> appliedGems = new ArrayList<String>();
        if (tag.method_10545("ConsumedGems") && !((String)(consumedGemsStr = tag.method_10558("ConsumedGems"))).isEmpty()) {
            String[] gems;
            for (String gem : gems = ((String)consumedGemsStr).split(",")) {
                appliedGems.add(gem.trim());
            }
        }
        gemCount = appliedGems.size();
        tooltip.add((class_2561)class_2561.method_43470((String)("\u00a75\u2726 Applied Gems: \u00a7e" + gemCount + "\u00a77/\u00a7e4")));
        consumedGemsStr = appliedGems.iterator();
        while (consumedGemsStr.hasNext()) {
            String gem;
            String displayName = switch (gem = (String)consumedGemsStr.next()) {
                case "garden" -> "\u00a72Garden";
                case "deco" -> "\u00a7bDeco";
                case "merchant" -> "\u00a76Merchant";
                case "crafty" -> "\u00a7aCrafty";
                default -> gem;
            };
            tooltip.add((class_2561)class_2561.method_43470((String)("  \u00a78\u2022 " + displayName)));
        }
        UUID ownerUUID = HavenBagBrownItem.getOwnerUUID(itemstack);
        if (ownerUUID != null) {
            String ownerName = HavenBagBrownItem.getOwnerName(itemstack);
            if (ownerName != null && !ownerName.isEmpty()) {
                tooltip.add((class_2561)class_2561.method_43470((String)("\u00a76Owner: \u00a7e" + ownerName)));
            } else {
                String ownerDisplay = ownerUUID.toString().substring(0, 8) + "...";
                tooltip.add((class_2561)class_2561.method_43470((String)("\u00a76Owner: \u00a7e" + ownerDisplay)));
            }
        }
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 entity, class_1268 hand) {
        class_1799 itemstack = entity.method_5998(hand);
        if (entity instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)entity;
            serverPlayer.method_17355(this.createMenuProvider(itemstack, entity, hand));
        }
        return class_1271.method_22427((Object)itemstack);
    }

    public class_1269 method_7884(class_1838 context) {
        class_1937 world = context.method_8045();
        class_1657 player = context.method_8036();
        class_1799 itemstack = context.method_8041();
        class_2338 clickedPos = context.method_8037();
        if (player != null) {
            class_2338 placePos;
            UUID pocketUUID = HavenBagBrownItem.getPocketUUID(itemstack);
            if (pocketUUID == null) {
                UUID ownerUUID = HavenBagBrownItem.getOwnerUUID(itemstack);
                if (ownerUUID != null) {
                    pocketUUID = this.generatePocketUUID(ownerUUID, BAG_COLOR);
                    this.setPocketUUID(itemstack, pocketUUID);
                } else {
                    pocketUUID = this.generatePocketUUID(player.method_5667(), BAG_COLOR);
                    this.setPocketUUID(itemstack, pocketUUID);
                }
            }
            if (!world.field_9236) {
                System.out.println("[DEBUG] Placing BROWN bag with UUID: " + String.valueOf(pocketUUID));
            }
            if (world.method_8320(placePos = clickedPos.method_10093(context.method_8038())).method_26215()) {
                class_1750 placeContext = new class_1750(context);
                class_2680 blockState = HavenbagModBlocks.BROWN_BAG_BLOCK.method_9605(placeContext);
                if (blockState == null) {
                    return class_1269.field_5814;
                }
                world.method_8652(placePos, blockState, 3);
                class_2586 class_25862 = world.method_8321(placePos);
                if (class_25862 instanceof BrownBagBlockBlockEntity) {
                    BrownBagBlockBlockEntity bagEntity = (BrownBagBlockBlockEntity)class_25862;
                    bagEntity.setPocketUUID(pocketUUID);
                    UUID itemOwnerUUID = HavenBagBrownItem.getOwnerUUID(itemstack);
                    if (itemOwnerUUID != null) {
                        bagEntity.setOwnerUUID(itemOwnerUUID);
                    } else {
                        bagEntity.setOwnerUUID(player.method_5667());
                    }
                    class_9279 customData = (class_9279)itemstack.method_57825(class_9334.field_49628, (Object)class_9279.field_49302);
                    class_2487 tag = customData.method_57461();
                    if (tag.method_10545("StoredGems")) {
                        class_2499 gemList = (class_2499)tag.method_10580("StoredGems");
                        if (gemList != null && !gemList.isEmpty()) {
                            System.out.println("[DEBUG] Found " + gemList.size() + " stored gems in item NBT, attempting restore...");
                            bagEntity.restoreGemsFromItem(gemList);
                        } else {
                            System.out.println("[DEBUG] StoredGems tag exists but list is empty/null");
                        }
                    } else {
                        System.out.println("[DEBUG] No StoredGems tag found on item");
                    }
                    if (tag.method_10545("LeadCount")) {
                        int leadCount = tag.method_10550("LeadCount");
                        if (leadCount > 0) {
                            class_1799 leadStack = new class_1799((class_1935)class_1802.field_8719, leadCount);
                            bagEntity.method_5447(4, leadStack);
                            System.out.println("[DEBUG] Restored " + leadCount + " lead items to slot 4");
                        } else {
                            System.out.println("[DEBUG] Bag was previously unlocked (LeadCount=0), leaving slot 4 empty");
                        }
                    } else {
                        class_1799 leadStack = new class_1799((class_1935)class_1802.field_8719, 1);
                        bagEntity.method_5447(4, leadStack);
                        System.out.println("[DEBUG] Newly crafted bag - added 1 lead item to slot 4 (bag starts locked)");
                        class_1799 stringStack = new class_1799((class_1935)class_1802.field_8276, 1);
                        bagEntity.method_5447(5, stringStack);
                        System.out.println("[DEBUG] Newly crafted bag - added 1 string to slot 5 (entities blocked by default)");
                    }
                    HavenBagGemPersistence.restoreGemsToBagEntity(player, "brown", (Object)bagEntity);
                }
                if (!player.method_7337()) {
                    itemstack.method_7934(1);
                }
                return class_1269.field_5812;
            }
        }
        return class_1269.field_5814;
    }

    public void method_54465(class_1799 stack, class_1937 world, class_1657 player) {
        super.method_54465(stack, world, player);
        if (!world.field_9236) {
            class_3222 serverPlayer;
            String unlockedGems;
            UUID pocketUUID = this.generatePocketUUID(player.method_5667(), BAG_COLOR);
            this.setPocketUUID(stack, pocketUUID);
            if (HavenBagBrownItem.getOwnerUUID(stack) == null) {
                this.setOwnerUUID(stack, player.method_5667());
                this.setOwnerName(stack, player.method_5477().getString());
            }
            if (player instanceof class_3222 && !(unlockedGems = HavenBagGemPersistence.getUnlockedGemsString((class_1657)(serverPlayer = (class_3222)player), "brown")).isEmpty()) {
                class_2487 tag = ((class_9279)stack.method_57825(class_9334.field_49628, (Object)class_9279.field_49302)).method_57461();
                tag.method_10582("ConsumedGems", unlockedGems);
                stack.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)tag));
            }
        }
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        super.method_7888(stack, world, entity, slot, selected);
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            if (HavenBagBrownItem.getOwnerUUID(stack) == null) {
                class_3222 serverPlayer;
                String unlockedGems;
                UUID pocketUUID = this.generatePocketUUID(player.method_5667(), BAG_COLOR);
                this.setPocketUUID(stack, pocketUUID);
                this.setOwnerUUID(stack, player.method_5667());
                this.setOwnerName(stack, player.method_5477().getString());
                if (player instanceof class_3222 && !(unlockedGems = HavenBagGemPersistence.getUnlockedGemsString((class_1657)(serverPlayer = (class_3222)player), "brown")).isEmpty()) {
                    class_2487 tag = ((class_9279)stack.method_57825(class_9334.field_49628, (Object)class_9279.field_49302)).method_57461();
                    tag.method_10582("ConsumedGems", unlockedGems);
                    stack.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)tag));
                }
            }
        }
    }

    private UUID generatePocketUUID(UUID playerUUID, String bagColor) {
        try {
            String input = playerUUID.toString() + ":" + bagColor;
            MessageDigest digest = MessageDigest.getInstance("MD5");
            byte[] hash = digest.digest(input.getBytes(StandardCharsets.UTF_8));
            ByteBuffer buffer = ByteBuffer.wrap(hash);
            long mostSigBits = buffer.getLong();
            long leastSigBits = buffer.getLong();
            return new UUID(mostSigBits, leastSigBits);
        }
        catch (Exception e) {
            e.printStackTrace();
            return UUID.randomUUID();
        }
    }

    private void setPocketUUID(class_1799 stack, UUID pocketUUID) {
        class_2487 tag = ((class_9279)stack.method_57825(class_9334.field_49628, (Object)class_9279.field_49302)).method_57461();
        tag.method_10544("PocketUUIDMost", pocketUUID.getMostSignificantBits());
        tag.method_10544("PocketUUIDLeast", pocketUUID.getLeastSignificantBits());
        stack.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)tag));
    }

    public static UUID getPocketUUID(class_1799 stack) {
        class_9279 customData = (class_9279)stack.method_57825(class_9334.field_49628, (Object)class_9279.field_49302);
        class_2487 tag = customData.method_57461();
        if (tag.method_10545("PocketUUIDMost") && tag.method_10545("PocketUUIDLeast")) {
            long msb = tag.method_10537("PocketUUIDMost");
            long lsb = tag.method_10537("PocketUUIDLeast");
            return new UUID(msb, lsb);
        }
        return null;
    }

    private void setOwnerUUID(class_1799 stack, UUID ownerUUID) {
        class_2487 tag = ((class_9279)stack.method_57825(class_9334.field_49628, (Object)class_9279.field_49302)).method_57461();
        tag.method_10544("OwnerUUIDMost", ownerUUID.getMostSignificantBits());
        tag.method_10544("OwnerUUIDLeast", ownerUUID.getLeastSignificantBits());
        stack.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)tag));
    }

    public static UUID getOwnerUUID(class_1799 stack) {
        class_9279 customData = (class_9279)stack.method_57825(class_9334.field_49628, (Object)class_9279.field_49302);
        class_2487 tag = customData.method_57461();
        if (tag.method_10545("OwnerUUIDMost") && tag.method_10545("OwnerUUIDLeast")) {
            long ownerMsb = tag.method_10537("OwnerUUIDMost");
            long ownerLsb = tag.method_10537("OwnerUUIDLeast");
            return new UUID(ownerMsb, ownerLsb);
        }
        return null;
    }

    private void setOwnerName(class_1799 stack, String ownerName) {
        class_2487 tag = ((class_9279)stack.method_57825(class_9334.field_49628, (Object)class_9279.field_49302)).method_57461();
        tag.method_10582("OwnerName", ownerName);
        stack.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)tag));
    }

    public static String getOwnerName(class_1799 stack) {
        class_9279 customData = (class_9279)stack.method_57825(class_9334.field_49628, (Object)class_9279.field_49302);
        class_2487 tag = customData.method_57461();
        if (tag.method_10545("OwnerName")) {
            return tag.method_10558("OwnerName");
        }
        return "Unknown";
    }
}

