/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.havenbag.procedures;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.mcreator.havenbag.HavenPocketSavedData;
import net.mcreator.havenbag.HavenReturnSavedData;
import net.mcreator.havenbag.block.entity.BlackBagBlockBlockEntity;
import net.mcreator.havenbag.block.entity.BlueBagBlockBlockEntity;
import net.mcreator.havenbag.block.entity.BrownBagBlockBlockEntity;
import net.mcreator.havenbag.block.entity.GreenBagBlockBlockEntity;
import net.mcreator.havenbag.block.entity.RedBagBlockBlockEntity;
import net.mcreator.havenbag.block.entity.WhiteBagBlockBlockEntity;
import net.mcreator.havenbag.block.entity.YellowBagBlockBlockEntity;
import net.minecraft.class_1263;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2696;
import net.minecraft.class_2783;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_5321;
import net.minecraft.class_5425;
import net.minecraft.class_7924;

public class BagBlockEntityWalksOnTheBlockProcedure {
    public static boolean eventResult = true;
    private static final Map<String, double[]> bagReturnPositions = new HashMap<String, double[]>();
    private static final Map<String, String> bagReturnDimensions = new HashMap<String, String>();
    private static final Map<UUID, Long> pendingTeleports = new HashMap<UUID, Long>();
    private static final long ENTRY_DELAY_MS = 1000L;

    public static void execute(class_1936 world, class_1297 entity, class_2338 pos) {
        if (entity == null || !(world instanceof class_3218)) {
            return;
        }
        class_3218 _serverLevel = (class_3218)world;
        try {
            BagBlockEntityWalksOnTheBlockProcedure.loadSavedReturns(_serverLevel);
        }
        catch (Throwable t) {
            System.out.println("[DEBUG ERROR] Failed to load saved return positions: " + String.valueOf(t));
            t.printStackTrace();
        }
        class_2586 be = _serverLevel.method_8321(pos);
        UUID pocketUUID = null;
        UUID ownerUUID = null;
        boolean allowsPlayers = false;
        boolean allowsEntities = false;
        String bagColor = null;
        if (be instanceof BlackBagBlockBlockEntity) {
            BlackBagBlockBlockEntity blackBag = (BlackBagBlockBlockEntity)be;
            pocketUUID = blackBag.getPocketUUID();
            ownerUUID = blackBag.getOwnerUUID();
            allowsPlayers = blackBag.allowsPlayers();
            allowsEntities = blackBag.allowsEntities();
            bagColor = "black";
        } else if (be instanceof BlueBagBlockBlockEntity) {
            BlueBagBlockBlockEntity blueBag = (BlueBagBlockBlockEntity)be;
            pocketUUID = blueBag.getPocketUUID();
            ownerUUID = blueBag.getOwnerUUID();
            allowsPlayers = blueBag.allowsPlayers();
            allowsEntities = blueBag.allowsEntities();
            bagColor = "blue";
        } else if (be instanceof RedBagBlockBlockEntity) {
            RedBagBlockBlockEntity redBag = (RedBagBlockBlockEntity)be;
            pocketUUID = redBag.getPocketUUID();
            ownerUUID = redBag.getOwnerUUID();
            allowsPlayers = redBag.allowsPlayers();
            allowsEntities = redBag.allowsEntities();
            bagColor = "red";
        } else if (be instanceof GreenBagBlockBlockEntity) {
            GreenBagBlockBlockEntity greenBag = (GreenBagBlockBlockEntity)be;
            pocketUUID = greenBag.getPocketUUID();
            ownerUUID = greenBag.getOwnerUUID();
            allowsPlayers = greenBag.allowsPlayers();
            allowsEntities = greenBag.allowsEntities();
            bagColor = "green";
        } else if (be instanceof WhiteBagBlockBlockEntity) {
            WhiteBagBlockBlockEntity whiteBag = (WhiteBagBlockBlockEntity)be;
            pocketUUID = whiteBag.getPocketUUID();
            ownerUUID = whiteBag.getOwnerUUID();
            allowsPlayers = whiteBag.allowsPlayers();
            allowsEntities = whiteBag.allowsEntities();
            bagColor = "white";
        } else if (be instanceof YellowBagBlockBlockEntity) {
            YellowBagBlockBlockEntity yellowBag = (YellowBagBlockBlockEntity)be;
            pocketUUID = yellowBag.getPocketUUID();
            ownerUUID = yellowBag.getOwnerUUID();
            allowsPlayers = yellowBag.allowsPlayers();
            allowsEntities = yellowBag.allowsEntities();
            bagColor = "yellow";
        } else if (be instanceof BrownBagBlockBlockEntity) {
            BrownBagBlockBlockEntity brownBag = (BrownBagBlockBlockEntity)be;
            pocketUUID = brownBag.getPocketUUID();
            ownerUUID = brownBag.getOwnerUUID();
            allowsPlayers = brownBag.allowsPlayers();
            allowsEntities = brownBag.allowsEntities();
            bagColor = "brown";
        } else {
            return;
        }
        if (entity instanceof class_3222) {
            boolean isOwner;
            class_3222 _player = (class_3222)entity;
            UUID playerUUID = _player.method_5667();
            boolean bl = isOwner = ownerUUID != null && ownerUUID.equals(playerUUID);
            if (!isOwner && !allowsPlayers) {
                _player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7c\ud83d\udd12 This Haven Bag is locked! The owner must remove the lead to grant access."), true);
                return;
            }
            long currentTime = System.currentTimeMillis();
            if (pendingTeleports.containsKey(playerUUID)) {
                long cooldownMs;
                long pendingTime = pendingTeleports.get(playerUUID);
                long l = cooldownMs = currentTime - pendingTime < 1000L ? 1000L : 5000L;
                if (currentTime - pendingTime < cooldownMs) {
                    return;
                }
            }
            pendingTeleports.put(playerUUID, currentTime);
            String positionKey = playerUUID.toString() + "_" + bagColor;
            String currentDim = _player.method_37908().method_27983().method_29177().toString();
            double[] savedPos = new double[]{(double)pos.method_10263() + 0.5, pos.method_10264() + 1, (double)pos.method_10260() + 0.5, entity.method_36454(), entity.method_36455()};
            bagReturnPositions.put(positionKey, savedPos);
            bagReturnDimensions.put(positionKey, currentDim);
            try {
                class_1937 class_19372 = _player.method_37908();
                if (class_19372 instanceof class_3218) {
                    class_3218 playerServerLevel = (class_3218)class_19372;
                    HavenReturnSavedData saved = HavenReturnSavedData.get(playerServerLevel);
                    saved.saveReturnPosition(_player.method_5667(), bagColor, savedPos, currentDim);
                    System.out.println("[DEBUG] Persisted return position to HavenReturnSavedData for " + positionKey);
                }
            }
            catch (Throwable t) {
                System.out.println("[DEBUG ERROR] Failed to persist return position for " + positionKey + ": " + String.valueOf(t));
                t.printStackTrace();
            }
            System.out.println("[DEBUG] Saved return position for player " + _player.method_5477().getString() + " for " + bagColor + " bag at " + String.valueOf(pos) + " in dimension " + currentDim);
        } else if (!allowsEntities) {
            return;
        }
        int roomX = (int)((pocketUUID.getMostSignificantBits() & Integer.MAX_VALUE) % 1000000L);
        int roomZ = (int)((pocketUUID.getLeastSignificantBits() & Integer.MAX_VALUE) % 1000000L);
        int roomY = 100;
        class_5321 havenDimKey = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)class_2960.method_60654((String)"havenbag:haven_dimension"));
        class_3218 havenLevel = _serverLevel.method_8503().method_3847(havenDimKey);
        if (havenLevel != null) {
            HavenPocketSavedData pocketData = HavenPocketSavedData.get(havenLevel);
            pocketData.registerPocketColor(pocketUUID, bagColor);
            class_2338 structurePos = new class_2338(roomX, roomY, roomZ);
            if (!pocketData.isStructurePlaced(pocketUUID)) {
                String structureName = bagColor + "haven";
                class_3499 template = havenLevel.method_14183().method_15094(class_2960.method_60654((String)("havenbag:" + structureName))).orElse(null);
                if (template != null) {
                    template.method_15172((class_5425)havenLevel, structurePos, structurePos, new class_3492().method_15123(class_2470.field_11467).method_15125(class_2415.field_11302).method_15133(false), havenLevel.field_9229, 3);
                }
                pocketData.markStructurePlaced(pocketUUID);
            }
            if (be instanceof class_1263) {
                class_1263 container = (class_1263)be;
                BagBlockEntityWalksOnTheBlockProcedure.placeGemExpansions(havenLevel, structurePos, bagColor, container, pocketUUID, pocketData);
            }
            if (entity instanceof class_3222) {
                class_3222 _player = (class_3222)entity;
                double playerX = _player.method_23317();
                double playerY = _player.method_23318();
                double playerZ = _player.method_23321();
                double bagX = (double)pos.method_10263() + 0.5;
                double bagZ = (double)pos.method_10260() + 0.5;
                double horizontalDistance = Math.sqrt(Math.pow(playerX - bagX, 2.0) + Math.pow(playerZ - bagZ, 2.0));
                System.out.println("[DEBUG TELEPORT] Player: (" + playerX + ", " + playerY + ", " + playerZ + ")");
                System.out.println("[DEBUG TELEPORT] Bag center: (" + bagX + ", " + (pos.method_10264() + 1) + ", " + bagZ + ")");
                System.out.println("[DEBUG TELEPORT] Horizontal distance: " + horizontalDistance);
                if (horizontalDistance <= 1.0) {
                    _player.method_7353((class_2561)class_2561.method_43470((String)"\u00a76\u2728 Entering Haven Dimension..."), true);
                    _player.method_48105(havenLevel, (double)roomX + 7.5, (double)(roomY + 7), (double)roomZ + 7.5, Set.of(), _player.method_36454(), _player.method_36455());
                    _player.field_13987.method_14364((class_2596)new class_2696(_player.method_31549()));
                    for (class_1293 _effectinstance : _player.method_6026()) {
                        _player.field_13987.method_14364((class_2596)new class_2783(_player.method_5628(), _effectinstance, false));
                    }
                    System.out.println("[DEBUG] Teleported player to haven dimension");
                } else {
                    _player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7cToo far from bag center - move closer to teleport."), true);
                    System.out.println("[DEBUG] Player too far from bag center for teleport");
                }
            } else {
                entity.method_48105(havenLevel, (double)roomX + 7.5, (double)(roomY + 7), (double)roomZ + 7.5, Set.of(), entity.method_36454(), entity.method_36455());
                System.out.println("[DEBUG] Teleported " + entity.method_5864().toString() + " to haven dimension");
            }
        }
    }

    private static void loadSavedReturns(class_3218 level) {
        try {
            if (level == null) {
                return;
            }
            HavenReturnSavedData saved = HavenReturnSavedData.get(level);
            if (saved == null) {
                return;
            }
            for (String key : saved.getAllReturnKeys()) {
                try {
                    String[] parts;
                    if (key == null || key.isEmpty() || (parts = key.split("_", 2)).length < 2) continue;
                    UUID playerId = UUID.fromString(parts[0]);
                    String bagColor = parts[1];
                    double[] pos = saved.getReturnPosition(playerId, bagColor);
                    String dim = saved.getReturnDimension(playerId, bagColor);
                    if (pos != null) {
                        bagReturnPositions.put(key, pos);
                    }
                    if (dim == null) continue;
                    bagReturnDimensions.put(key, dim);
                }
                catch (Throwable throwable) {}
            }
            System.out.println("[DEBUG] Loaded " + saved.getAllReturnKeys().size() + " persisted return entries");
        }
        catch (Throwable t) {
            System.out.println("[DEBUG ERROR] Error loading saved returns: " + String.valueOf(t));
            t.printStackTrace();
        }
    }

    public static double[] getBagReturnPosition(UUID playerId, String bagColor) {
        String key = playerId.toString() + "_" + bagColor;
        return bagReturnPositions.get(key);
    }

    public static String getBagReturnDimension(UUID playerId, String bagColor) {
        String key = playerId.toString() + "_" + bagColor;
        return bagReturnDimensions.get(key);
    }

    public static void clearBagReturnData(UUID playerId, String bagColor) {
        String key = playerId.toString() + "_" + bagColor;
        bagReturnPositions.remove(key);
        bagReturnDimensions.remove(key);
        System.out.println("[DEBUG] Cleared return data for player " + String.valueOf(playerId) + " and " + bagColor + " bag");
    }

    public static String getBagColorAtPosition(class_3218 havenLevel, class_2338 playerPos) {
        HavenPocketSavedData pocketData = HavenPocketSavedData.get(havenLevel);
        for (UUID pocketUUID : pocketData.getAllPocketIds()) {
            String color;
            int roomX = (int)((pocketUUID.getMostSignificantBits() & Integer.MAX_VALUE) % 1000000L);
            int roomZ = (int)((pocketUUID.getLeastSignificantBits() & Integer.MAX_VALUE) % 1000000L);
            int roomY = 100;
            if (Math.abs(playerPos.method_10263() - roomX) > 50 || Math.abs(playerPos.method_10260() - roomZ) > 50 || Math.abs(playerPos.method_10264() - roomY) > 20 || (color = pocketData.getPocketColor(pocketUUID)) == null) continue;
            return color;
        }
        return null;
    }

    private static void placeGemExpansions(class_3218 havenLevel, class_2338 basePos, String bagColor, class_1263 container, UUID pocketUUID, HavenPocketSavedData pocketData) {
        if (!container.method_5438(0).method_7960() && !pocketData.hasExpansion(pocketUUID, "north")) {
            BagBlockEntityWalksOnTheBlockProcedure.placeExpansion(havenLevel, basePos, bagColor, "north");
            pocketData.markExpansion(pocketUUID, "north");
            System.out.println("[DEBUG] Placed NORTH expansion for " + bagColor + " bag");
        }
        if (!container.method_5438(1).method_7960() && !pocketData.hasExpansion(pocketUUID, "east")) {
            BagBlockEntityWalksOnTheBlockProcedure.placeExpansion(havenLevel, basePos, bagColor, "east");
            pocketData.markExpansion(pocketUUID, "east");
            System.out.println("[DEBUG] Placed EAST expansion for " + bagColor + " bag");
        }
        if (!container.method_5438(2).method_7960() && !pocketData.hasExpansion(pocketUUID, "west")) {
            BagBlockEntityWalksOnTheBlockProcedure.placeExpansion(havenLevel, basePos, bagColor, "west");
            pocketData.markExpansion(pocketUUID, "west");
            System.out.println("[DEBUG] Placed WEST expansion for " + bagColor + " bag");
        }
        if (!container.method_5438(3).method_7960() && !pocketData.hasExpansion(pocketUUID, "south")) {
            BagBlockEntityWalksOnTheBlockProcedure.placeExpansion(havenLevel, basePos, bagColor, "south");
            pocketData.markExpansion(pocketUUID, "south");
            System.out.println("[DEBUG] Placed SOUTH expansion for " + bagColor + " bag");
        }
    }

    private static void placeExpansion(class_3218 havenLevel, class_2338 basePos, String bagColor, String direction) {
        String structureName = bagColor + direction;
        class_3499 template = havenLevel.method_14183().method_15094(class_2960.method_60654((String)("havenbag:" + structureName))).orElse(null);
        if (template != null) {
            class_2338 expansionPos = basePos;
            switch (direction) {
                case "north": {
                    expansionPos = basePos.method_10069(0, 0, -14);
                    break;
                }
                case "south": {
                    expansionPos = basePos.method_10069(0, 0, 14);
                    break;
                }
                case "east": {
                    expansionPos = basePos.method_10069(14, 0, 0);
                    break;
                }
                case "west": {
                    expansionPos = basePos.method_10069(-14, 0, 0);
                }
            }
            template.method_15172((class_5425)havenLevel, expansionPos, expansionPos, new class_3492().method_15123(class_2470.field_11467).method_15125(class_2415.field_11302).method_15133(false), havenLevel.field_9229, 3);
        }
    }
}

