/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.havenbag;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.mcreator.havenbag.ReturnLocationSavedData;
import net.minecraft.class_18;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_3218;

public class HavenPocketSavedData
extends class_18 {
    private static final String DATA_NAME = "haven_pocket_data";
    private final Set<UUID> structuresPlaced = new HashSet<UUID>();
    private final Set<String> expansionsPlaced = new HashSet<String>();
    private final Map<UUID, String> pocketColors = new HashMap<UUID, String>();
    private final Map<UUID, UUID> pocketParents = new HashMap<UUID, UUID>();
    private final Map<UUID, UUID> pocketOwners = new HashMap<UUID, UUID>();

    private static HavenPocketSavedData load(class_2487 tag) {
        HavenPocketSavedData data = new HavenPocketSavedData();
        data.loadFromTag(tag);
        return data;
    }

    public static HavenPocketSavedData get(class_3218 level) {
        return ReturnLocationSavedData.getHavenPocketSavedData(level);
    }

    private void loadFromTag(class_2487 tag) {
        tag.method_10554("Structures").ifPresent(structureList -> {
            for (int i = 0; i < structureList.size(); ++i) {
                structureList.method_10608(i).ifPresent(s -> {
                    try {
                        this.structuresPlaced.add(UUID.fromString(s));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                });
            }
        });
        tag.method_10554("Expansions").ifPresent(expansionList -> {
            for (int i = 0; i < expansionList.size(); ++i) {
                expansionList.method_10608(i).ifPresent(this.expansionsPlaced::add);
            }
        });
        tag.method_10554("PocketColors").ifPresent(colorList -> {
            for (int i = 0; i < colorList.size(); ++i) {
                colorList.method_10602(i).ifPresent(entry -> {
                    if (entry.method_10545("Id") && entry.method_10545("Color")) {
                        entry.method_10558("Id").ifPresent(id -> entry.method_10558("Color").ifPresent(color -> {
                            try {
                                this.pocketColors.put(UUID.fromString(id), (String)color);
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                // empty catch block
                            }
                        }));
                    }
                });
            }
        });
        tag.method_10554("PocketParents").ifPresent(parentList -> {
            for (int i = 0; i < parentList.size(); ++i) {
                parentList.method_10602(i).ifPresent(entry -> {
                    if (entry.method_10545("Id") && entry.method_10545("Parent")) {
                        entry.method_10558("Id").ifPresent(id -> entry.method_10558("Parent").ifPresent(parent -> {
                            try {
                                UUID childId = UUID.fromString(id);
                                if (parent != null && !parent.isEmpty()) {
                                    this.pocketParents.put(childId, UUID.fromString(parent));
                                }
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                // empty catch block
                            }
                        }));
                    }
                });
            }
        });
        tag.method_10554("PocketOwners").ifPresent(ownerList -> {
            for (int i = 0; i < ownerList.size(); ++i) {
                ownerList.method_10602(i).ifPresent(entry -> {
                    if (entry.method_10545("Id") && entry.method_10545("Owner")) {
                        entry.method_10558("Id").ifPresent(id -> entry.method_10558("Owner").ifPresent(owner -> {
                            try {
                                UUID pocketId = UUID.fromString(id);
                                if (owner != null && !owner.isEmpty()) {
                                    this.pocketOwners.put(pocketId, UUID.fromString(owner));
                                }
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                // empty catch block
                            }
                        }));
                    }
                });
            }
        });
    }

    public class_2487 save() {
        class_2487 tag = new class_2487();
        return this.save(tag);
    }

    public class_2487 save(class_2487 tag) {
        class_2499 structureList = new class_2499();
        for (UUID uUID : this.structuresPlaced) {
            structureList.add((Object)class_2519.method_23256((String)uUID.toString()));
        }
        tag.method_10566("Structures", (class_2520)structureList);
        class_2499 expansionList = new class_2499();
        for (String string : this.expansionsPlaced) {
            expansionList.add((Object)class_2519.method_23256((String)string));
        }
        tag.method_10566("Expansions", (class_2520)expansionList);
        class_2499 class_24992 = new class_2499();
        for (Map.Entry<UUID, String> entry : this.pocketColors.entrySet()) {
            class_2487 class_24872 = new class_2487();
            class_24872.method_10582("Id", entry.getKey().toString());
            class_24872.method_10582("Color", entry.getValue());
            class_24992.add((Object)class_24872);
        }
        tag.method_10566("PocketColors", (class_2520)class_24992);
        class_2499 class_24993 = new class_2499();
        for (Map.Entry<UUID, UUID> entry : this.pocketParents.entrySet()) {
            class_2487 parentEntry = new class_2487();
            parentEntry.method_10582("Id", entry.getKey().toString());
            UUID parent = entry.getValue();
            parentEntry.method_10582("Parent", parent == null ? "" : parent.toString());
            class_24993.add((Object)parentEntry);
        }
        tag.method_10566("PocketParents", (class_2520)class_24993);
        class_2499 class_24994 = new class_2499();
        for (Map.Entry<UUID, UUID> entry : this.pocketOwners.entrySet()) {
            class_2487 ownerEntry = new class_2487();
            ownerEntry.method_10582("Id", entry.getKey().toString());
            UUID owner = entry.getValue();
            ownerEntry.method_10582("Owner", owner == null ? "" : owner.toString());
            class_24994.add((Object)ownerEntry);
        }
        tag.method_10566("PocketOwners", (class_2520)class_24994);
        return tag;
    }

    public boolean isStructurePlaced(UUID uuid) {
        return this.structuresPlaced.contains(uuid);
    }

    public void markStructurePlaced(UUID uuid) {
        if (this.structuresPlaced.add(uuid)) {
            this.method_80();
        }
    }

    public boolean hasExpansion(UUID uuid, String direction) {
        return this.expansionsPlaced.contains(HavenPocketSavedData.expansionKey(uuid, direction));
    }

    public void markExpansion(UUID uuid, String direction) {
        if (this.expansionsPlaced.add(HavenPocketSavedData.expansionKey(uuid, direction))) {
            this.method_80();
        }
    }

    public void registerPocketColor(UUID uuid, String color) {
        String existing = this.pocketColors.get(uuid);
        if (!color.equals(existing)) {
            this.pocketColors.put(uuid, color);
            this.method_80();
        }
    }

    public String getPocketColor(UUID uuid) {
        return this.pocketColors.get(uuid);
    }

    public void registerPocketParent(UUID uuid, UUID parent) {
        UUID existing = this.pocketParents.get(uuid);
        if (parent == null) {
            if (existing != null) {
                this.pocketParents.remove(uuid);
                this.method_80();
            }
        } else if (!parent.equals(existing)) {
            this.pocketParents.put(uuid, parent);
            this.method_80();
        }
    }

    public void registerPocketParentIfAbsent(UUID uuid, UUID parent) {
        if (parent == null) {
            return;
        }
        UUID existing = this.pocketParents.get(uuid);
        if (existing == null) {
            this.pocketParents.put(uuid, parent);
            this.method_80();
        }
    }

    public UUID getPocketParent(UUID uuid) {
        return this.pocketParents.get(uuid);
    }

    public void registerPocketOwner(UUID uuid, UUID owner) {
        UUID existing = this.pocketOwners.get(uuid);
        if (owner == null) {
            if (existing != null) {
                this.pocketOwners.remove(uuid);
                this.method_80();
            }
        } else if (!owner.equals(existing)) {
            this.pocketOwners.put(uuid, owner);
            this.method_80();
        }
    }

    public UUID getPocketOwner(UUID uuid) {
        return this.pocketOwners.get(uuid);
    }

    public Set<UUID> getAllPocketIds() {
        return Collections.unmodifiableSet(this.structuresPlaced);
    }

    public Set<String> getAllExpansionKeys() {
        return Collections.unmodifiableSet(this.expansionsPlaced);
    }

    public Map<UUID, String> getPocketColorMap() {
        return Collections.unmodifiableMap(this.pocketColors);
    }

    private static String expansionKey(UUID uuid, String direction) {
        return uuid.toString() + "_" + direction;
    }
}

