/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.havenbag;

import com.mojang.serialization.Codec;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import net.mcreator.havenbag.HavenPocketSavedData;
import net.minecraft.class_10741;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_4284;

public class ReturnLocationSavedData
extends class_18 {
    public static final String RETURN_DATA_NAME = "haven_return_locations";
    public static final String HAVEN_POCKET_DATA_NAME = "haven_pocket_data";
    private static final Codec<ReturnLocationSavedData> RETURN_CODEC = class_2487.field_25128.xmap(ReturnLocationSavedData::loadFromCompound, data -> data.toCompound());
    private static final class_10741<ReturnLocationSavedData> TYPE = new class_10741("haven_return_locations", ReturnLocationSavedData::new, RETURN_CODEC, class_4284.field_45078);
    private static final class_10741<HavenPocketSavedData> HAVEN_POCKET_TYPE = ReturnLocationSavedData.createHavenPocketType();
    private final Map<String, ReturnLocation> returnLocations = new HashMap<String, ReturnLocation>();
    private final List<PlacedBag> placedBags = new ArrayList<PlacedBag>();

    public void registerPlacedBag(UUID owner, String color, String dimension, class_2338 pos) {
        if (owner == null || color == null || dimension == null || pos == null) {
            return;
        }
        PlacedBag pb = new PlacedBag(owner, color, dimension, pos);
        if (!this.placedBags.contains(pb)) {
            this.placedBags.add(pb);
            this.method_80();
        }
    }

    public void removePlacedBag(UUID owner, String color, class_2338 pos) {
        if (owner == null || color == null || pos == null) {
            return;
        }
        boolean removed = this.placedBags.removeIf(pb -> owner.equals(pb.owner) && color.equals(pb.color) && pb.pos.equals((Object)pos));
        if (removed) {
            this.method_80();
        }
    }

    public List<PlacedBag> getPlacedBagsForOwner(UUID owner) {
        if (owner == null) {
            return Collections.emptyList();
        }
        ArrayList<PlacedBag> out = new ArrayList<PlacedBag>();
        for (PlacedBag pb : this.placedBags) {
            if (!owner.equals(pb.owner)) continue;
            out.add(pb);
        }
        return Collections.unmodifiableList(out);
    }

    public static ReturnLocationSavedData get(class_3218 level) {
        return (ReturnLocationSavedData)level.method_17983().method_17924(TYPE);
    }

    public static HavenPocketSavedData getHavenPocketSavedData(class_3218 level) {
        return (HavenPocketSavedData)level.method_17983().method_17924(HAVEN_POCKET_TYPE);
    }

    public void setReturnLocation(UUID player, String bagColor, class_1937 level, class_2338 pos, float yaw, float pitch) {
        String key;
        ReturnLocation existing;
        if (player == null || bagColor == null || level == null || pos == null) {
            return;
        }
        ReturnLocation rl = new ReturnLocation(level.method_27983().method_29177().toString(), pos, yaw, pitch);
        if (!rl.equals(existing = this.returnLocations.get(key = player.toString() + "_" + bagColor))) {
            this.returnLocations.put(key, rl);
            this.method_80();
        }
    }

    public void clearReturnLocation(UUID player, String bagColor) {
        if (player == null || bagColor == null) {
            return;
        }
        String key = player.toString() + "_" + bagColor;
        if (this.returnLocations.remove(key) != null) {
            this.method_80();
        }
    }

    public Optional<ReturnLocation> getReturnLocation(UUID player, String bagColor) {
        if (player == null || bagColor == null) {
            return Optional.empty();
        }
        String key = player.toString() + "_" + bagColor;
        return Optional.ofNullable(this.returnLocations.get(key));
    }

    public void dumpReturnLocations() {
    }

    public static void dumpAll(class_3218 level) {
    }

    private static ReturnLocationSavedData loadFromCompound(class_2487 tag) {
        ReturnLocationSavedData data = new ReturnLocationSavedData();
        tag.method_10554("ReturnLocations").ifPresent(listTag -> {
            for (int i = 0; i < listTag.size(); ++i) {
                listTag.method_10602(i).ifPresent(entry -> entry.method_10558("Player").ifPresent(playerStr -> entry.method_10558("Color").ifPresent(color -> entry.method_10558("Dim").ifPresent(dim -> {
                    Optional ox = entry.method_10550("X");
                    Optional oy = entry.method_10550("Y");
                    Optional oz = entry.method_10550("Z");
                    Optional oyaw = entry.method_10583("Yaw");
                    Optional opitch = entry.method_10583("Pitch");
                    if (ox.isPresent() && oy.isPresent() && oz.isPresent() && oyaw.isPresent() && opitch.isPresent()) {
                        try {
                            UUID playerId = UUID.fromString(playerStr);
                            class_2338 pos = new class_2338(((Integer)ox.get()).intValue(), ((Integer)oy.get()).intValue(), ((Integer)oz.get()).intValue());
                            String key = playerId.toString() + "_" + color;
                            data.returnLocations.put(key, new ReturnLocation((String)dim, pos, ((Float)oyaw.get()).floatValue(), ((Float)opitch.get()).floatValue()));
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                    }
                }))));
            }
        });
        tag.method_10554("PlacedBags").ifPresent(pbList -> {
            for (int i = 0; i < pbList.size(); ++i) {
                pbList.method_10602(i).ifPresent(entry -> entry.method_10558("Owner").ifPresent(ownerStr -> entry.method_10558("Color").ifPresent(color -> entry.method_10558("Dim").ifPresent(dim -> {
                    Optional ox = entry.method_10550("X");
                    Optional oy = entry.method_10550("Y");
                    Optional oz = entry.method_10550("Z");
                    if (ox.isPresent() && oy.isPresent() && oz.isPresent()) {
                        try {
                            UUID ownerId = UUID.fromString(ownerStr);
                            class_2338 pos = new class_2338(((Integer)ox.get()).intValue(), ((Integer)oy.get()).intValue(), ((Integer)oz.get()).intValue());
                            data.placedBags.add(new PlacedBag(ownerId, (String)color, (String)dim, pos));
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                    }
                }))));
            }
        });
        return data;
    }

    private class_2487 toCompound() {
        class_2487 root = new class_2487();
        class_2499 list = new class_2499();
        for (Map.Entry<String, ReturnLocation> e : this.returnLocations.entrySet()) {
            class_2487 entry = new class_2487();
            String key = e.getKey();
            int sep = key.indexOf(95);
            String playerStr = sep > 0 ? key.substring(0, sep) : key;
            String color = sep > 0 ? key.substring(sep + 1) : "";
            entry.method_10582("Player", playerStr);
            entry.method_10582("Color", color);
            entry.method_10582("Dim", e.getValue().dimension);
            entry.method_10569("X", e.getValue().pos.method_10263());
            entry.method_10569("Y", e.getValue().pos.method_10264());
            entry.method_10569("Z", e.getValue().pos.method_10260());
            entry.method_10548("Yaw", e.getValue().yaw);
            entry.method_10548("Pitch", e.getValue().pitch);
            list.add((Object)entry);
        }
        root.method_10566("ReturnLocations", (class_2520)list);
        class_2499 pbList = new class_2499();
        for (PlacedBag pb : this.placedBags) {
            class_2487 entry = new class_2487();
            entry.method_10582("Owner", pb.owner.toString());
            entry.method_10582("Color", pb.color == null ? "" : pb.color);
            entry.method_10582("Dim", pb.dimension == null ? "" : pb.dimension);
            entry.method_10569("X", pb.pos.method_10263());
            entry.method_10569("Y", pb.pos.method_10264());
            entry.method_10569("Z", pb.pos.method_10260());
            pbList.add((Object)entry);
        }
        root.method_10566("PlacedBags", (class_2520)pbList);
        return root;
    }

    public class_2487 save() {
        return this.toCompound();
    }

    public class_2487 save(class_2487 tag) {
        class_2487 src = this.toCompound();
        for (String k : src.method_10541()) {
            tag.method_10566(k, src.method_10580(k));
        }
        return tag;
    }

    private static class_10741<HavenPocketSavedData> createHavenPocketType() {
        Codec codec;
        try {
            Method loader = HavenPocketSavedData.class.getDeclaredMethod("load", class_2487.class);
            loader.setAccessible(true);
            codec = class_2487.field_25128.xmap(ctag -> {
                try {
                    Object res = loader.invoke(null, ctag);
                    if (res instanceof HavenPocketSavedData) {
                        HavenPocketSavedData hp = (HavenPocketSavedData)((Object)((Object)res));
                        return hp;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                return new HavenPocketSavedData();
            }, hpData -> hpData.save(new class_2487()));
        }
        catch (Throwable t) {
            codec = class_2487.field_25128.xmap(ctag -> new HavenPocketSavedData(), hpData -> hpData.save(new class_2487()));
        }
        Supplier<HavenPocketSavedData> supplier = HavenPocketSavedData::new;
        return new class_10741(HAVEN_POCKET_DATA_NAME, supplier, codec, class_4284.field_45078);
    }

    public static final class PlacedBag {
        public final UUID owner;
        public final String color;
        public final String dimension;
        public final class_2338 pos;

        public PlacedBag(UUID owner, String color, String dimension, class_2338 pos) {
            this.owner = owner;
            this.color = color;
            this.dimension = dimension;
            this.pos = pos;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PlacedBag)) {
                return false;
            }
            PlacedBag that = (PlacedBag)o;
            return Objects.equals(this.owner, that.owner) && Objects.equals(this.color, that.color) && Objects.equals(this.dimension, that.dimension) && Objects.equals(this.pos, that.pos);
        }

        public int hashCode() {
            return Objects.hash(this.owner, this.color, this.dimension, this.pos);
        }
    }

    public static final class ReturnLocation {
        public final String dimension;
        public final class_2338 pos;
        public final float yaw;
        public final float pitch;

        public ReturnLocation(String dimension, class_2338 pos, float yaw, float pitch) {
            this.dimension = Objects.requireNonNull(dimension);
            this.pos = Objects.requireNonNull(pos);
            this.yaw = yaw;
            this.pitch = pitch;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ReturnLocation)) {
                return false;
            }
            ReturnLocation that = (ReturnLocation)o;
            return this.dimension.equals(that.dimension) && this.pos.equals((Object)that.pos) && Float.compare(that.yaw, this.yaw) == 0 && Float.compare(that.pitch, this.pitch) == 0;
        }

        public int hashCode() {
            return Objects.hash(this.dimension, this.pos, Float.valueOf(this.yaw), Float.valueOf(this.pitch));
        }
    }
}

