/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.havenbag.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import java.util.UUID;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.mcreator.havenbag.ReturnLocationSavedData;
import net.mcreator.havenbag.event.MiscEvents;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;

public class WhereIsMyBagCommand {
    public static void register() {
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"whereismybag").executes(ctx -> {
            class_2168 source = (class_2168)ctx.getSource();
            try {
                class_3222 player = source.method_9207();
                WhereIsMyBagCommand.executeForPlayer(source, player);
            }
            catch (Throwable ex) {
                source.method_9226(() -> class_2561.method_43470((String)"This command must be run by a player or specify a player name."), false);
            }
            return 1;
        })).then(class_2170.method_9244((String)"target", (ArgumentType)StringArgumentType.word()).executes(ctx -> {
            class_2168 source = (class_2168)ctx.getSource();
            String targetName = StringArgumentType.getString((CommandContext)ctx, (String)"target");
            MinecraftServer server = source.method_9211();
            class_3222 found = null;
            for (class_3222 p : server.method_3760().method_14571()) {
                if (!p.method_5477().getString().equalsIgnoreCase(targetName)) continue;
                found = p;
                break;
            }
            if (found == null) {
                source.method_9226(() -> class_2561.method_43470((String)("Player not found or not online: " + targetName)), false);
                return 1;
            }
            WhereIsMyBagCommand.executeForPlayer(source, found);
            return 1;
        }))));
        MiscEvents.COMMAND_EXECUTE.register(results -> {
            try {
                class_3222 targetPlayer;
                String input = null;
                try {
                    input = results.getReader().getString();
                }
                catch (Throwable t) {
                    input = null;
                }
                if (input == null) {
                    return true;
                }
                if ((input = input.strip()).startsWith("/")) {
                    input = input.substring(1);
                }
                if (!input.toLowerCase(Locale.ROOT).startsWith("whereismybag")) {
                    return true;
                }
                class_2168 source = (class_2168)results.getContext().getSource();
                String[] parts = input.split("\\s+");
                if (parts.length >= 2) {
                    String targetName = parts[1];
                    class_3218 anyLevel = source.method_9225();
                    MinecraftServer server = anyLevel.method_8503();
                    class_3222 found = null;
                    for (class_3222 p : server.method_3760().method_14571()) {
                        if (!p.method_5477().getString().equalsIgnoreCase(targetName)) continue;
                        found = p;
                        break;
                    }
                    if (found == null) {
                        source.method_9226(() -> class_2561.method_43470((String)("Player not found or not online: " + targetName)), false);
                        return false;
                    }
                    targetPlayer = found;
                } else {
                    try {
                        targetPlayer = source.method_9207();
                    }
                    catch (Throwable ex) {
                        source.method_9226(() -> class_2561.method_43470((String)"This command must be run by a player or specify a player name."), false);
                        return false;
                    }
                }
                WhereIsMyBagCommand.executeForPlayer(source, targetPlayer);
                return false;
            }
            catch (Throwable t) {
                return true;
            }
        });
    }

    private static void executeForPlayer(class_2168 source, class_3222 targetPlayer) {
        block16: {
            try {
                UUID playerId = targetPlayer.method_5667();
                class_3218 anyLevelForServer = targetPlayer.method_51469();
                MinecraftServer server = anyLevelForServer.method_8503();
                ArrayList<ReturnLocationSavedData.PlacedBag> allPlaced = new ArrayList<ReturnLocationSavedData.PlacedBag>();
                HashSet<ReturnLocationSavedData.PlacedBag> dedupe = new HashSet<ReturnLocationSavedData.PlacedBag>();
                for (class_3218 lvl : server.method_3738()) {
                    ReturnLocationSavedData rld = ReturnLocationSavedData.get(lvl);
                    for (ReturnLocationSavedData.PlacedBag pb : rld.getPlacedBagsForOwner(playerId)) {
                        if (!dedupe.add(pb)) continue;
                        allPlaced.add(pb);
                    }
                }
                String header = class_124.field_1065.toString() + "--- /whereismybag placed bags for player: \"" + targetPlayer.method_5477().getString() + "\" ---" + String.valueOf(class_124.field_1070);
                source.method_9226(() -> class_2561.method_43470((String)header), false);
                if (allPlaced.isEmpty()) {
                    source.method_9226(() -> class_2561.method_43470((String)(String.valueOf(class_124.field_1063) + "(no placed bag blocks recorded)")), false);
                    break block16;
                }
                for (ReturnLocationSavedData.PlacedBag pb : allPlaced) {
                    String line;
                    String status;
                    class_2338 pos;
                    String dimStr;
                    String color;
                    block17: {
                        color = pb.color != null ? pb.color : "unknown";
                        dimStr = pb.dimension != null ? pb.dimension : "unknown";
                        pos = pb.pos;
                        status = "unknown";
                        try {
                            class_5321 dimKey = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)class_2960.method_60654((String)dimStr));
                            class_3218 targetLevel = targetPlayer.method_51469().method_8503().method_3847(dimKey);
                            if (targetLevel == null) {
                                status = "dimension_unloaded";
                                break block17;
                            }
                            class_2586 be = targetLevel.method_8321(pos);
                            if (be == null) {
                                status = "not_present";
                                try {
                                    ReturnLocationSavedData.get(targetLevel).removePlacedBag(pb.owner, pb.color, pos);
                                    continue;
                                }
                                catch (Throwable throwable) {
                                    break block17;
                                }
                            }
                            UUID beOwner = null;
                            try {
                                Method m = be.getClass().getMethod("getOwnerUUID", new Class[0]);
                                Object ret = m.invoke((Object)be, new Object[0]);
                                if (ret instanceof UUID) {
                                    beOwner = (UUID)ret;
                                }
                            }
                            catch (Throwable m) {
                                // empty catch block
                            }
                            status = beOwner != null && beOwner.equals(playerId) ? "present_owned" : (beOwner != null ? "present_owned_by_other" : "present_unknown_owner");
                        }
                        catch (Throwable t) {
                            status = "error";
                        }
                    }
                    String colorDisplay = WhereIsMyBagCommand.capitalize(color);
                    Object statusSuffix = "";
                    if (status != null && !status.equals("present_owned")) {
                        statusSuffix = " " + class_124.field_1063.toString() + "[" + status + "]" + String.valueOf(class_124.field_1070);
                    }
                    String dimPart = class_124.field_1064.toString() + dimStr + String.valueOf(class_124.field_1070);
                    String coordPart = class_124.field_1060.toString() + "[" + pos.method_10263() + ", " + pos.method_10264() + ", " + pos.method_10260() + "]" + String.valueOf(class_124.field_1070);
                    String outMsg = line = class_124.field_1080.toString() + "- " + WhereIsMyBagCommand.colorToFormatting(color).toString() + colorDisplay + " Bag" + String.valueOf(class_124.field_1070) + ": " + dimPart + " " + coordPart + (String)statusSuffix;
                    source.method_9226(() -> class_2561.method_43470((String)outMsg), false);
                    String sep = class_124.field_1063.toString() + "---------------------------------------------" + String.valueOf(class_124.field_1070);
                    source.method_9226(() -> class_2561.method_43470((String)sep), false);
                }
            }
            catch (Throwable t) {
                source.method_9226(() -> class_2561.method_43470((String)"Error while listing placed bags."), false);
            }
        }
    }

    private static class_124 colorToFormatting(String color) {
        if (color == null) {
            return class_124.field_1080;
        }
        switch (color.toLowerCase(Locale.ROOT)) {
            case "black": {
                return class_124.field_1063;
            }
            case "blue": {
                return class_124.field_1078;
            }
            case "brown": {
                return class_124.field_1065;
            }
            case "green": {
                return class_124.field_1060;
            }
            case "red": {
                return class_124.field_1061;
            }
            case "white": {
                return class_124.field_1068;
            }
            case "yellow": {
                return class_124.field_1054;
            }
        }
        return class_124.field_1080;
    }

    private static String capitalize(String s) {
        if (s == null || s.isEmpty()) {
            return s == null ? "" : s;
        }
        if (s.length() == 1) {
            return s.substring(0, 1).toUpperCase(Locale.ROOT);
        }
        return s.substring(0, 1).toUpperCase(Locale.ROOT) + s.substring(1).toLowerCase(Locale.ROOT);
    }
}

