/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.havenbag.item;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import io.netty.buffer.Unpooled;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import net.mcreator.havenbag.HavenBagGemPersistence;
import net.mcreator.havenbag.HavenPocketSavedData;
import net.mcreator.havenbag.ReturnLocationSavedData;
import net.mcreator.havenbag.block.entity.BlackBagBlockBlockEntity;
import net.mcreator.havenbag.init.HavenbagModBlocks;
import net.mcreator.havenbag.procedures.BagBlockEntityWalksOnTheBlockProcedure;
import net.mcreator.havenbag.world.inventory.BagGUIMenu;
import net.minecraft.class_10712;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1277;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1814;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_9279;
import net.minecraft.class_9334;

public class HavenBagBlackItem
extends class_1792 {
    private static final String BAG_COLOR = "BLACK";

    public HavenBagBlackItem(class_1792.class_1793 properties) {
        super(properties.method_7894(class_1814.field_8904).method_7889(1).method_24359());
    }

    private class_3908 createMenuProvider(final class_1799 stack, final class_1657 entity, final class_1268 hand) {
        return new class_3908(){

            public class_2561 method_5476() {
                return class_2561.method_43470((String)"Haven Bag");
            }

            public class_1703 createMenu(int id, class_1661 invIgnored, class_1657 player) {
                class_2540 packetBuffer = new class_2540(Unpooled.buffer());
                packetBuffer.method_10807(entity.method_24515());
                packetBuffer.method_52997(hand == class_1268.field_5808 ? 0 : 1);
                class_1277 inventory = new class_1277(this, 4){

                    public int method_5444() {
                        return 1;
                    }
                };
                class_9279 nbtComponent = (class_9279)stack.method_58694(class_9334.field_49628);
                if (nbtComponent != null) {
                    class_2487 rootTag = nbtComponent.method_57461();
                    rootTag.method_10554("inventory_haven_bag_black").ifPresent(itemsTag -> {
                        for (int i = 0; i < Math.min(itemsTag.size(), 4); ++i) {
                            class_2520 itemTag = itemsTag.method_10534(i);
                            if (!(itemTag instanceof class_2487)) continue;
                            class_2487 compound = (class_2487)itemTag;
                            int slot = i;
                            class_1799.field_24671.parse((DynamicOps)class_2509.field_11560, (Object)compound).result().ifPresent(itemStack -> inventory.method_5447(slot, itemStack));
                        }
                    });
                }
                inventory.method_5489(inv -> {
                    class_2499 itemsTag = new class_2499();
                    for (class_1799 itemStack : inventory) {
                        if (!itemStack.method_7960()) {
                            DataResult result = class_1799.field_24671.encodeStart((DynamicOps)class_2509.field_11560, (Object)itemStack);
                            result.result().ifPresent(arg_0 -> itemsTag.add(arg_0));
                            continue;
                        }
                        itemsTag.add((Object)new class_2487());
                    }
                    class_2487 rootTag = new class_2487();
                    rootTag.method_10566("inventory_haven_bag_black", (class_2520)itemsTag);
                    stack.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)rootTag));
                });
                return new BagGUIMenu(id, invIgnored, (class_1263)inventory, packetBuffer);
            }
        };
    }

    public void method_67187(class_1799 itemstack, class_1792.class_9635 context, class_10712 tooltipDisplay, Consumer<class_2561> componentConsumer, class_1836 flag) {
        super.method_67187(itemstack, context, tooltipDisplay, componentConsumer, flag);
        componentConsumer.accept((class_2561)class_2561.method_43471((String)"item.havenbag.haven_bag_black.description_0"));
        componentConsumer.accept((class_2561)class_2561.method_43471((String)"item.havenbag.haven_bag_black.description_1"));
        componentConsumer.accept((class_2561)class_2561.method_43471((String)"item.havenbag.haven_bag_black.description_2"));
        class_9279 customData = (class_9279)itemstack.method_58695(class_9334.field_49628, (Object)class_9279.field_49302);
        class_2487 tag = customData.method_57461();
        int gemCount = 0;
        ArrayList appliedGems = new ArrayList();
        if (tag.method_10545("ConsumedGems")) {
            tag.method_10558("ConsumedGems").ifPresent(consumedGemsStr -> {
                if (!consumedGemsStr.isEmpty()) {
                    String[] gems;
                    for (String gem : gems = consumedGemsStr.split(",")) {
                        appliedGems.add(gem.trim());
                    }
                }
            });
        }
        gemCount = appliedGems.size();
        componentConsumer.accept((class_2561)class_2561.method_43470((String)("\u00a75\u2726 Applied Gems: \u00a7e" + gemCount + "\u00a77/\u00a7e4")));
        Iterator iterator = appliedGems.iterator();
        while (iterator.hasNext()) {
            String gem;
            String displayName = switch (gem = (String)iterator.next()) {
                case "garden" -> "\u00a72Garden";
                case "deco" -> "\u00a7bDeco";
                case "merchant" -> "\u00a76Merchant";
                case "crafty" -> "\u00a7aCrafty";
                default -> gem;
            };
            componentConsumer.accept((class_2561)class_2561.method_43470((String)("  \u00a78\u2022 " + displayName)));
        }
        UUID ownerUUID = HavenBagBlackItem.getOwnerUUID(itemstack);
        if (ownerUUID != null) {
            String ownerName = HavenBagBlackItem.getOwnerName(itemstack);
            if (ownerName != null && !ownerName.isEmpty()) {
                componentConsumer.accept((class_2561)class_2561.method_43470((String)("\u00a76Owner: \u00a7e" + ownerName)));
            } else {
                String ownerDisplay = ownerUUID.toString().substring(0, 8) + "...";
                componentConsumer.accept((class_2561)class_2561.method_43470((String)("\u00a76Owner: \u00a7e" + ownerDisplay)));
            }
        }
    }

    public class_1269 method_7836(class_1937 world, class_1657 entity, class_1268 hand) {
        class_1269 ar = super.method_7836(world, entity, hand);
        if (entity instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)entity;
            serverPlayer.method_17355(this.createMenuProvider(serverPlayer.method_5998(hand), entity, hand));
        }
        return ar;
    }

    public class_1269 method_7884(class_1838 context) {
        class_1937 world = context.method_8045();
        class_1657 player = context.method_8036();
        class_1799 itemstack = context.method_8041();
        class_2338 clickedPos = context.method_8037();
        if (player != null) {
            class_2338 placePos;
            UUID pocketUUID;
            class_1937 class_19372;
            if (world.method_8608()) {
                return class_1269.field_5812;
            }
            if (!world.method_8608() && (class_19372 = player.method_73183()) instanceof class_3218) {
                class_3218 serverLevel = (class_3218)class_19372;
                try {
                    String reason = this.getPlacementBlockReason(player, serverLevel, itemstack);
                    if (reason != null) {
                        player.method_7353((class_2561)class_2561.method_43470((String)reason), true);
                        return class_1269.field_5814;
                    }
                }
                catch (Throwable reason) {
                    // empty catch block
                }
            }
            if ((pocketUUID = HavenBagBlackItem.getPocketUUID(itemstack)) == null) {
                UUID ownerUUID = HavenBagBlackItem.getOwnerUUID(itemstack);
                if (ownerUUID != null) {
                    pocketUUID = this.generatePocketUUID(ownerUUID, BAG_COLOR);
                    this.setPocketUUID(itemstack, pocketUUID);
                } else {
                    pocketUUID = this.generatePocketUUID(player.method_5667(), BAG_COLOR);
                    this.setPocketUUID(itemstack, pocketUUID);
                }
            }
            if (world.method_8320(placePos = clickedPos.method_10093(context.method_8038())).method_26215()) {
                class_1750 placeContext = new class_1750(context);
                class_2680 blockState = HavenbagModBlocks.BLACK_BAG_BLOCK.method_9605(placeContext);
                if (blockState == null) {
                    return class_1269.field_5814;
                }
                world.method_8652(placePos, blockState, 3);
                class_2586 class_25862 = world.method_8321(placePos);
                if (class_25862 instanceof BlackBagBlockBlockEntity) {
                    Object parentPocket;
                    class_1799 stringStack;
                    class_2499 gemList;
                    BlackBagBlockBlockEntity bagEntity = (BlackBagBlockBlockEntity)class_25862;
                    bagEntity.setPocketUUID(pocketUUID);
                    UUID itemOwnerUUID = HavenBagBlackItem.getOwnerUUID(itemstack);
                    if (itemOwnerUUID != null) {
                        bagEntity.setOwnerUUID(itemOwnerUUID);
                    } else {
                        bagEntity.setOwnerUUID(player.method_5667());
                    }
                    class_9279 customData = (class_9279)itemstack.method_58695(class_9334.field_49628, (Object)class_9279.field_49302);
                    class_2487 tag = customData.method_57461();
                    if (tag.method_10545("StoredGems") && (gemList = (class_2499)tag.method_10580("StoredGems")) != null && !gemList.isEmpty()) {
                        bagEntity.restoreGemsFromItem(gemList);
                    }
                    if (tag.method_10545("LeadCount")) {
                        int leadCount = tag.method_10550("LeadCount").orElse(0);
                        if (leadCount > 0) {
                            class_1799 leadStack = new class_1799((class_1935)class_1802.field_8719, leadCount);
                            bagEntity.method_5447(4, leadStack);
                        }
                    } else {
                        class_1799 leadStack = new class_1799((class_1935)class_1802.field_8719, 1);
                        bagEntity.method_5447(4, leadStack);
                        stringStack = new class_1799((class_1935)class_1802.field_8276, 1);
                        bagEntity.method_5447(5, stringStack);
                    }
                    HavenBagGemPersistence.restoreGemsToBagEntity(player, "black", (Object)bagEntity);
                    try {
                        class_3218 havenLevel;
                        stringStack = player.method_73183();
                        if (stringStack instanceof class_3218 && "havenbag:haven_dimension".contentEquals((havenLevel = (class_3218)stringStack).method_27983().method_29177().toString())) {
                            parentPocket = BagBlockEntityWalksOnTheBlockProcedure.getPocketUuidAtPosition(havenLevel, player.method_24515());
                            HavenPocketSavedData pocketData = HavenPocketSavedData.get(havenLevel);
                            UUID childPocket = pocketUUID;
                            UUID ownerToRecord = bagEntity.getOwnerUUID() != null ? bagEntity.getOwnerUUID() : player.method_5667();
                            pocketData.registerPocketOwner(childPocket, ownerToRecord);
                            if (parentPocket != null && !((UUID)parentPocket).equals(childPocket)) {
                                pocketData.registerPocketParentIfAbsent(childPocket, (UUID)parentPocket);
                            }
                        }
                    }
                    catch (Throwable havenLevel) {
                        // empty catch block
                    }
                    try {
                        parentPocket = player.method_73183();
                        if (parentPocket instanceof class_3218) {
                            class_3218 serverLevelLocal = (class_3218)parentPocket;
                            UUID ownerToRecord = bagEntity.getOwnerUUID() != null ? bagEntity.getOwnerUUID() : player.method_5667();
                            String dimId = serverLevelLocal.method_27983().method_29177().toString();
                            ReturnLocationSavedData.get(serverLevelLocal).registerPlacedBag(ownerToRecord, "black", dimId, placePos);
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (!player.method_68878()) {
                    itemstack.method_7934(1);
                }
                return class_1269.field_5812;
            }
        }
        return class_1269.field_5814;
    }

    private String getPlacementBlockReason(class_1657 player, class_3218 serverLevel, class_1799 itemstack) {
        try {
            class_2960 currDim = player.method_73183().method_27983().method_29177();
            if (currDim == null || !"havenbag:haven_dimension".equals(currDim.toString())) {
                return null;
            }
            class_2338 playerPos = player.method_24515();
            UUID pocketUuid = BagBlockEntityWalksOnTheBlockProcedure.getPocketUuidAtPosition(serverLevel, playerPos);
            if (pocketUuid == null) {
                return null;
            }
            try {
                UUID childPocket = HavenBagBlackItem.getPocketUUID(itemstack);
                if (childPocket != null) {
                    if (childPocket.equals(pocketUuid)) {
                        return "\u00a7cYou cannot place this bag inside its own pocket.";
                    }
                    boolean uuidInAncestry = BagBlockEntityWalksOnTheBlockProcedure.isUuidInAncestry(pocketUuid, childPocket, 7, serverLevel);
                    if (uuidInAncestry) {
                        return "\u00a7cPlacement blocked: this bag would recreate an ancestor pocket.";
                    }
                }
            }
            catch (Throwable childPocket) {
                // empty catch block
            }
            UUID playerOwner = player.method_5667();
            boolean colorInAncestry = BagBlockEntityWalksOnTheBlockProcedure.isColorInAncestry(pocketUuid, BAG_COLOR, 7, serverLevel, playerOwner);
            if (colorInAncestry) {
                return "\u00a7cPlacement blocked: your pocket ancestry already contains a " + BAG_COLOR.toLowerCase() + " bag.";
            }
            int depth = BagBlockEntityWalksOnTheBlockProcedure.getAncestryDepth(pocketUuid, serverLevel, playerOwner, 7);
            if (depth >= 7) {
                return "\u00a7cPlacement blocked: your pocket ancestry depth limit has been reached.";
            }
            return null;
        }
        catch (Throwable t) {
            return null;
        }
    }

    public void method_54465(class_1799 stack, class_1657 player) {
        super.method_54465(stack, player);
        if (!player.method_73183().method_8608()) {
            class_3222 serverPlayer;
            String unlockedGems;
            UUID pocketUUID = this.generatePocketUUID(player.method_5667(), BAG_COLOR);
            this.setPocketUUID(stack, pocketUUID);
            if (HavenBagBlackItem.getOwnerUUID(stack) == null) {
                this.setOwnerUUID(stack, player.method_5667());
                this.setOwnerName(stack, player.method_5477().getString());
            }
            if (player instanceof class_3222 && !(unlockedGems = HavenBagGemPersistence.getUnlockedGemsString((class_1657)(serverPlayer = (class_3222)player), "black")).isEmpty()) {
                class_2487 tag = ((class_9279)stack.method_58695(class_9334.field_49628, (Object)class_9279.field_49302)).method_57461();
                tag.method_10582("ConsumedGems", unlockedGems);
                stack.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)tag));
            }
        }
    }

    public void method_7888(class_1799 stack, class_3218 world, class_1297 entity, class_1304 slot) {
        super.method_7888(stack, world, entity, slot);
        if (entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            if (HavenBagBlackItem.getOwnerUUID(stack) == null) {
                class_3222 serverPlayer;
                String unlockedGems;
                UUID pocketUUID = this.generatePocketUUID(player.method_5667(), BAG_COLOR);
                this.setPocketUUID(stack, pocketUUID);
                this.setOwnerUUID(stack, player.method_5667());
                this.setOwnerName(stack, player.method_5477().getString());
                if (player instanceof class_3222 && !(unlockedGems = HavenBagGemPersistence.getUnlockedGemsString((class_1657)(serverPlayer = (class_3222)player), "black")).isEmpty()) {
                    class_2487 tag = ((class_9279)stack.method_58695(class_9334.field_49628, (Object)class_9279.field_49302)).method_57461();
                    tag.method_10582("ConsumedGems", unlockedGems);
                    stack.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)tag));
                }
            }
        }
    }

    private UUID generatePocketUUID(UUID playerUUID, String bagColor) {
        try {
            String input = playerUUID.toString() + ":" + bagColor;
            MessageDigest digest = MessageDigest.getInstance("MD5");
            byte[] hash = digest.digest(input.getBytes(StandardCharsets.UTF_8));
            ByteBuffer buffer = ByteBuffer.wrap(hash);
            long mostSigBits = buffer.getLong();
            long leastSigBits = buffer.getLong();
            return new UUID(mostSigBits, leastSigBits);
        }
        catch (Exception e) {
            e.printStackTrace();
            return UUID.randomUUID();
        }
    }

    private void setPocketUUID(class_1799 stack, UUID pocketUUID) {
        class_2487 tag = ((class_9279)stack.method_58695(class_9334.field_49628, (Object)class_9279.field_49302)).method_57461();
        tag.method_10544("PocketUUIDMost", pocketUUID.getMostSignificantBits());
        tag.method_10544("PocketUUIDLeast", pocketUUID.getLeastSignificantBits());
        stack.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)tag));
    }

    public static UUID getPocketUUID(class_1799 stack) {
        class_9279 customData = (class_9279)stack.method_58695(class_9334.field_49628, (Object)class_9279.field_49302);
        class_2487 tag = customData.method_57461();
        if (tag.method_10545("PocketUUIDMost") && tag.method_10545("PocketUUIDLeast")) {
            Optional msbOpt = tag.method_10537("PocketUUIDMost");
            Optional lsbOpt = tag.method_10537("PocketUUIDLeast");
            if (msbOpt.isPresent() && lsbOpt.isPresent()) {
                return new UUID((Long)msbOpt.get(), (Long)lsbOpt.get());
            }
        }
        return null;
    }

    private void setOwnerUUID(class_1799 stack, UUID ownerUUID) {
        class_2487 tag = ((class_9279)stack.method_58695(class_9334.field_49628, (Object)class_9279.field_49302)).method_57461();
        tag.method_10544("OwnerUUIDMost", ownerUUID.getMostSignificantBits());
        tag.method_10544("OwnerUUIDLeast", ownerUUID.getLeastSignificantBits());
        stack.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)tag));
    }

    public static UUID getOwnerUUID(class_1799 stack) {
        class_9279 customData = (class_9279)stack.method_58695(class_9334.field_49628, (Object)class_9279.field_49302);
        class_2487 tag = customData.method_57461();
        if (tag.method_10545("OwnerUUIDMost") && tag.method_10545("OwnerUUIDLeast")) {
            Optional msbOpt = tag.method_10537("OwnerUUIDMost");
            Optional lsbOpt = tag.method_10537("OwnerUUIDLeast");
            if (msbOpt.isPresent() && lsbOpt.isPresent()) {
                return new UUID((Long)msbOpt.get(), (Long)lsbOpt.get());
            }
        }
        return null;
    }

    private void setOwnerName(class_1799 stack, String ownerName) {
        class_2487 tag = ((class_9279)stack.method_58695(class_9334.field_49628, (Object)class_9279.field_49302)).method_57461();
        tag.method_10582("OwnerName", ownerName);
        stack.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)tag));
    }

    public static String getOwnerName(class_1799 stack) {
        class_9279 customData = (class_9279)stack.method_58695(class_9334.field_49628, (Object)class_9279.field_49302);
        class_2487 tag = customData.method_57461();
        if (tag.method_10545("OwnerName")) {
            return tag.method_10558("OwnerName").orElse("Unknown");
        }
        return null;
    }
}

