/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.havenbag.procedures;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.mcreator.havenbag.HavenPocketSavedData;
import net.mcreator.havenbag.ReturnLocationSavedData;
import net.mcreator.havenbag.block.entity.BlackBagBlockBlockEntity;
import net.mcreator.havenbag.block.entity.BlueBagBlockBlockEntity;
import net.mcreator.havenbag.block.entity.BrownBagBlockBlockEntity;
import net.mcreator.havenbag.block.entity.GreenBagBlockBlockEntity;
import net.mcreator.havenbag.block.entity.RedBagBlockBlockEntity;
import net.mcreator.havenbag.block.entity.WhiteBagBlockBlockEntity;
import net.mcreator.havenbag.block.entity.YellowBagBlockBlockEntity;
import net.minecraft.class_1263;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2696;
import net.minecraft.class_2783;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_5321;
import net.minecraft.class_5425;
import net.minecraft.class_7924;

public class BagBlockEntityWalksOnTheBlockProcedure {
    public static boolean eventResult = true;
    private static final Map<String, double[]> bagReturnPositions = new HashMap<String, double[]>();
    private static final Map<String, String> bagReturnDimensions = new HashMap<String, String>();
    private static final HashSet<UUID> structuresPlaced = new HashSet();
    private static final Map<UUID, class_2338> pocketPositions = new HashMap<UUID, class_2338>();
    private static final HashSet<String> expansionsPlaced = new HashSet();
    private static final Map<UUID, String> pocketColorMap = new HashMap<UUID, String>();
    private static final Map<UUID, Long> pendingTeleports = new HashMap<UUID, Long>();
    private static final long ENTRY_DELAY_MS = 1000L;

    public static void execute(class_1936 world, class_1297 entity, class_2338 pos) {
        if (entity == null || !(world instanceof class_3218)) {
            return;
        }
        class_3218 _serverLevel = (class_3218)world;
        class_2586 be = _serverLevel.method_8321(pos);
        UUID pocketUUID = null;
        UUID ownerUUID = null;
        boolean allowsPlayers = false;
        boolean allowsEntities = false;
        String bagColor = null;
        if (be instanceof BlackBagBlockBlockEntity) {
            BlackBagBlockBlockEntity blackBag = (BlackBagBlockBlockEntity)be;
            pocketUUID = blackBag.getPocketUUID();
            ownerUUID = blackBag.getOwnerUUID();
            allowsPlayers = blackBag.allowsPlayers();
            allowsEntities = blackBag.allowsEntities();
            bagColor = "black";
        } else if (be instanceof BlueBagBlockBlockEntity) {
            BlueBagBlockBlockEntity blueBag = (BlueBagBlockBlockEntity)be;
            pocketUUID = blueBag.getPocketUUID();
            ownerUUID = blueBag.getOwnerUUID();
            allowsPlayers = blueBag.allowsPlayers();
            allowsEntities = blueBag.allowsEntities();
            bagColor = "blue";
        } else if (be instanceof RedBagBlockBlockEntity) {
            RedBagBlockBlockEntity redBag = (RedBagBlockBlockEntity)be;
            pocketUUID = redBag.getPocketUUID();
            ownerUUID = redBag.getOwnerUUID();
            allowsPlayers = redBag.allowsPlayers();
            allowsEntities = redBag.allowsEntities();
            bagColor = "red";
        } else if (be instanceof GreenBagBlockBlockEntity) {
            GreenBagBlockBlockEntity greenBag = (GreenBagBlockBlockEntity)be;
            pocketUUID = greenBag.getPocketUUID();
            ownerUUID = greenBag.getOwnerUUID();
            allowsPlayers = greenBag.allowsPlayers();
            allowsEntities = greenBag.allowsEntities();
            bagColor = "green";
        } else if (be instanceof WhiteBagBlockBlockEntity) {
            WhiteBagBlockBlockEntity whiteBag = (WhiteBagBlockBlockEntity)be;
            pocketUUID = whiteBag.getPocketUUID();
            ownerUUID = whiteBag.getOwnerUUID();
            allowsPlayers = whiteBag.allowsPlayers();
            allowsEntities = whiteBag.allowsEntities();
            bagColor = "white";
        } else if (be instanceof YellowBagBlockBlockEntity) {
            YellowBagBlockBlockEntity yellowBag = (YellowBagBlockBlockEntity)be;
            pocketUUID = yellowBag.getPocketUUID();
            ownerUUID = yellowBag.getOwnerUUID();
            allowsPlayers = yellowBag.allowsPlayers();
            allowsEntities = yellowBag.allowsEntities();
            bagColor = "yellow";
        } else if (be instanceof BrownBagBlockBlockEntity) {
            BrownBagBlockBlockEntity brownBag = (BrownBagBlockBlockEntity)be;
            pocketUUID = brownBag.getPocketUUID();
            ownerUUID = brownBag.getOwnerUUID();
            allowsPlayers = brownBag.allowsPlayers();
            allowsEntities = brownBag.allowsEntities();
            bagColor = "brown";
        } else {
            return;
        }
        if (entity instanceof class_3222) {
            boolean isOwner;
            class_3222 _player = (class_3222)entity;
            UUID playerUUID = _player.method_5667();
            boolean bl = isOwner = ownerUUID != null && ownerUUID.equals(playerUUID);
            if (!isOwner && !allowsPlayers) {
                _player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7c\ud83d\udd12 This Haven Bag is locked! The owner must remove the lead to grant access."), true);
                return;
            }
            long currentTime = System.currentTimeMillis();
            if (pendingTeleports.containsKey(playerUUID)) {
                long cooldownMs;
                long pendingTime = pendingTeleports.get(playerUUID);
                long l = cooldownMs = currentTime - pendingTime < 1000L ? 1000L : 5000L;
                if (currentTime - pendingTime < cooldownMs) {
                    return;
                }
            }
            pendingTeleports.put(playerUUID, currentTime);
            String positionKey = playerUUID.toString() + "_" + bagColor;
            String currentDim = _player.method_51469().method_27983().method_29177().toString();
            bagReturnPositions.put(positionKey, new double[]{(double)pos.method_10263() + 0.5, pos.method_10264() + 1, (double)pos.method_10260() + 0.5, entity.method_36454(), entity.method_36455()});
            bagReturnDimensions.put(positionKey, currentDim);
            try {
                class_3218 storageLevel = _serverLevel.method_8503().method_3847(class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)class_2960.method_60654((String)"minecraft:overworld")));
                if (storageLevel != null) {
                    ReturnLocationSavedData.get(storageLevel).setReturnLocation(playerUUID, bagColor, (class_1937)_player.method_51469(), pos, entity.method_36454(), entity.method_36455());
                } else {
                    ReturnLocationSavedData.get(_serverLevel).setReturnLocation(playerUUID, bagColor, (class_1937)_player.method_51469(), pos, entity.method_36454(), entity.method_36455());
                }
            }
            catch (Throwable t) {
                System.out.println("[DEBUG ERROR] Could not persist return location to overworld: " + String.valueOf(t));
                ReturnLocationSavedData.get(_serverLevel).setReturnLocation(playerUUID, bagColor, (class_1937)_player.method_51469(), pos, entity.method_36454(), entity.method_36455());
            }
            System.out.println("[DEBUG] Saved return position for player " + _player.method_5477().getString() + " for " + bagColor + " bag at " + String.valueOf(pos) + " in dimension " + currentDim);
        } else if (!allowsEntities) {
            return;
        }
        int roomX = (int)((pocketUUID.getMostSignificantBits() & Integer.MAX_VALUE) % 1000000L);
        int roomZ = (int)((pocketUUID.getLeastSignificantBits() & Integer.MAX_VALUE) % 1000000L);
        int roomY = 100;
        class_5321 havenDimKey = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)class_2960.method_60654((String)"havenbag:haven_dimension"));
        class_3218 havenLevel = _serverLevel.method_8503().method_3847(havenDimKey);
        if (havenLevel != null) {
            HavenPocketSavedData pocketData = HavenPocketSavedData.get(havenLevel);
            pocketData.registerPocketColor(pocketUUID, bagColor);
            class_2338 structurePos = new class_2338(roomX, roomY, roomZ);
            if (!pocketData.isStructurePlaced(pocketUUID)) {
                String structureName = bagColor + "haven";
                class_3499 template = havenLevel.method_14183().method_15091(class_2960.method_60654((String)("havenbag:" + structureName)));
                if (template != null) {
                    try {
                        System.out.println("[DEBUG TEMPLATE] Loaded template '" + structureName + "' size=" + String.valueOf(template.method_15160()));
                    }
                    catch (Throwable t) {
                        System.out.println("[DEBUG TEMPLATE] Exception getting template size: " + String.valueOf(t));
                    }
                    boolean placed = false;
                    try {
                        placed = template.method_15172((class_5425)havenLevel, structurePos, structurePos, new class_3492().method_15123(class_2470.field_11467).method_15125(class_2415.field_11302).method_15133(false), havenLevel.field_9229, 3);
                    }
                    catch (Throwable t) {
                        System.out.println("[DEBUG ERROR] Exception during template.placeInWorld: " + String.valueOf(t));
                    }
                    int foundNonAir = 0;
                    int scanSize = 15;
                    int maxReports = 10;
                    int reports = 0;
                    for (int dx = 0; dx < scanSize; ++dx) {
                        for (int dy = 0; dy < scanSize; ++dy) {
                            for (int dz = 0; dz < scanSize; ++dz) {
                                class_2338 check = structurePos.method_10069(dx, dy, dz);
                                try {
                                    if (havenLevel.method_8320(check).method_26215()) continue;
                                    ++foundNonAir;
                                    if (reports >= maxReports) continue;
                                    System.out.println("[DEBUG CHECK] Non-air at " + String.valueOf(check) + " -> " + String.valueOf(havenLevel.method_8320(check).method_26204()));
                                    ++reports;
                                    continue;
                                }
                                catch (Throwable t) {
                                    System.out.println("[DEBUG CHECK] Exception while checking " + String.valueOf(check) + ": " + String.valueOf(t));
                                }
                            }
                        }
                    }
                    if (foundNonAir == 0) {
                        System.out.println("[DEBUG CHECK] No solid blocks found in scanned area after placement (foundNonAir=0). Placing fallback stone platform.");
                        int cx = structurePos.method_10263() + 7;
                        int cy = structurePos.method_10264();
                        int cz = structurePos.method_10260() + 7;
                        for (int px = -1; px <= 1; ++px) {
                            for (int pz = -1; pz <= 1; ++pz) {
                                havenLevel.method_8501(new class_2338(cx + px, cy, cz + pz), class_2246.field_10340.method_9564());
                            }
                        }
                    } else {
                        System.out.println("[DEBUG CHECK] Found non-air block count after placement: " + foundNonAir);
                    }
                    if (placed && foundNonAir > 0) {
                        pocketData.markStructurePlaced(pocketUUID);
                        System.out.println("[DEBUG PLACE] Marked pocket " + String.valueOf(pocketUUID) + " as placed.");
                    } else {
                        System.out.println("[DEBUG PLACE] Structure place reported=" + placed + ", nonAirCount=" + foundNonAir + " - not marking as placed.");
                    }
                }
            }
            if (be instanceof class_1263) {
                class_1263 container = (class_1263)be;
                BagBlockEntityWalksOnTheBlockProcedure.placeGemExpansions(havenLevel, structurePos, bagColor, container, pocketUUID, pocketData);
            }
            if (entity instanceof class_3222) {
                class_3222 _player = (class_3222)entity;
                double playerX = _player.method_23317();
                double playerY = _player.method_23318();
                double playerZ = _player.method_23321();
                double bagX = (double)pos.method_10263() + 0.3;
                double bagZ = (double)pos.method_10260() + 0.3;
                double horizontalDistance = Math.sqrt(Math.pow(playerX - bagX, 2.0) + Math.pow(playerZ - bagZ, 2.0));
                System.out.println("[DEBUG TELEPORT] Player: (" + playerX + ", " + playerY + ", " + playerZ + ")");
                System.out.println("[DEBUG TELEPORT] Bag center: (" + bagX + ", " + (pos.method_10264() + 1) + ", " + bagZ + ")");
                System.out.println("[DEBUG TELEPORT] Horizontal distance: " + horizontalDistance);
                if (horizontalDistance <= 1.0) {
                    _player.method_7353((class_2561)class_2561.method_43470((String)"\u00a76\u2728 Entering Haven Dimension..."), true);
                    _player.method_48105(havenLevel, (double)roomX + 7.5, (double)(roomY + 7), (double)roomZ + 7.5, Set.of(), entity.method_36454(), entity.method_36455(), true);
                    _player.field_13987.method_14364((class_2596)new class_2696(_player.method_31549()));
                    for (class_1293 _effectinstance : _player.method_6026()) {
                        _player.field_13987.method_14364((class_2596)new class_2783(_player.method_5628(), _effectinstance, false));
                    }
                    System.out.println("[DEBUG] Teleported player to haven dimension");
                } else {
                    _player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7cToo far from bag center - move closer to teleport."), true);
                    System.out.println("[DEBUG] Player too far from bag center for teleport");
                }
            } else {
                entity.method_48105(havenLevel, (double)roomX + 7.5, (double)(roomY + 7), (double)roomZ + 7.5, Set.of(), entity.method_36454(), entity.method_36455(), true);
                System.out.println("[DEBUG] Teleported " + entity.method_5864().toString() + " to haven dimension");
            }
        }
    }

    public static double[] getBagReturnPosition(UUID playerId, String bagColor) {
        String key = playerId.toString() + "_" + bagColor;
        return bagReturnPositions.get(key);
    }

    public static String getBagReturnDimension(UUID playerId, String bagColor) {
        String key = playerId.toString() + "_" + bagColor;
        return bagReturnDimensions.get(key);
    }

    public static void clearBagReturnData(UUID playerId, String bagColor) {
        String key = playerId.toString() + "_" + bagColor;
        bagReturnPositions.remove(key);
        bagReturnDimensions.remove(key);
        System.out.println("[DEBUG] Cleared return data for player " + String.valueOf(playerId) + " and " + bagColor + " bag");
    }

    public static String getBagColorAtPosition(class_3218 havenLevel, class_2338 playerPos) {
        UUID pocket = BagBlockEntityWalksOnTheBlockProcedure.getPocketUuidAtPosition(havenLevel, playerPos);
        if (pocket == null) {
            return null;
        }
        HavenPocketSavedData pocketData = HavenPocketSavedData.get(havenLevel);
        return pocketData.getPocketColor(pocket);
    }

    public static UUID getPocketUuidAtPosition(class_3218 havenLevel, class_2338 playerPos) {
        HavenPocketSavedData pocketData = HavenPocketSavedData.get(havenLevel);
        double bestDistSq = Double.MAX_VALUE;
        UUID bestPocket = null;
        for (UUID pocketUUID : pocketData.getAllPocketIds()) {
            double dz;
            double dy;
            double dx;
            double distSq;
            int roomX = (int)((pocketUUID.getMostSignificantBits() & Integer.MAX_VALUE) % 1000000L);
            int roomZ = (int)((pocketUUID.getLeastSignificantBits() & Integer.MAX_VALUE) % 1000000L);
            int roomY = 100;
            if (Math.abs(playerPos.method_10263() - roomX) > 50 || Math.abs(playerPos.method_10260() - roomZ) > 50 || Math.abs(playerPos.method_10264() - roomY) > 20 || !((distSq = (dx = (double)(playerPos.method_10263() - roomX)) * dx + (dy = (double)(playerPos.method_10264() - roomY)) * dy + (dz = (double)(playerPos.method_10260() - roomZ)) * dz) < bestDistSq)) continue;
            bestDistSq = distSq;
            bestPocket = pocketUUID;
        }
        return bestPocket;
    }

    public static boolean isColorInAncestry(UUID startPocket, String color, int depthLimit, class_3218 havenLevel, UUID ownerFilter) {
        if (startPocket == null || color == null || havenLevel == null) {
            return false;
        }
        HavenPocketSavedData pocketData = HavenPocketSavedData.get(havenLevel);
        HashSet<UUID> visited = new HashSet<UUID>();
        UUID current = startPocket;
        for (int depth = 0; current != null && depth < depthLimit; ++depth) {
            if (!visited.add(current)) {
                return true;
            }
            String pocketColor = pocketData.getPocketColor(current);
            UUID pocketOwner = pocketData.getPocketOwner(current);
            if (pocketColor != null && pocketColor.equalsIgnoreCase(color) && (ownerFilter == null || pocketOwner != null && pocketOwner.equals(ownerFilter))) {
                return true;
            }
            current = pocketData.getPocketParent(current);
        }
        return false;
    }

    public static boolean isUuidInAncestry(UUID startPocket, UUID targetPocket, int depthLimit, class_3218 havenLevel) {
        if (startPocket == null || targetPocket == null || havenLevel == null) {
            return false;
        }
        HavenPocketSavedData pocketData = HavenPocketSavedData.get(havenLevel);
        HashSet<UUID> visited = new HashSet<UUID>();
        UUID current = startPocket;
        for (int depth = 0; current != null && depth < depthLimit; ++depth) {
            if (!visited.add(current)) {
                return true;
            }
            if (current.equals(targetPocket)) {
                return true;
            }
            current = pocketData.getPocketParent(current);
        }
        return false;
    }

    public static int getAncestryDepth(UUID startPocket, class_3218 havenLevel, UUID ownerFilter, int maxLimit) {
        int depth;
        if (startPocket == null || havenLevel == null) {
            return 0;
        }
        HavenPocketSavedData pocketData = HavenPocketSavedData.get(havenLevel);
        HashSet<UUID> visited = new HashSet<UUID>();
        UUID current = startPocket;
        for (depth = 0; current != null && depth < maxLimit; ++depth) {
            UUID parentOwner;
            if (!visited.add(current)) {
                return depth;
            }
            UUID parent = pocketData.getPocketParent(current);
            if (parent == null || ownerFilter != null && ((parentOwner = pocketData.getPocketOwner(parent)) == null || !parentOwner.equals(ownerFilter))) break;
            current = parent;
        }
        return depth;
    }

    public static void ensurePocketDataLoaded(class_3218 havenLevel) {
        try {
            HavenPocketSavedData pocketData;
            block15: {
                if (!(pocketPositions.isEmpty() || structuresPlaced.isEmpty() || pocketColorMap.isEmpty())) {
                    return;
                }
                class_3218 storageLevel = null;
                try {
                    storageLevel = havenLevel.method_8503().method_3847(class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)class_2960.method_60654((String)"minecraft:overworld")));
                }
                catch (Throwable t) {
                    System.out.println("[DEBUG ENSURE] Exception while locating overworld storageLevel: " + String.valueOf(t));
                }
                if (storageLevel == null) {
                    System.out.println("[DEBUG ENSURE] storageLevel (overworld) == null - cannot load persisted pocket data");
                    return;
                }
                try {
                    System.out.println("[DEBUG ENSURE] storageLevel found: " + String.valueOf(storageLevel.method_27983().method_29177()));
                }
                catch (Throwable t) {
                    System.out.println("[DEBUG ENSURE] storageLevel found (toString failed): " + String.valueOf(t));
                }
                pocketData = null;
                try {
                    pocketData = HavenPocketSavedData.get(storageLevel);
                }
                catch (Throwable t) {
                    System.out.println("[DEBUG ENSURE] Exception getting HavenPocketSavedData: " + String.valueOf(t));
                }
                if (pocketData == null) {
                    System.out.println("[DEBUG ENSURE] pocketData == null after HavenPocketSavedData.get()");
                    return;
                }
                try {
                    Set<UUID> ids = pocketData.getAllPocketIds();
                    Map<UUID, String> cmap = pocketData.getPocketColorMap();
                    int idCount = ids == null ? 0 : ids.size();
                    int cmapCount = cmap == null ? 0 : cmap.size();
                    System.out.println("[DEBUG ENSURE] pocketData present: pocketCount=" + idCount + ", colorCount=" + cmapCount);
                    int printed = 0;
                    if (ids == null) break block15;
                    for (UUID id : ids) {
                        String col = cmap == null ? null : cmap.get(id);
                        System.out.println("[DEBUG ENSURE] persisted pocket: id=" + String.valueOf(id) + " color=" + col);
                        if (++printed < 10) continue;
                        break;
                    }
                }
                catch (Throwable t) {
                    System.out.println("[DEBUG ENSURE] Failed to dump pocketData contents: " + String.valueOf(t));
                }
            }
            for (UUID id : pocketData.getAllPocketIds()) {
                int roomX = (int)((id.getMostSignificantBits() & Integer.MAX_VALUE) % 1000000L);
                int roomZ = (int)((id.getLeastSignificantBits() & Integer.MAX_VALUE) % 1000000L);
                int roomY = 100;
                pocketPositions.put(id, new class_2338(roomX, roomY, roomZ));
            }
            pocketColorMap.putAll(pocketData.getPocketColorMap());
            expansionsPlaced.addAll(pocketData.getAllExpansionKeys());
            structuresPlaced.addAll(pocketData.getAllPocketIds());
            System.out.println("[DEBUG ENSURE] In-memory pocket maps populated: pocketPositions=" + pocketPositions.size() + ", pocketColorMap=" + pocketColorMap.size() + ", structuresPlaced=" + structuresPlaced.size());
        }
        catch (Throwable t) {
            System.out.println("[DEBUG ENSURE] ensurePocketDataLoaded top-level error: " + String.valueOf(t));
        }
    }

    private static void placeGemExpansions(class_3218 havenLevel, class_2338 basePos, String bagColor, class_1263 container, UUID pocketUUID, HavenPocketSavedData pocketData) {
        if (!container.method_5438(0).method_7960() && !pocketData.hasExpansion(pocketUUID, "north")) {
            BagBlockEntityWalksOnTheBlockProcedure.placeExpansion(havenLevel, basePos, bagColor, "north");
            pocketData.markExpansion(pocketUUID, "north");
            System.out.println("[DEBUG] Placed NORTH expansion for " + bagColor + " bag");
        }
        if (!container.method_5438(1).method_7960() && !pocketData.hasExpansion(pocketUUID, "east")) {
            BagBlockEntityWalksOnTheBlockProcedure.placeExpansion(havenLevel, basePos, bagColor, "east");
            pocketData.markExpansion(pocketUUID, "east");
            System.out.println("[DEBUG] Placed EAST expansion for " + bagColor + " bag");
        }
        if (!container.method_5438(2).method_7960() && !pocketData.hasExpansion(pocketUUID, "west")) {
            BagBlockEntityWalksOnTheBlockProcedure.placeExpansion(havenLevel, basePos, bagColor, "west");
            pocketData.markExpansion(pocketUUID, "west");
            System.out.println("[DEBUG] Placed WEST expansion for " + bagColor + " bag");
        }
        if (!container.method_5438(3).method_7960() && !pocketData.hasExpansion(pocketUUID, "south")) {
            BagBlockEntityWalksOnTheBlockProcedure.placeExpansion(havenLevel, basePos, bagColor, "south");
            pocketData.markExpansion(pocketUUID, "south");
            System.out.println("[DEBUG] Placed SOUTH expansion for " + bagColor + " bag");
        }
    }

    private static void placeExpansion(class_3218 havenLevel, class_2338 basePos, String bagColor, String direction) {
        String structureName = bagColor + direction;
        class_3499 template = havenLevel.method_14183().method_15091(class_2960.method_60654((String)("havenbag:" + structureName)));
        if (template != null) {
            class_2338 expansionPos = basePos;
            switch (direction) {
                case "north": {
                    expansionPos = basePos.method_10069(0, 0, -14);
                    break;
                }
                case "south": {
                    expansionPos = basePos.method_10069(0, 0, 14);
                    break;
                }
                case "east": {
                    expansionPos = basePos.method_10069(14, 0, 0);
                    break;
                }
                case "west": {
                    expansionPos = basePos.method_10069(-14, 0, 0);
                }
            }
            template.method_15172((class_5425)havenLevel, expansionPos, expansionPos, new class_3492().method_15123(class_2470.field_11467).method_15125(class_2415.field_11302).method_15133(false), havenLevel.field_9229, 3);
        }
    }
}

