/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.havenbag;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.mcreator.havenbag.block.entity.BlackBagBlockBlockEntity;
import net.minecraft.class_1657;
import net.minecraft.class_3222;

public class HavenBagGemPersistence {
    public static final String BLACK = "black";
    public static final String BLUE = "blue";
    public static final String BROWN = "brown";
    public static final String GREEN = "green";
    public static final String RED = "red";
    public static final String WHITE = "white";
    public static final String YELLOW = "yellow";
    public static final String MERCHANT = "merchant";
    public static final String DECO = "deco";
    public static final String CRAFTY = "crafty";
    public static final String GARDEN = "garden";
    private static final Map<String, Map<String, Boolean>> playerGemData = new HashMap<String, Map<String, Boolean>>();

    private static String getPlayerBagKey(UUID playerUUID, String bagColor) {
        return playerUUID.toString() + "_" + bagColor;
    }

    public static boolean isGemUnlocked(class_1657 player, String bagColor, String gemType) {
        if (!(player instanceof class_3222)) {
            return false;
        }
        String key = HavenBagGemPersistence.getPlayerBagKey(player.method_5667(), bagColor);
        Map<String, Boolean> bagData = playerGemData.get(key);
        if (bagData == null) {
            return false;
        }
        return bagData.getOrDefault(gemType + "_unlocked", false);
    }

    public static void unlockGem(class_1657 player, String bagColor, String gemType) {
        if (!(player instanceof class_3222)) {
            return;
        }
        String key = HavenBagGemPersistence.getPlayerBagKey(player.method_5667(), bagColor);
        Map bagData = playerGemData.computeIfAbsent(key, k -> new HashMap());
        bagData.put(gemType + "_unlocked", true);
        System.out.println("[DEBUG] Unlocked " + gemType + " gem for " + bagColor + " bag (player: " + player.method_5477().getString() + ")");
    }

    public static String getUnlockedGemsString(class_1657 player, String bagColor) {
        if (!(player instanceof class_3222)) {
            return "";
        }
        String key = HavenBagGemPersistence.getPlayerBagKey(player.method_5667(), bagColor);
        Map<String, Boolean> bagData = playerGemData.get(key);
        if (bagData == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        if (bagData.getOrDefault("merchant_unlocked", false).booleanValue()) {
            sb.append(MERCHANT).append(",");
        }
        if (bagData.getOrDefault("deco_unlocked", false).booleanValue()) {
            sb.append(DECO).append(",");
        }
        if (bagData.getOrDefault("crafty_unlocked", false).booleanValue()) {
            sb.append(CRAFTY).append(",");
        }
        if (bagData.getOrDefault("garden_unlocked", false).booleanValue()) {
            sb.append(GARDEN).append(",");
        }
        return sb.length() > 0 ? sb.substring(0, sb.length() - 1) : "";
    }

    public static void restoreGemsToBagEntity(class_1657 player, String bagColor, Object bagEntity) {
        if (!(player instanceof class_3222)) {
            return;
        }
        String unlockedGems = HavenBagGemPersistence.getUnlockedGemsString(player, bagColor);
        if (!unlockedGems.isEmpty() && BLACK.equals(bagColor) && bagEntity instanceof BlackBagBlockBlockEntity) {
            BlackBagBlockBlockEntity blackBag = (BlackBagBlockBlockEntity)((Object)bagEntity);
            blackBag.restoreConsumedGemsFromItem(unlockedGems);
            System.out.println("[DEBUG] Restored global gems to black bag: " + unlockedGems);
        }
    }

    public static void saveGemConsumption(class_1657 player, String bagColor, String gemType) {
        HavenBagGemPersistence.unlockGem(player, bagColor, gemType);
    }
}

