/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter.simpleTimer.utils;

import de.codecrafter.simpleTimer.SimpleTimer;
import net.kyori.adventure.text.format.NamedTextColor;
import org.bukkit.configuration.file.FileConfiguration;

public class TimerConfig {
    private final SimpleTimer plugin;
    private boolean show;
    private boolean showPauseMessage;
    private String pauseMessage;
    private NamedTextColor colorRunning;
    private NamedTextColor colorPaused;
    private NamedTextColor colorPauseMessage;

    public TimerConfig(SimpleTimer plugin) {
        this.plugin = plugin;
        this.load(plugin.getConfig());
    }

    public void reload() {
        this.plugin.reloadConfig();
        this.load(this.plugin.getConfig());
        this.plugin.getComponentLogger().info("Timer config reloaded.");
    }

    private void load(FileConfiguration config) {
        this.show = config.getBoolean("timer.show", true);
        this.showPauseMessage = config.getBoolean("timer.show_pause_message", true);
        this.pauseMessage = config.getString("timer.pause_message", "Timer paused");
        this.colorRunning = (NamedTextColor)NamedTextColor.NAMES.value((Object)config.getString("timer.color_running", "YELLOW").toLowerCase());
        this.colorPaused = (NamedTextColor)NamedTextColor.NAMES.value((Object)config.getString("timer.color_paused", "GOLD").toLowerCase());
        this.colorPauseMessage = (NamedTextColor)NamedTextColor.NAMES.value((Object)config.getString("timer.color_pause_message", "GOLD").toLowerCase());
    }

    public boolean isShow() {
        return this.show;
    }

    public boolean isShowPauseMessage() {
        return this.showPauseMessage;
    }

    public String getPauseMessage() {
        return this.pauseMessage;
    }

    public NamedTextColor getColorRunning() {
        return this.colorRunning;
    }

    public NamedTextColor getColorPaused() {
        return this.colorPaused;
    }

    public NamedTextColor getColorPauseMessage() {
        return this.colorPauseMessage;
    }
}

