/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter.simpleTimer.utils;

import de.codecrafter.simpleTimer.SimpleTimer;
import de.codecrafter.simpleTimer.models.Timer;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;

public class TimerManager {
    private final SimpleTimer plugin;
    private final File file;
    private final YamlConfiguration data;
    private final Map<String, Timer> timers;
    private Timer activeTimer;

    public TimerManager(SimpleTimer plugin) {
        this.plugin = plugin;
        this.file = new File(plugin.getDataFolder(), "timers.yml");
        if (!this.file.exists()) {
            try {
                plugin.getDataFolder().mkdirs();
                this.file.createNewFile();
            }
            catch (IOException e) {
                plugin.getComponentLogger().error("Error while creating timers.yml file.", (Throwable)e);
            }
        }
        this.data = YamlConfiguration.loadConfiguration((File)this.file);
        this.timers = this.loadTimersFromDisk();
        this.activeTimer = this.timers.get(this.data.getString("active", null));
    }

    private Map<String, Timer> loadTimersFromDisk() {
        HashMap<String, Timer> loadedTimers = new HashMap<String, Timer>();
        ConfigurationSection section = this.data.getConfigurationSection("timers");
        if (section != null) {
            for (String key : section.getKeys(false)) {
                long time = this.data.getLong("timers." + key + ".time", 0L);
                boolean running = this.data.getBoolean("timers." + key + ".running", false);
                loadedTimers.put(key, new Timer(key, time, running));
            }
        }
        return loadedTimers;
    }

    public void setActiveTimer(String name) {
        this.activeTimer = name == null || !this.timers.containsKey(name) ? null : this.timers.get(name);
    }

    public Timer getActiveTimer() {
        if (this.activeTimer != null && this.timers.containsValue(this.activeTimer)) {
            return this.activeTimer;
        }
        return null;
    }

    public Timer getTimer(String name) {
        return name == null ? null : this.timers.get(name);
    }

    public List<String> getTimerNames() {
        return new ArrayList<String>(this.timers.keySet());
    }

    public List<Timer> getAllTimers() {
        return new ArrayList<Timer>(this.timers.values());
    }

    public void addTimer(Timer timer) {
        this.timers.put(timer.getName(), timer);
    }

    public void removeTimer(Timer timer) {
        this.timers.remove(timer.getName());
        if (timer.equals(this.activeTimer)) {
            this.setActiveTimer(null);
        }
    }

    public void saveToFile() {
        if (this.activeTimer != null && this.timers.containsValue(this.activeTimer)) {
            this.data.set("active", (Object)this.activeTimer.getName());
        } else {
            this.data.set("active", null);
        }
        this.data.set("timers", null);
        this.timers.forEach((key, timer) -> {
            this.data.set("timers." + key + ".time", (Object)timer.getTime());
            this.data.set("timers." + key + ".running", (Object)timer.isRunning());
        });
        try {
            this.data.save(this.file);
        }
        catch (IOException e) {
            this.plugin.getComponentLogger().error("Error saving timers.yml", (Throwable)e);
        }
    }
}

