/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter.simpleTimer;

import de.codecrafter.simpleTimer.commands.TimerCommand;
import de.codecrafter.simpleTimer.listeners.PlayerDeathListener;
import de.codecrafter.simpleTimer.listeners.PlayerJoinListener;
import de.codecrafter.simpleTimer.models.Timer;
import de.codecrafter.simpleTimer.utils.Formatter;
import de.codecrafter.simpleTimer.utils.TimerConfig;
import de.codecrafter.simpleTimer.utils.TimerManager;
import de.codecrafter.simpleTimer.utils.UpdateChecker;
import java.util.Collection;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitScheduler;

public final class SimpleTimer
extends JavaPlugin {
    private static SimpleTimer plugin;
    private TimerConfig timerConfig;
    private TimerManager timerManager;
    private Timer activeTimer;
    private boolean showPauseString;

    public void onEnable() {
        plugin = this;
        this.saveDefaultConfig();
        this.timerConfig = new TimerConfig(this);
        BukkitScheduler scheduler = this.getServer().getScheduler();
        UpdateChecker updateChecker = new UpdateChecker(this);
        scheduler.runTaskTimerAsynchronously((Plugin)this, updateChecker::check, 0L, 72000L);
        this.timerManager = new TimerManager(this);
        this.activeTimer = this.timerManager.getActiveTimer();
        if (this.activeTimer == null) {
            if (this.timerManager.getTimerNames().isEmpty()) {
                this.activeTimer = new Timer("default", 0L, false);
                this.timerManager.addTimer(this.activeTimer);
                this.timerManager.setActiveTimer(this.activeTimer.getName());
            } else {
                this.activeTimer = this.timerManager.getTimer(this.timerManager.getTimerNames().getFirst());
            }
        }
        this.getCommand("timer").setExecutor((CommandExecutor)new TimerCommand());
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerDeathListener(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerJoinListener(updateChecker), (Plugin)this);
        this.showPauseString = true;
        scheduler.runTaskTimer((Plugin)this, () -> {
            Collection onlinePlayers = this.getServer().getOnlinePlayers();
            if (!onlinePlayers.isEmpty() || this.getTimerConfig().isRunWithoutPlayers()) {
                if (this.activeTimer == null) {
                    onlinePlayers.forEach(player -> player.sendActionBar(Component.text((String)"No timer selected").color((TextColor)NamedTextColor.RED)));
                    return;
                }
                if (this.activeTimer.isRunning()) {
                    if (!this.activeTimer.addTime()) {
                        this.activeTimer.setRunning(false);
                        onlinePlayers.forEach(player -> player.sendMessage(Component.text((String)"Timer reached maximum duration!").color((TextColor)NamedTextColor.RED)));
                        return;
                    }
                    onlinePlayers.forEach(player -> player.sendActionBar(Component.text((String)Formatter.formatTime(this.activeTimer.getTime())).color((TextColor)this.getTimerConfig().getColorRunning())));
                } else {
                    onlinePlayers.forEach(player -> {
                        if (this.showPauseString && this.timerConfig.isShowPauseMessage()) {
                            player.sendActionBar(Component.text((String)this.timerConfig.getPauseMessage()).color((TextColor)this.getTimerConfig().getColorPauseMessage()));
                        } else {
                            player.sendActionBar(Component.text((String)Formatter.formatTime(this.activeTimer.getTime())).color((TextColor)this.getTimerConfig().getColorPaused()));
                        }
                    });
                    this.showPauseString = !this.showPauseString;
                }
            }
        }, 0L, 20L);
    }

    public void onDisable() {
        this.timerManager.saveToFile();
    }

    public static SimpleTimer getPlugin() {
        return plugin;
    }

    public TimerConfig getTimerConfig() {
        return this.timerConfig;
    }

    public TimerManager getTimerManager() {
        return this.timerManager;
    }

    public Timer getActiveTimer() {
        return this.activeTimer;
    }

    public void setActiveTimer(Timer activeTimer) {
        this.activeTimer = activeTimer;
        this.timerManager.setActiveTimer(activeTimer != null ? activeTimer.getName() : null);
    }
}

