/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter.simpleTimer.commands;

import de.codecrafter.simpleTimer.SimpleTimer;
import de.codecrafter.simpleTimer.models.Timer;
import de.codecrafter.simpleTimer.utils.Formatter;
import java.util.Comparator;
import java.util.List;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.JoinConfiguration;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabExecutor;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TimerCommand
implements TabExecutor {
    public boolean onCommand(@NotNull CommandSender commandSender, @NotNull Command command, @NotNull String s, @NotNull @NotNull String @NotNull [] strings) {
        if (!(commandSender instanceof Player)) {
            commandSender.sendMessage("This command can only be executed by players.");
            return true;
        }
        if (strings.length == 0) {
            commandSender.sendMessage("Usage: /timer <pause|resume|reset|reload|save|name|list|set|select|remove|create|state> [seconds|timer_name]");
            return true;
        }
        SimpleTimer simpleTimer = SimpleTimer.getPlugin();
        switch (strings[0].toLowerCase()) {
            case "pause": {
                Timer timer2 = this.getActiveTimerOrWarn(simpleTimer, commandSender);
                if (timer2 == null) {
                    return true;
                }
                timer2.setRunning(false);
                return true;
            }
            case "resume": {
                Timer timer3 = this.getActiveTimerOrWarn(simpleTimer, commandSender);
                if (timer3 == null) {
                    return true;
                }
                timer3.setRunning(true);
                return true;
            }
            case "reset": {
                Timer timer4 = this.getActiveTimerOrWarn(simpleTimer, commandSender);
                if (timer4 == null) {
                    return true;
                }
                timer4.setRunning(false);
                timer4.setTime(0L);
                return true;
            }
            case "reload": {
                simpleTimer.getTimerConfig().reload();
                commandSender.sendMessage("Configuration reloaded successfully.");
                return true;
            }
            case "save": {
                simpleTimer.getTimerManager().saveToFile();
                commandSender.sendMessage("All timers have been saved.");
                return true;
            }
            case "list": {
                List<Timer> allTimers = simpleTimer.getTimerManager().getAllTimers();
                if (allTimers.isEmpty()) {
                    commandSender.sendMessage("There are no timers.");
                    return true;
                }
                allTimers.sort(Comparator.comparing(Timer::getName));
                Component timersFormatted = Component.join((JoinConfiguration)JoinConfiguration.newlines(), allTimers.stream().map(timer -> (TextComponent)Component.text((String)"- ").append(((TextComponent)Component.text((String)(timer.getName() + " (" + Formatter.formatTime(timer.getTime()) + ")")).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Click to select")))).clickEvent(ClickEvent.suggestCommand((String)("/timer select " + timer.getName()))))).toList());
                commandSender.sendMessage(((TextComponent)Component.text((String)"Existing timers:").append((Component)Component.newline())).append(timersFormatted));
                return true;
            }
            case "name": {
                Timer timer5 = this.getActiveTimerOrWarn(simpleTimer, commandSender);
                if (timer5 == null) {
                    return true;
                }
                commandSender.sendMessage("The active timer is: " + timer5.getName());
                return true;
            }
            case "state": {
                Timer timer6 = strings.length == 1 ? this.getActiveTimerOrWarn(simpleTimer, commandSender) : this.getTimerOrWarn(simpleTimer, commandSender, strings[1]);
                if (timer6 == null) {
                    return true;
                }
                commandSender.sendMessage("State of timer \"" + timer6.getName() + "\" is: " + Formatter.formatTime(timer6.getTime()));
                return true;
            }
            case "remove": {
                Timer timer7 = strings.length == 1 ? this.getActiveTimerOrWarn(simpleTimer, commandSender) : this.getTimerOrWarn(simpleTimer, commandSender, strings[1]);
                if (timer7 == null) {
                    return true;
                }
                simpleTimer.getTimerManager().removeTimer(timer7);
                Timer activeTimer = simpleTimer.getActiveTimer();
                if (activeTimer != null && activeTimer.getName().equals(timer7.getName())) {
                    simpleTimer.setActiveTimer(null);
                }
                commandSender.sendMessage("Removed timer: " + timer7.getName());
                return true;
            }
            case "set": {
                if (strings.length < 2) {
                    commandSender.sendMessage("Usage: /timer set <seconds>");
                    return true;
                }
                Timer timer8 = this.getActiveTimerOrWarn(simpleTimer, commandSender);
                if (timer8 == null) {
                    return true;
                }
                timer8.setRunning(false);
                try {
                    long newState = Long.parseLong(strings[1]);
                    if (newState <= 0L) {
                        commandSender.sendMessage("The time must be greater than 0 seconds.");
                    }
                    timer8.setTime(newState);
                }
                catch (Exception e) {
                    commandSender.sendMessage("Please enter a valid number for the time.");
                }
                commandSender.sendMessage("Timer updated to " + timer8.getTime() + " seconds.");
                return true;
            }
            case "select": {
                if (strings.length < 2) {
                    commandSender.sendMessage("Usage: /timer select <name>");
                    return true;
                }
                Timer timer9 = this.getTimerOrWarn(simpleTimer, commandSender, strings[1]);
                if (timer9 == null) {
                    return true;
                }
                simpleTimer.setActiveTimer(timer9);
                simpleTimer.getActiveTimer().setRunning(false);
                commandSender.sendMessage("Selected timer: " + timer9.getName());
                return true;
            }
            case "create": {
                if (strings.length < 2) {
                    commandSender.sendMessage("Usage: /timer create <name>");
                    return true;
                }
                String timerName = strings[1].trim();
                if (timerName.isEmpty()) {
                    commandSender.sendMessage("Timer name cannot be empty.");
                    return true;
                }
                if (timerName.length() > 20) {
                    commandSender.sendMessage("Timer name must not exceed 20 characters.");
                    return true;
                }
                if (!timerName.matches("[a-zA-Z0-9_-]+")) {
                    commandSender.sendMessage("Only letters, numbers, underscores (_) and dashes (-) are allowed.");
                    return true;
                }
                if (simpleTimer.getTimerManager().getTimer(timerName) != null) {
                    commandSender.sendMessage("A timer with that name already exists.");
                    return true;
                }
                Timer newTimer = new Timer(timerName, 0L, false);
                simpleTimer.getTimerManager().addTimer(newTimer);
                if (simpleTimer.getTimerConfig().isAutoSelectNewTimer()) {
                    simpleTimer.setActiveTimer(newTimer);
                    commandSender.sendMessage("Created and selected new timer: " + newTimer.getName());
                    return true;
                }
                commandSender.sendMessage(Component.text((String)"Created timer: ").append(((TextComponent)Component.text((String)newTimer.getName()).hoverEvent((HoverEventSource)HoverEvent.showText((Component)Component.text((String)"Click to select")))).clickEvent(ClickEvent.suggestCommand((String)("/timer select " + newTimer.getName())))));
                return true;
            }
        }
        commandSender.sendMessage("Usage: /timer <pause|resume|reset|reload|save|name|list|set|select|remove|create|state> [seconds|timer_name]");
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender commandSender, @NotNull Command command, @NotNull String s, @NotNull @NotNull String @NotNull [] strings) {
        List<String> options = List.of("pause", "resume", "reset", "reload", "save", "list", "set", "select", "remove", "name", "create", "state");
        if (strings.length == 1) {
            return options.stream().filter(option -> option.startsWith(strings[0].toLowerCase())).toList();
        }
        if (strings.length == 2 && List.of("select", "remove", "state").contains(strings[0].toLowerCase())) {
            return SimpleTimer.getPlugin().getTimerManager().getTimerNames().stream().filter(name -> name.startsWith(strings[1].toLowerCase())).toList();
        }
        return List.of();
    }

    private Timer getTimerOrWarn(SimpleTimer plugin, CommandSender sender, String name) {
        Timer timer = plugin.getTimerManager().getTimer(name);
        if (timer == null) {
            sender.sendMessage("Timer \"" + name + "\" does not exist.");
        }
        return timer;
    }

    private Timer getActiveTimerOrWarn(SimpleTimer plugin, CommandSender sender) {
        Timer timer = plugin.getActiveTimer();
        if (timer == null) {
            sender.sendMessage("No timer selected.");
        }
        return timer;
    }
}

