/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter.simpleTimer.utils;

import de.codecrafter.simpleTimer.SimpleTimer;
import net.kyori.adventure.text.format.NamedTextColor;
import org.bukkit.configuration.file.FileConfiguration;

public class TimerConfig {
    private final SimpleTimer plugin;
    private boolean showPauseMessage;
    private String pauseMessage;
    private NamedTextColor colorRunning;
    private NamedTextColor colorPaused;
    private NamedTextColor colorPauseMessage;
    private boolean runWithoutPlayers;
    private boolean pauseOnPlayerDeath;
    private boolean autoSelectNewTimer;

    public TimerConfig(SimpleTimer plugin) {
        this.plugin = plugin;
        this.load(plugin.getConfig());
    }

    public void reload() {
        this.plugin.reloadConfig();
        this.load(this.plugin.getConfig());
        this.plugin.getComponentLogger().info("Timer config reloaded.");
    }

    private void load(FileConfiguration config) {
        this.showPauseMessage = config.getBoolean("timer.show_pause_message", true);
        this.pauseMessage = config.getString("timer.pause_message", "Timer paused");
        this.colorRunning = (NamedTextColor)NamedTextColor.NAMES.value((Object)config.getString("timer.color_running", "YELLOW").toLowerCase());
        this.colorPaused = (NamedTextColor)NamedTextColor.NAMES.value((Object)config.getString("timer.color_paused", "GOLD").toLowerCase());
        this.colorPauseMessage = (NamedTextColor)NamedTextColor.NAMES.value((Object)config.getString("timer.color_pause_message", "GOLD").toLowerCase());
        this.runWithoutPlayers = config.getBoolean("timer.run_without_players", false);
        this.pauseOnPlayerDeath = config.getBoolean("timer.pause_on_player_death", false);
        this.autoSelectNewTimer = config.getBoolean("timer.auto_select_new_timer", false);
    }

    public boolean isShowPauseMessage() {
        return this.showPauseMessage;
    }

    public String getPauseMessage() {
        return this.pauseMessage;
    }

    public NamedTextColor getColorRunning() {
        return this.colorRunning;
    }

    public NamedTextColor getColorPaused() {
        return this.colorPaused;
    }

    public NamedTextColor getColorPauseMessage() {
        return this.colorPauseMessage;
    }

    public boolean isRunWithoutPlayers() {
        return this.runWithoutPlayers;
    }

    public boolean isPauseOnPlayerDeath() {
        return this.pauseOnPlayerDeath;
    }

    public boolean isAutoSelectNewTimer() {
        return this.autoSelectNewTimer;
    }
}

