/*
 * Decompiled with CFR 0.152.
 */
package de.codecrafter.simpleTimer.utils;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import de.codecrafter.simpleTimer.SimpleTimer;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URI;
import org.bukkit.plugin.Plugin;

public class UpdateChecker {
    private static final String githubApiUrl = "https://api.github.com/repos/IschdeFelin/mc-simple-timer/releases/latest";
    private final SimpleTimer plugin;
    private boolean updateAvailable = false;
    private String latestVersion = "";
    private String currentVersion = "";

    public UpdateChecker(SimpleTimer plugin) {
        this.plugin = plugin;
    }

    public void check() {
        this.plugin.getServer().getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try {
                HttpURLConnection conn = (HttpURLConnection)URI.create(githubApiUrl).toURL().openConnection();
                conn.setRequestProperty("Accept", "application/vnd.github+json");
                conn.setRequestProperty("User-Agent", "SimpleTimerUpdateChecker");
                try (InputStreamReader reader = new InputStreamReader(conn.getInputStream());){
                    JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                    String latestVersion = this.normalizeVersion(json.get("tag_name").getAsString());
                    String currentVersion = this.normalizeVersion(this.plugin.getPluginMeta().getVersion());
                    if (this.isNewerVersion(currentVersion, latestVersion)) {
                        this.updateAvailable = true;
                        this.latestVersion = latestVersion;
                        this.currentVersion = currentVersion;
                        this.plugin.getLogger().warning("A new version is available: " + latestVersion + " (you have " + currentVersion + ")");
                    } else {
                        this.plugin.getLogger().info("You are using the latest version (" + currentVersion + ")");
                    }
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Failed to check for updates: " + e.getMessage());
            }
        });
    }

    private String normalizeVersion(String version) {
        return version.replace("v", "").replace("_", "-").trim().toLowerCase();
    }

    private boolean isNewerVersion(String current, String latest) {
        String[] currentParts = current.split("-", 2);
        String currentBase = currentParts[0];
        boolean currentIsPreRelease = currentParts.length > 1;
        String[] latestParts = latest.split("-", 2);
        String latestBase = latestParts[0];
        boolean latestIsPreRelease = latestParts.length > 1;
        String[] currentNumbers = currentBase.split("\\.");
        String[] latestNumbers = latestBase.split("\\.");
        int length = Math.max(currentNumbers.length, latestNumbers.length);
        for (int i = 0; i < length; ++i) {
            int lat;
            int curr = i < currentNumbers.length ? this.parseSafe(currentNumbers[i]) : 0;
            int n = lat = i < latestNumbers.length ? this.parseSafe(latestNumbers[i]) : 0;
            if (curr < lat) {
                return true;
            }
            if (curr <= lat) continue;
            return false;
        }
        return currentIsPreRelease && !latestIsPreRelease;
    }

    private int parseSafe(String number) {
        try {
            return Integer.parseInt(number);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public boolean isUpdateAvailable() {
        return this.updateAvailable;
    }

    public String getLatestVersion() {
        return this.latestVersion;
    }

    public String getCurrentVersion() {
        return this.currentVersion;
    }
}

