/*
 * Decompiled with CFR 0.152.
 */
package com.tyler.narutoorigin.Teams;

import com.tyler.narutoorigin.Teams.RatjaTeam;
import com.tyler.narutoorigin.Teams.RatjaTeamsRegistry;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;

public class RatjaCommandShinobi
extends CommandBase {
    public String func_71517_b() {
        return "shinobi";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/shinobi <create|join|leave|list|delete|approve|privacy|members|kick> [arguments]";
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        return true;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws WrongUsageException {
        if (!(sender instanceof EntityPlayerMP)) {
            sender.func_145747_a((ITextComponent)new TextComponentString("This command can only be used by players."));
            return;
        }
        EntityPlayerMP player = (EntityPlayerMP)sender;
        if (args.length < 1) {
            throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
        }
        switch (args[0]) {
            case "create": {
                if (args.length < 3) {
                    throw new WrongUsageException("/shinobi create <TeamName> <public|private>", new Object[0]);
                }
                this.createTeam(player, args[1], args[2]);
                break;
            }
            case "join": {
                if (args.length < 2) {
                    throw new WrongUsageException("/shinobi join <TeamName>", new Object[0]);
                }
                this.joinTeam(player, args[1]);
                break;
            }
            case "leave": {
                this.leaveTeam(player);
                break;
            }
            case "list": {
                this.listTeams(player);
                break;
            }
            case "delete": {
                if (args.length < 2) {
                    throw new WrongUsageException("/shinobi delete <TeamName>", new Object[0]);
                }
                this.deleteTeam(player, args[1]);
                break;
            }
            case "approve": {
                if (args.length < 2) {
                    throw new WrongUsageException("/shinobi approve <PlayerName>", new Object[0]);
                }
                this.approveJoinRequest(player, args[1]);
                break;
            }
            case "privacy": {
                if (args.length < 2) {
                    throw new WrongUsageException("/shinobi privacy <public|private>", new Object[0]);
                }
                this.changePrivacy(player, args[1]);
                break;
            }
            case "members": {
                if (args.length < 2) {
                    throw new WrongUsageException("/shinobi members <TeamName>", new Object[0]);
                }
                this.listMembers(player, args[1]);
                break;
            }
            case "kick": {
                if (args.length < 2) {
                    throw new WrongUsageException("/shinobi kick <PlayerName>", new Object[0]);
                }
                this.kickMember(player, args[1]);
                break;
            }
            default: {
                throw new WrongUsageException(this.func_71518_a(sender), new Object[0]);
            }
        }
    }

    private void createTeam(EntityPlayerMP player, String teamName, String privacy) {
        if (RatjaTeamsRegistry.getTeamForPlayer(player.func_70005_c_()) != null) {
            player.func_145747_a((ITextComponent)new TextComponentString("You are already in a team."));
            return;
        }
        boolean isPublic = privacy.equalsIgnoreCase("public");
        RatjaTeamsRegistry.createTeam(teamName, player.func_70005_c_(), isPublic);
        player.func_145747_a((ITextComponent)new TextComponentString("Team '" + teamName + "' has been created as " + (isPublic ? "public." : "private.")));
    }

    private void joinTeam(EntityPlayerMP player, String teamName) {
        if (RatjaTeamsRegistry.getTeamForPlayer(player.func_70005_c_()) != null) {
            player.func_145747_a((ITextComponent)new TextComponentString("You are already in a team."));
            return;
        }
        RatjaTeam team = RatjaTeamsRegistry.getTeam(teamName);
        if (team == null) {
            player.func_145747_a((ITextComponent)new TextComponentString("Team not found."));
            return;
        }
        if (team.isPublic()) {
            RatjaTeamsRegistry.addPlayerToTeam(team.getName(), player.func_70005_c_());
            player.func_145747_a((ITextComponent)new TextComponentString("You have joined the public team '" + teamName + "'."));
        } else {
            EntityPlayerMP leader = player.func_184102_h().func_184103_al().func_152612_a(team.getLeader());
            if (leader != null) {
                leader.func_145747_a((ITextComponent)new TextComponentString(player.func_70005_c_() + " wants to join your team '" + teamName + "'. Use /shinobi approve " + player.func_70005_c_() + " to approve."));
                player.func_145747_a((ITextComponent)new TextComponentString("Join request sent to the team leader."));
            } else {
                player.func_145747_a((ITextComponent)new TextComponentString("The team leader is offline. You cannot join this team right now."));
            }
        }
    }

    private void leaveTeam(EntityPlayerMP player) {
        RatjaTeam team = RatjaTeamsRegistry.getTeamForPlayer(player.func_70005_c_());
        if (team == null) {
            player.func_145747_a((ITextComponent)new TextComponentString("You are not in a team."));
            return;
        }
        if (team.isLeader(player.func_70005_c_())) {
            player.func_145747_a((ITextComponent)new TextComponentString("You are the leader and cannot leave. Use /shinobi delete <TeamName> to delete the team."));
            return;
        }
        RatjaTeamsRegistry.removePlayerFromTeam(team.getName(), player.func_70005_c_());
        player.func_145747_a((ITextComponent)new TextComponentString("You have left the team '" + team.getName() + "'."));
    }

    private void listTeams(EntityPlayerMP player) {
        StringBuilder sb = new StringBuilder("Available teams:");
        for (RatjaTeam team : RatjaTeamsRegistry.getAllTeams()) {
            sb.append("\n- ").append(team.getName()).append(" (").append(team.getMembers().size()).append(" members, ").append(team.isPublic() ? "public" : "private").append(")");
        }
        player.func_145747_a((ITextComponent)new TextComponentString(sb.toString()));
    }

    private void deleteTeam(EntityPlayerMP player, String teamName) {
        RatjaTeam team = RatjaTeamsRegistry.getTeam(teamName);
        if (team == null) {
            player.func_145747_a((ITextComponent)new TextComponentString("Team not found."));
            return;
        }
        if (!team.isLeader(player.func_70005_c_())) {
            player.func_145747_a((ITextComponent)new TextComponentString("Only the team leader or an admin can delete the team."));
            return;
        }
        RatjaTeamsRegistry.deleteTeam(teamName);
        player.func_145747_a((ITextComponent)new TextComponentString("Team '" + teamName + "' has been deleted."));
    }

    private void approveJoinRequest(EntityPlayerMP leader, String playerName) {
        RatjaTeam team = RatjaTeamsRegistry.getTeamForPlayer(leader.func_70005_c_());
        if (team == null || !team.isLeader(leader.func_70005_c_())) {
            leader.func_145747_a((ITextComponent)new TextComponentString("You are not the leader of a team."));
            return;
        }
        EntityPlayerMP player = leader.func_184102_h().func_184103_al().func_152612_a(playerName);
        if (player == null) {
            leader.func_145747_a((ITextComponent)new TextComponentString("Player not found or offline."));
            return;
        }
        RatjaTeamsRegistry.addPlayerToTeam(team.getName(), player.func_70005_c_());
        leader.func_145747_a((ITextComponent)new TextComponentString(player.func_70005_c_() + " has been added to your team."));
        player.func_145747_a((ITextComponent)new TextComponentString("You have been added to the team '" + team.getName() + "'."));
    }

    private void changePrivacy(EntityPlayerMP leader, String privacy) {
        RatjaTeam team = RatjaTeamsRegistry.getTeamForPlayer(leader.func_70005_c_());
        if (team == null || !team.isLeader(leader.func_70005_c_())) {
            leader.func_145747_a((ITextComponent)new TextComponentString("You are not the leader of a team."));
            return;
        }
        boolean isPublic = privacy.equalsIgnoreCase("public");
        team.setPublic(isPublic);
        RatjaTeamsRegistry.saveTeams();
        leader.func_145747_a((ITextComponent)new TextComponentString("Your team '" + team.getName() + "' is now " + (isPublic ? "public." : "private.")));
    }

    private void listMembers(EntityPlayerMP player, String teamName) {
        RatjaTeam team = RatjaTeamsRegistry.getTeam(teamName);
        if (team == null) {
            player.func_145747_a((ITextComponent)new TextComponentString("Team not found: " + teamName));
            return;
        }
        StringBuilder sb = new StringBuilder("Members of team '" + teamName + "':");
        for (String member : team.getMembers()) {
            sb.append("\n- ").append(member);
        }
        player.func_145747_a((ITextComponent)new TextComponentString(sb.toString()));
    }

    private void kickMember(EntityPlayerMP leader, String playerName) {
        RatjaTeam team = RatjaTeamsRegistry.getTeamForPlayer(leader.func_70005_c_());
        if (team == null || !team.isLeader(leader.func_70005_c_())) {
            leader.func_145747_a((ITextComponent)new TextComponentString("You are not the leader of a team."));
            return;
        }
        if (!team.getMembers().contains(playerName)) {
            leader.func_145747_a((ITextComponent)new TextComponentString("Player is not in your team."));
            return;
        }
        if (team.isLeader(playerName)) {
            leader.func_145747_a((ITextComponent)new TextComponentString("You cannot kick yourself. Use /shinobi delete <TeamName> to delete the team."));
            return;
        }
        RatjaTeamsRegistry.removePlayerFromTeam(team.getName(), playerName);
        leader.func_145747_a((ITextComponent)new TextComponentString("Player '" + playerName + "' has been kicked from the team."));
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length == 1) {
            return RatjaCommandShinobi.func_71530_a((String[])args, (String[])new String[]{"create", "join", "leave", "list", "delete", "approve", "privacy", "members", "kick"});
        }
        if (args.length == 2) {
            switch (args[0]) {
                case "join": 
                case "delete": 
                case "members": {
                    return RatjaCommandShinobi.func_71530_a((String[])args, (String[])((String[])RatjaTeamsRegistry.getAllTeams().stream().map(RatjaTeam::getName).toArray(String[]::new)));
                }
                case "approve": 
                case "kick": {
                    return RatjaCommandShinobi.func_71530_a((String[])args, (String[])server.func_71213_z());
                }
                case "privacy": {
                    return RatjaCommandShinobi.func_71530_a((String[])args, (String[])new String[]{"public", "private"});
                }
            }
        } else if (args.length == 3 && args[0].equals("create")) {
            return RatjaCommandShinobi.func_71530_a((String[])args, (String[])new String[]{"public", "private"});
        }
        return Collections.emptyList();
    }
}

