/*
 * Decompiled with CFR 0.152.
 */
package com.tyler.narutoorigin.Teams;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.tyler.narutoorigin.Teams.RatjaTeam;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.server.MinecraftServer;

public class RatjaTeamsRegistry {
    private static String filePath;
    private static final Map<String, RatjaTeam> teams;

    public static void initialize(MinecraftServer server) {
        File worldDirectory = server.func_71218_a(0).func_72860_G().func_75765_b();
        File narutoOriginsDir = new File(worldDirectory, "NarutoOrigins/Teams");
        if (!narutoOriginsDir.exists()) {
            narutoOriginsDir.mkdirs();
        }
        filePath = Paths.get(narutoOriginsDir.getPath(), "teams.json").toString();
        RatjaTeamsRegistry.loadTeams();
    }

    public static void loadTeams() {
        File file = new File(filePath);
        if (!file.exists()) {
            System.out.println("[RatjaTeamsRegistry] No existing team file found. A new file will be created.");
            return;
        }
        try (FileReader reader = new FileReader(file);){
            Gson gson = new Gson();
            Type type = new TypeToken<Map<String, RatjaTeam>>(){}.getType();
            Map loadedTeams = (Map)gson.fromJson((Reader)reader, type);
            if (loadedTeams != null) {
                teams.putAll(loadedTeams);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void saveTeams() {
        if (filePath == null) {
            System.out.println("[RatjaTeamsRegistry] File path is not initialized. Cannot save teams.");
            return;
        }
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        try (FileWriter writer = new FileWriter(filePath);){
            gson.toJson(teams, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void createTeam(String teamName, String leaderName, boolean isPublic) {
        if (teams.containsKey(teamName)) {
            return;
        }
        teams.put(teamName, new RatjaTeam(teamName, leaderName, isPublic));
        RatjaTeamsRegistry.saveTeams();
    }

    public static void deleteTeam(String teamName) {
        if (teams.containsKey(teamName)) {
            teams.remove(teamName);
            RatjaTeamsRegistry.saveTeams();
        }
    }

    public static void addPlayerToTeam(String teamName, String playerName) {
        RatjaTeam team = teams.get(teamName);
        if (team != null) {
            team.addMember(playerName);
            RatjaTeamsRegistry.saveTeams();
        }
    }

    public static void removePlayerFromTeam(String teamName, String playerName) {
        RatjaTeam team = teams.get(teamName);
        if (team != null) {
            team.removeMember(playerName);
            RatjaTeamsRegistry.saveTeams();
        }
    }

    public static RatjaTeam getTeamForPlayer(String playerName) {
        return teams.values().stream().filter(team -> team.getMembers().contains(playerName)).findFirst().orElse(null);
    }

    public static RatjaTeam getTeam(String teamName) {
        return teams.get(teamName);
    }

    public static Collection<RatjaTeam> getAllTeams() {
        return teams.values();
    }

    static {
        teams = new HashMap<String, RatjaTeam>();
    }
}

