/*
 * Decompiled with CFR 0.152.
 */
package com.tyler.narutoorigin.config;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public class NarutoOriginsConfig {
    public static float tailedBeastProbability;
    public static float medicProbability;
    public static float senjuWoodKKGProbability;
    public static float ketsuryuganProbability;
    public static float otsutsukiByakuganProbability;
    public static boolean onlyDojutsuNoKKG;
    public static int maxSimulations;
    public static boolean monkeyClan;
    public static float monkeyClanProbability;
    public static boolean ghostClan;
    public static float ghostClanProbability;
    public static float kkgStealerProbability;
    public static boolean allowKetsuAsRandomDojutsu;
    public static float senjutsuProbability;
    public static int uchihaProbability;
    public static int hyugaProbability;
    public static int otsusukiProbability;
    public static int senjuProbability;
    public static boolean enableDustKKG;
    public static boolean maxHealthRespawn;
    public static boolean allowCheatClan;
    public static boolean allowStarterClanItems;
    public static boolean keepModItemsOnDeath;
    public static String[] simulateableClans;
    public static String[] simulateableKKGs;
    public static String[] simulateableSenjutsu;
    public static Map<String, String> clanItems;
    public static Map<String, KKGMapping> kkgMappings;
    private static final String CATEGORY_SERVER = "Server";
    private static final String CATEGORY_PROBABILITIES = "Probabilities";
    private static final String CATEGORY_OTSUTSUKI = "Otsutsuki Probabilities";
    private static final String CATEGORY_SIMULATIONS = "Simulations";
    private static final String CATEGORY_SETTINGS = "Settings";
    private static final String CATEGORY_MONKEY_CLAN = "Monkey Clan";
    private static final String CATEGORY_GHOST_CLAN = "Ghost Clan";
    private static final String CATEGORY_RESPAWN = "Respawn Settings";
    private static final String CATEGORY_SIMULATEABLE_CLANS = "Simulateable Clans";
    private static final String CATEGORY_SIMULATEABLE_KKGS = "Simulateable KKGs";
    private static final String CATEGORY_CLAN_ITEMS = "ClanItems";
    private static final String CATEGORY_KKG_STEALER = "KKG Stealer";
    private static final String CATEGORY_KKG_MAPPINGS = "KKG Mappings";
    private static final String CATEGORY_CONTRACTS = "Contracts";
    public static float contractProbability;
    public static String[] simulateableContracts;
    private static final String CATEGORY_SENJUTSU = "Senjutsu";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(FMLPreInitializationEvent event) {
        File directory = event.getModConfigurationDirectory();
        File configFile = new File(directory.getPath(), "NarutoOrigins.cfg");
        Configuration config = new Configuration(configFile);
        try {
            String[] clanItemsArray;
            config.load();
            tailedBeastProbability = config.getFloat("tailedBeast", CATEGORY_PROBABILITIES, 0.07f, 0.0f, 1.0f, "Probability of a player obtaining a Tailed Beast (7% chance by default)");
            medicProbability = config.getFloat("medic", CATEGORY_PROBABILITIES, 0.3f, 0.0f, 1.0f, "Probability of a player becoming a Medic (30% chance by default)");
            senjuWoodKKGProbability = config.getFloat("senjuWoodKKG", CATEGORY_PROBABILITIES, 0.6f, 0.0f, 1.0f, "Probability of a Senju player obtaining Wood Release as a bonus Kekkei Genkai (60% chance by default)");
            ketsuryuganProbability = config.getFloat("ketsuryugan", CATEGORY_PROBABILITIES, 0.02f, 0.0f, 1.0f, "Probability of a player obtaining the Ketsuryugan (2% chance by default)");
            otsutsukiByakuganProbability = config.getFloat("otsutsukiByakugan", CATEGORY_OTSUTSUKI, 0.95f, 0.0f, 1.0f, "Probability of an Otsutsuki player obtaining the Byakugan (95% chance by default)");
            allowKetsuAsRandomDojutsu = config.getBoolean("allowKetsuAsRandomDojutsu", CATEGORY_SETTINGS, false, "Spring ADDON");
            onlyDojutsuNoKKG = config.getBoolean("onlyDojutsuNoKKG", CATEGORY_SETTINGS, false, "If true, players with a Dojutsu will not receive a KKG");
            maxSimulations = config.getInt("maxSimulations", CATEGORY_SIMULATIONS, 3, 1, 28, "Maximum number of times a player can use the /simulate command");
            monkeyClan = config.getBoolean("monkeyClan", CATEGORY_MONKEY_CLAN, false, "If true, players have a chance to become part of the Monkey Clan");
            monkeyClanProbability = config.getFloat("monkeyClanProbability", CATEGORY_MONKEY_CLAN, 0.5f, 0.0f, 1.0f, "Probability of a player obtaining the Monkey Clan if monkeyClan is enabled (50% chance by default)");
            ghostClan = config.getBoolean("ghostClan", CATEGORY_GHOST_CLAN, false, "If true, players have a chance to become part of the Ghost Clan");
            ghostClanProbability = config.getFloat("ghostClanProbability", CATEGORY_GHOST_CLAN, 0.5f, 0.0f, 1.0f, "Probability of a player obtaining the Ghost Clan if ghostClan is enabled (50% chance by default)");
            enableDustKKG = config.getBoolean("enableDustKKG", CATEGORY_SETTINGS, false, "If true, players can obtain the Dust Kekkei Genkai during simulation");
            maxHealthRespawn = config.getBoolean("maxHealthRespawn", CATEGORY_RESPAWN, true, "If true, players will respawn with full health. Default is true");
            allowStarterClanItems = config.getBoolean("allowStarterClanItems", CATEGORY_SETTINGS, true, "If true, players receive starter clan items when using the Shinobi command. Default is true");
            allowCheatClan = config.getBoolean("allowCheatClan", CATEGORY_SETTINGS, true, "If true, players can use the Custom Clan commands. Default is true");
            kkgStealerProbability = config.getFloat("KKGStealerPercent", CATEGORY_KKG_STEALER, 0.1f, 0.0f, 1.0f, "Probability of stealing a Kekkei Genkai upon killing a player with one [NOT INCLUDED YET]");
            simulateableClans = config.getStringList("simulateableClans", CATEGORY_SIMULATEABLE_CLANS, new String[]{"Uchiha", "Hyuga", "Otsutsuki", "Senju", "Uzumaki", "Kaguya", "Namikaze", "Yamanaka", "Haruno", "Aburame", "Hatake", "Sarutobi", "Chinoike", "Akimichi", "Inuzuka", "Nara", "Orochimaru", "Kakei", "Amagiri", "Hoshigaki", "Izuno", "Rai", "Kurama", "Shirogane", "Yuki", "Terumi", "Kamikaze", "Kazesuna", "Hozuki"}, "List of clans that can be simulated");
            contractProbability = config.getFloat("contractProbability", CATEGORY_CONTRACTS, 0.02f, 0.0f, 1.0f, "Probability of getting a Summoning Contract (2% by default)");
            simulateableContracts = config.getStringList("simulateableContracts", CATEGORY_CONTRACTS, new String[]{"Toad", "Slug", "Snake", "Enma"}, "Contracts that can be simulated");
            senjutsuProbability = config.getFloat("senjutsuProbability", CATEGORY_SENJUTSU, 0.02f, 0.0f, 1.0f, "Probability of getting Senjutsu (2% by default)");
            simulateableSenjutsu = config.getStringList("simulateableSenjutsu", CATEGORY_SENJUTSU, new String[]{"Toad", "Slug", "Snake"}, "Senjutsu types that can be simulated");
            String[] defaultKKGMap = new String[]{"narutomod:ranton_acquired = narutomod:ranton = Storm", "narutomod:yoton_acquired = narutomod:yoton = Lava", "narutomod:shakuton_acquired = narutomod:shakuton = Scorch", "narutomod:hyoton_acquired = narutomod:hyoton = Ice", "narutomod:bakuton_acquired = narutomod:bakuton = Explosion", "narutomod:futton_acquired = narutomod:futton = Boil", "narutomod:jiton_acquired = narutomod:jiton = Magnet"};
            String[] lines = config.getStringList("kkgMappings", CATEGORY_KKG_MAPPINGS, defaultKKGMap, "");
            kkgMappings.clear();
            ArrayList<String> names = new ArrayList<String>();
            for (String raw : lines) {
                String[] parts;
                if (raw == null || (parts = raw.split("=")).length != 3) continue;
                String adv = parts[0].trim();
                String item = parts[1].trim();
                String name = parts[2].trim();
                if (adv.isEmpty() || item.isEmpty() || name.isEmpty()) continue;
                KKGMapping m = new KKGMapping(adv, item, name);
                kkgMappings.put(name.toLowerCase(Locale.ROOT), m);
                names.add(name);
            }
            simulateableKKGs = names.toArray(new String[0]);
            String[] defaultClanItems = new String[]{"senju: narutomod:ninja_armor_war_1helmet 1; narutomod:ninja_armor_war_1body 1", "uzumaki: narutomod:scroll_sealing_chains 1", "otsutsuki: narutomod:military_rations_pill_gold 6", "namikaze: narutomod:scroll_hiraishin 1", "yamanaka: narutomod:scroll_mind_transfer 1", "haruno: narutomod:scroll_enhanced_strength 1", "hatake: narutomod:anbu_sword 1", "sarutobi: narutomod:summoning_contract 1 0 {Type:enma}", "akimichi: narutomod:scroll_multi_size 1", "nara: narutomod:scroll_shadow_imitation 1", "orochimaru: narutomod:summoning_contract 1 0 {Type:snake}", "kakei: narutomod:gaunlet 1", "amagiri: narutomod:scroll_poison_mist 1", "hoshigaki: narutomod:scroll_water_shockwave 1", "kurama: narutomod:scroll_genjutsu 1", "shirogane: narutomod:scroll_puppet 1; narutomod:scroll_karasu 1", "yuki: narutomod:senbon 32", "rai: narutomod:scroll_lightning_chakra_mode 1", "kamikaze: narutomod:explosive_tag 32", "kazesuna: narutomod:smoke_bomb 16", "uchiha: narutomod:scroll_great_fireball 1; narutomod:scroll_flame_formation 1"};
            for (String entry : clanItemsArray = config.getStringList("clanItems", CATEGORY_CLAN_ITEMS, defaultClanItems, "you are also able to add senjutsu look at how I did it with the summonings scrolls just like this but with senjutsu yk")) {
                int colonIndex = entry.indexOf(":");
                if (colonIndex == -1) continue;
                String clanName = entry.substring(0, colonIndex).trim().toLowerCase(Locale.ROOT);
                String itemCommands = entry.substring(colonIndex + 1).trim();
                clanItems.put(clanName, itemCommands);
            }
        }
        catch (Exception e) {
            System.out.println("Error loading configuration: " + e.getMessage());
            e.printStackTrace();
        }
        finally {
            if (config.hasChanged()) {
                config.save();
            }
        }
    }

    static {
        clanItems = new HashMap<String, String>();
        kkgMappings = new HashMap<String, KKGMapping>();
    }

    public static class KKGMapping {
        public final String advancementId;
        public final String itemId;
        public final String displayName;

        public KKGMapping(String a, String i, String d) {
            this.advancementId = a;
            this.itemId = i;
            this.displayName = d;
        }
    }
}

