/*
 * Decompiled with CFR 0.152.
 */
package com.tyler.narutoorigin.coremod;

import com.tyler.narutoorigin.coremod.PlayerData;
import com.tyler.narutoorigin.coremod.PlayerDataManager;
import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.narutomod.Chakra;

public class AntClanChakraSteal {
    private final PlayerDataManager playerDataManager;
    private static final List<String> ELIGIBLE_CLANS = Arrays.asList("Ant", "King");

    public AntClanChakraSteal(PlayerDataManager playerDataManager) {
        this.playerDataManager = playerDataManager;
    }

    @SubscribeEvent
    public void onPlayerAttack(AttackEntityEvent event) {
        if (event.getEntity().field_70170_p.field_72995_K) {
            return;
        }
        if (!(event.getEntity() instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP attacker = (EntityPlayerMP)event.getEntity();
        PlayerData attackerData = this.playerDataManager.getPlayerData(attacker.func_70005_c_(), attacker.field_70170_p.func_72912_H().func_76065_j());
        if (attackerData == null || !ELIGIBLE_CLANS.contains(attackerData.getClan())) {
            return;
        }
        if (!(event.getTarget() instanceof EntityLivingBase)) {
            return;
        }
        EntityLivingBase target = (EntityLivingBase)event.getTarget();
        Chakra.PathwayPlayer attackerPathway = Chakra.pathway((EntityPlayer)attacker);
        Chakra.Pathway targetPathway = Chakra.pathway((EntityLivingBase)target);
        if (target instanceof EntityPlayer) {
            double targetCurrentChakra = targetPathway.getAmount();
            double stealAmount = targetCurrentChakra * 0.1;
            targetPathway.consume(stealAmount);
            attackerPathway.consume(-stealAmount);
        } else {
            double regenAmount = attackerPathway.getMax() * 0.01;
            attackerPathway.consume(-regenAmount);
        }
    }
}

