/*
 * Decompiled with CFR 0.152.
 */
package com.tyler.narutoorigin.coremod;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.narutomod.PlayerTracker;

public final class BattleXpTrackerRatja {
    private static BattleXpTrackerRatja INSTANCE;
    private final Map<UUID, Double> playerBattleXpMap = new HashMap<UUID, Double>();

    public static synchronized void ensureRegistered() {
        if (INSTANCE == null) {
            INSTANCE = new BattleXpTrackerRatja();
            MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
        }
    }

    public static synchronized void unregister() {
        if (INSTANCE != null) {
            MinecraftForge.EVENT_BUS.unregister((Object)INSTANCE);
            BattleXpTrackerRatja.INSTANCE.playerBattleXpMap.clear();
            INSTANCE = null;
        }
    }

    public static BattleXpTrackerRatja get() {
        return INSTANCE;
    }

    private BattleXpTrackerRatja() {
    }

    private static double safe(double v) {
        if (Double.isNaN(v) || Double.isInfinite(v)) {
            return 0.0;
        }
        return v;
    }

    public void updateBattleXp(EntityPlayer player) {
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        this.playerBattleXpMap.put(player.func_110124_au(), BattleXpTrackerRatja.safe(this.getBattleXpFromNarutoMod(player)));
    }

    public double getBattleXp(EntityPlayer player) {
        return this.playerBattleXpMap.getOrDefault(player.func_110124_au(), 0.0);
    }

    public void setBattleXp(EntityPlayer player, double newXp) {
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        this.playerBattleXpMap.put(player.func_110124_au(), BattleXpTrackerRatja.safe(newXp));
    }

    private double getBattleXpFromNarutoMod(EntityPlayer player) {
        try {
            return PlayerTracker.getBattleXp((EntityPlayer)player);
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player.field_70170_p.field_72995_K) {
            return;
        }
        this.updateBattleXp(event.player);
    }

    @SubscribeEvent
    public void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        this.playerBattleXpMap.remove(event.player.func_110124_au());
    }

    @SubscribeEvent
    public void onPlayerChangedDim(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (event.player.field_70170_p.field_72995_K) {
            return;
        }
        this.updateBattleXp(event.player);
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (event.side != Side.SERVER) {
            return;
        }
        this.updateBattleXp(event.player);
    }
}

