/*
 * Decompiled with CFR 0.152.
 */
package com.tyler.narutoorigin.coremod;

import com.tyler.narutoorigin.coremod.PlayerData;
import com.tyler.narutoorigin.coremod.PlayerDataManager;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.narutomod.PlayerTracker;

public final class ClanBattleXpHandlerRatja {
    private static ClanBattleXpHandlerRatja INSTANCE;
    private final PlayerDataManager playerDataManager;
    private final Map<UUID, Double> lastKnownXp = new HashMap<UUID, Double>();
    private final Set<String> eligibleClans = new HashSet<String>(Arrays.asList("Uchiha", "Ashura", "Otsutsuki", "Hatake", "Sarutobi", "King", "Ali", "Galaxy"));

    public static synchronized void ensureRegistered(PlayerDataManager playerDataManager) {
        if (INSTANCE == null) {
            INSTANCE = new ClanBattleXpHandlerRatja(playerDataManager);
            MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
        }
    }

    public static synchronized void unregister() {
        if (INSTANCE != null) {
            MinecraftForge.EVENT_BUS.unregister((Object)INSTANCE);
            ClanBattleXpHandlerRatja.INSTANCE.lastKnownXp.clear();
            INSTANCE = null;
        }
    }

    private ClanBattleXpHandlerRatja(PlayerDataManager playerDataManager) {
        this.playerDataManager = playerDataManager;
    }

    private boolean isEligible(EntityPlayerMP player) {
        PlayerData pd = this.playerDataManager.getPlayerData(player.func_70005_c_(), player.func_71121_q().func_72912_H().func_76065_j());
        return pd != null && this.eligibleClans.contains(pd.getClan());
    }

    private static double safe(double v) {
        if (Double.isNaN(v) || Double.isInfinite(v)) {
            return 0.0;
        }
        return v;
    }

    private void trackAndApplyBonus(EntityPlayerMP player) {
        double bonus;
        double last;
        if (!this.isEligible(player)) {
            return;
        }
        UUID id = player.func_110124_au();
        double current = ClanBattleXpHandlerRatja.safe(PlayerTracker.getBattleXp((EntityPlayer)player));
        double baseDiff = ClanBattleXpHandlerRatja.safe(current - (last = ClanBattleXpHandlerRatja.safe(this.lastKnownXp.getOrDefault(id, current))));
        if (baseDiff > 1.0E-6 && (bonus = baseDiff * 0.5) > 0.0) {
            PlayerTracker.addBattleXp((EntityPlayer)player, (double)bonus);
            this.lastKnownXp.put(id, current + bonus);
            return;
        }
        this.lastKnownXp.put(id, current);
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (!(event.player instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP mp = (EntityPlayerMP)event.player;
        if (mp.field_70170_p.field_72995_K) {
            return;
        }
        this.lastKnownXp.put(mp.func_110124_au(), ClanBattleXpHandlerRatja.safe(PlayerTracker.getBattleXp((EntityPlayer)mp)));
    }

    @SubscribeEvent
    public void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        if (!(event.player instanceof EntityPlayerMP)) {
            return;
        }
        this.lastKnownXp.remove(event.player.func_110124_au());
    }

    @SubscribeEvent
    public void onPlayerChangedDim(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (!(event.player instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP mp = (EntityPlayerMP)event.player;
        if (mp.field_70170_p.field_72995_K) {
            return;
        }
        this.lastKnownXp.put(mp.func_110124_au(), ClanBattleXpHandlerRatja.safe(PlayerTracker.getBattleXp((EntityPlayer)mp)));
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (event.side != Side.SERVER) {
            return;
        }
        if (!(event.player instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP mp = (EntityPlayerMP)event.player;
        if (mp.field_70170_p.field_72995_K) {
            return;
        }
        this.trackAndApplyBonus(mp);
    }
}

