/*
 * Decompiled with CFR 0.152.
 */
package com.tyler.narutoorigin.coremod;

import com.tyler.narutoorigin.coremod.ClanEffectManager;
import com.tyler.narutoorigin.coremod.PlayerData;
import com.tyler.narutoorigin.coremod.PlayerDataManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;

public class ClanEffectEventHandler {
    private final PlayerDataManager playerDataManager;

    public ClanEffectEventHandler(PlayerDataManager playerDataManager) {
        this.playerDataManager = playerDataManager;
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        this.apply(event.player);
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        this.apply(event.player);
    }

    private void apply(EntityPlayer player) {
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        if (!(player instanceof EntityPlayerMP)) {
            return;
        }
        EntityPlayerMP mp = (EntityPlayerMP)player;
        String worldName = mp.func_71121_q().func_72912_H().func_76065_j();
        PlayerData data = this.playerDataManager.getPlayerData(mp.func_70005_c_(), worldName);
        if (data != null && data.hasClaimedOrigin()) {
            ClanEffectManager.applyOrRefreshEffects(mp, data.getClan());
        } else {
            ClanEffectManager.removeEffectsBasedOnClan(mp);
        }
    }
}

