/*
 * Decompiled with CFR 0.152.
 */
package com.tyler.narutoorigin.coremod;

import com.tyler.narutoorigin.coremod.ClanEffectRegistry;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.potion.PotionEffect;

public final class ClanEffectManager {
    public static final int REFRESH_PERIOD_TICKS = 20;
    public static final int APPLY_DURATION_TICKS = 40;

    private ClanEffectManager() {
    }

    public static void applyOrRefreshEffects(EntityPlayerMP player, String clan) {
        if (player == null || clan == null || clan.isEmpty()) {
            return;
        }
        for (PotionEffect base : ClanEffectRegistry.getEffectsForClan(clan)) {
            PotionEffect active = player.func_70660_b(base.func_188419_a());
            if (active != null && active.func_76458_c() == base.func_76458_c() && active.func_76459_b() > 10) continue;
            player.func_70690_d(new PotionEffect(base.func_188419_a(), 40, base.func_76458_c(), true, false));
        }
    }

    public static void applyEffectsBasedOnClan(EntityPlayerMP player, String clan) {
        ClanEffectManager.applyOrRefreshEffects(player, clan);
    }

    public static void removeEffectsBasedOnClan(EntityPlayerMP player) {
        if (player == null) {
            return;
        }
        ClanEffectRegistry.getAllClans().forEach(clan -> ClanEffectRegistry.getEffectsForClan(clan).forEach(effect -> player.func_184589_d(effect.func_188419_a())));
    }
}

