/*
 * Decompiled with CFR 0.152.
 */
package com.tyler.narutoorigin.coremod;

import com.tyler.narutoorigin.coremod.ClanEffectManager;
import com.tyler.narutoorigin.coremod.PlayerData;
import com.tyler.narutoorigin.coremod.PlayerDataManager;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class ClanEffectPersistenceHandler {
    private final PlayerDataManager playerDataManager;
    private final Set<UUID> pending = new HashSet<UUID>();
    private int tick;

    public ClanEffectPersistenceHandler(PlayerDataManager playerDataManager) {
        this.playerDataManager = playerDataManager;
    }

    @SubscribeEvent
    public void onMilkFinished(LivingEntityUseItemEvent.Finish event) {
        if (!(event.getEntityLiving() instanceof EntityPlayerMP)) {
            return;
        }
        ItemStack stack = event.getItem();
        if (stack.func_77973_b() == Items.field_151117_aB) {
            this.queue((EntityPlayerMP)event.getEntityLiving());
        }
    }

    @SubscribeEvent
    public void onPotionExpired(PotionEvent.PotionExpiryEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayerMP) {
            this.queue((EntityPlayerMP)event.getEntityLiving());
        }
    }

    @SubscribeEvent
    public void onPotionRemoved(PotionEvent.PotionRemoveEvent event) {
        if (event.getEntityLiving() instanceof EntityPlayerMP) {
            this.queue((EntityPlayerMP)event.getEntityLiving());
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server == null) {
            return;
        }
        if (++this.tick >= 20) {
            this.tick = 0;
            for (EntityPlayerMP player : server.func_184103_al().func_181057_v()) {
                String clan;
                PlayerData data = this.playerDataManager.getPlayerData(player.func_70005_c_(), player.field_70170_p.func_72912_H().func_76065_j());
                if (data == null || !data.hasClaimedOrigin() || (clan = data.getClan()) == null || clan.isEmpty()) continue;
                ClanEffectManager.applyOrRefreshEffects(player, clan);
            }
        }
        if (!this.pending.isEmpty()) {
            for (UUID id : new HashSet<UUID>(this.pending)) {
                String clan;
                PlayerData data;
                EntityPlayerMP p = server.func_184103_al().func_177451_a(id);
                if (p == null || (data = this.playerDataManager.getPlayerData(p.func_70005_c_(), p.field_70170_p.func_72912_H().func_76065_j())) == null || !data.hasClaimedOrigin() || (clan = data.getClan()) == null || clan.isEmpty()) continue;
                ClanEffectManager.applyOrRefreshEffects(p, clan);
            }
            this.pending.clear();
        }
    }

    private void queue(EntityPlayerMP player) {
        this.pending.add(player.func_110124_au());
    }
}

