/*
 * Decompiled with CFR 0.152.
 */
package com.tyler.narutoorigin.coremod;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;

public class ClanEffectRegistry {
    private static final String FILE_PATH = "config/naruto_origin_clans.json";
    private static final Map<String, List<PotionEffect>> clanEffects = new HashMap<String, List<PotionEffect>>();

    public static void loadFromJson() {
        File file = new File(FILE_PATH);
        if (!file.exists()) {
            System.out.println("[NarutoOrigin] JSON file not found. Creating default file...");
            ClanEffectRegistry.createDefaultConfig();
        } else {
            try (FileReader reader = new FileReader(file);){
                Gson gson = new Gson();
                Type type = new TypeToken<Map<String, List<PotionEffectData>>>(){}.getType();
                Map effectDataMap = (Map)gson.fromJson((Reader)reader, type);
                effectDataMap.forEach((clan, effectDataList) -> {
                    ArrayList<PotionEffect> effects = new ArrayList<PotionEffect>();
                    for (PotionEffectData data : effectDataList) {
                        Potion potion = Potion.func_180142_b((String)data.effectName);
                        if (potion == null) continue;
                        effects.add(new PotionEffect(potion, data.duration, data.amplifier, true, false));
                    }
                    clanEffects.put((String)clan, (List<PotionEffect>)effects);
                });
                System.out.println("[NarutoOrigin] Clan effects successfully loaded from JSON.");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void saveToJson() {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        HashMap effectDataMap = new HashMap();
        clanEffects.forEach((clan, effects) -> {
            ArrayList<PotionEffectData> effectDataList = new ArrayList<PotionEffectData>();
            for (PotionEffect effect : effects) {
                effectDataList.add(new PotionEffectData(effect.func_188419_a().getRegistryName().toString(), effect.func_76459_b(), effect.func_76458_c()));
            }
            effectDataMap.put(clan, effectDataList);
        });
        try (FileWriter writer = new FileWriter(FILE_PATH);){
            gson.toJson(effectDataMap, (Appendable)writer);
            System.out.println("[NarutoOrigin] Clan effects saved to JSON.");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static List<PotionEffect> getEffectsForClan(String clan) {
        return clanEffects.getOrDefault(clan, Collections.emptyList());
    }

    public static void setEffectsForClan(String clan, List<PotionEffect> effects) {
        clanEffects.put(clan, effects);
        ClanEffectRegistry.saveToJson();
    }

    public static Set<String> getAllClans() {
        return clanEffects.keySet();
    }

    private static void createDefaultConfig() {
        clanEffects.put("Uchiha", Arrays.asList(new PotionEffect(MobEffects.field_76420_g, Integer.MAX_VALUE, 0, true, false), new PotionEffect(MobEffects.field_76426_n, Integer.MAX_VALUE, 0, true, false)));
        clanEffects.put("Hyuga", Arrays.asList(new PotionEffect(MobEffects.field_76420_g, Integer.MAX_VALUE, 0, true, false)));
        clanEffects.put("Senju", Arrays.asList(new PotionEffect(MobEffects.field_180152_w, Integer.MAX_VALUE, 1, true, false), new PotionEffect(MobEffects.field_76428_l, Integer.MAX_VALUE, 0, true, false), new PotionEffect(MobEffects.field_76429_m, Integer.MAX_VALUE, 0, true, false)));
        clanEffects.put("Ghost", Arrays.asList(new PotionEffect(MobEffects.field_180152_w, Integer.MAX_VALUE, 2, true, false), new PotionEffect(MobEffects.field_76428_l, Integer.MAX_VALUE, 1, true, false)));
        clanEffects.put("Uzumaki", Arrays.asList(new PotionEffect(MobEffects.field_180152_w, Integer.MAX_VALUE, 1, true, false), new PotionEffect(MobEffects.field_76428_l, Integer.MAX_VALUE, 1, true, false)));
        clanEffects.put("Kaguya", Arrays.asList(new PotionEffect(MobEffects.field_76420_g, Integer.MAX_VALUE, 1, true, false), new PotionEffect(MobEffects.field_76429_m, Integer.MAX_VALUE, 0, true, false), new PotionEffect(MobEffects.field_180152_w, Integer.MAX_VALUE, 0, true, false)));
        clanEffects.put("Otsutsuki", Arrays.asList(new PotionEffect(MobEffects.field_76420_g, Integer.MAX_VALUE, 2, true, false), new PotionEffect(MobEffects.field_76429_m, Integer.MAX_VALUE, 1, true, false), new PotionEffect(MobEffects.field_180152_w, Integer.MAX_VALUE, 1, true, false), new PotionEffect(MobEffects.field_76428_l, Integer.MAX_VALUE, 1, true, false)));
        clanEffects.put("Namikaze", Arrays.asList(new PotionEffect(MobEffects.field_76424_c, Integer.MAX_VALUE, 3, true, false)));
        clanEffects.put("Yamanaka", Arrays.asList(new PotionEffect(MobEffects.field_76439_r, Integer.MAX_VALUE, 0, true, false)));
        clanEffects.put("Haruno", Arrays.asList(new PotionEffect(MobEffects.field_76420_g, Integer.MAX_VALUE, 1, true, false), new PotionEffect(MobEffects.field_180152_w, Integer.MAX_VALUE, 0, true, false)));
        clanEffects.put("Aburame", Arrays.asList(new PotionEffect(MobEffects.field_76429_m, Integer.MAX_VALUE, 0, true, false), new PotionEffect(MobEffects.field_76439_r, Integer.MAX_VALUE, 0, true, false)));
        clanEffects.put("Hatake", Arrays.asList(new PotionEffect(MobEffects.field_76424_c, Integer.MAX_VALUE, 1, true, false), new PotionEffect(MobEffects.field_76443_y, Integer.MAX_VALUE, 0, true, false)));
        clanEffects.put("Sarutobi", Arrays.asList(new PotionEffect(MobEffects.field_76426_n, Integer.MAX_VALUE, 0, true, false), new PotionEffect(MobEffects.field_180152_w, Integer.MAX_VALUE, 0, true, false)));
        clanEffects.put("Chinoike", Arrays.asList(new PotionEffect(MobEffects.field_180152_w, Integer.MAX_VALUE, 1, true, false), new PotionEffect(MobEffects.field_76420_g, Integer.MAX_VALUE, 0, true, false)));
        clanEffects.put("Akimichi", Arrays.asList(new PotionEffect(MobEffects.field_76420_g, Integer.MAX_VALUE, 1, true, false), new PotionEffect(MobEffects.field_76443_y, Integer.MAX_VALUE, 0, true, false)));
        clanEffects.put("Inuzuka", Arrays.asList(new PotionEffect(MobEffects.field_76424_c, Integer.MAX_VALUE, 0, true, false), new PotionEffect(MobEffects.field_76430_j, Integer.MAX_VALUE, 0, true, false)));
        clanEffects.put("Nara", Arrays.asList(new PotionEffect(MobEffects.field_76424_c, Integer.MAX_VALUE, 0, true, false), new PotionEffect(MobEffects.field_76439_r, Integer.MAX_VALUE, 0, true, false)));
        clanEffects.put("Orochimaru", Arrays.asList(new PotionEffect(MobEffects.field_76428_l, Integer.MAX_VALUE, 0, true, false), new PotionEffect(MobEffects.field_76429_m, Integer.MAX_VALUE, 0, true, false)));
        clanEffects.put("Kakei", Arrays.asList(new PotionEffect(MobEffects.field_180152_w, Integer.MAX_VALUE, 1, true, false), new PotionEffect(MobEffects.field_76428_l, Integer.MAX_VALUE, 0, true, false)));
        clanEffects.put("Amagiri", Arrays.asList(new PotionEffect(MobEffects.field_76427_o, Integer.MAX_VALUE, 0, true, false), new PotionEffect(MobEffects.field_76430_j, Integer.MAX_VALUE, 0, true, false)));
        clanEffects.put("Hoshigaki", Arrays.asList(new PotionEffect(MobEffects.field_76427_o, Integer.MAX_VALUE, 0, true, false), new PotionEffect(MobEffects.field_76420_g, Integer.MAX_VALUE, 1, true, false)));
        clanEffects.put("Shadow-Monarch", Arrays.asList(new PotionEffect(MobEffects.field_76420_g, Integer.MAX_VALUE, 1, true, false), new PotionEffect(MobEffects.field_76428_l, Integer.MAX_VALUE, 1, true, false), new PotionEffect(MobEffects.field_76429_m, Integer.MAX_VALUE, 1, true, false)));
        clanEffects.put("Izuno", Arrays.asList(new PotionEffect(MobEffects.field_76430_j, Integer.MAX_VALUE, 0, true, false), new PotionEffect(MobEffects.field_76428_l, Integer.MAX_VALUE, 1, true, false)));
        clanEffects.put("Kurama", Arrays.asList(new PotionEffect(MobEffects.field_76428_l, Integer.MAX_VALUE, 1, true, false), new PotionEffect(MobEffects.field_76420_g, Integer.MAX_VALUE, 0, true, false)));
        clanEffects.put("Shirogane", Arrays.asList(new PotionEffect(MobEffects.field_76429_m, Integer.MAX_VALUE, 0, true, false), new PotionEffect(MobEffects.field_180152_w, Integer.MAX_VALUE, 1, true, false)));
        clanEffects.put("Yuki", Arrays.asList(new PotionEffect(MobEffects.field_76427_o, Integer.MAX_VALUE, 0, true, false), new PotionEffect(MobEffects.field_76430_j, Integer.MAX_VALUE, 0, true, false)));
        clanEffects.put("Rai", Arrays.asList(new PotionEffect(MobEffects.field_76424_c, Integer.MAX_VALUE, 1, true, false), new PotionEffect(MobEffects.field_76420_g, Integer.MAX_VALUE, 0, true, false)));
        clanEffects.put("Hozuki", Arrays.asList(new PotionEffect(MobEffects.field_76427_o, Integer.MAX_VALUE, 0, true, false), new PotionEffect(MobEffects.field_76429_m, Integer.MAX_VALUE, 0, true, false), new PotionEffect(MobEffects.field_76426_n, Integer.MAX_VALUE, 0, true, false)));
        clanEffects.put("Terumi", Arrays.asList(new PotionEffect(MobEffects.field_76426_n, Integer.MAX_VALUE, 0, true, false), new PotionEffect(MobEffects.field_180152_w, Integer.MAX_VALUE, 1, true, false), new PotionEffect(MobEffects.field_76420_g, Integer.MAX_VALUE, 0, true, false)));
        clanEffects.put("Kamikaze", Arrays.asList(new PotionEffect(MobEffects.field_76424_c, Integer.MAX_VALUE, 1, true, false), new PotionEffect(MobEffects.field_76430_j, Integer.MAX_VALUE, 0, true, false)));
        clanEffects.put("Kazesuna", Arrays.asList(new PotionEffect(MobEffects.field_76429_m, Integer.MAX_VALUE, 0, true, false), new PotionEffect(MobEffects.field_76426_n, Integer.MAX_VALUE, 0, true, false)));
        clanEffects.put("Malamut", Arrays.asList(new PotionEffect(MobEffects.field_76429_m, Integer.MAX_VALUE, 0, true, false), new PotionEffect(MobEffects.field_76420_g, Integer.MAX_VALUE, 0, true, false), new PotionEffect(MobEffects.field_76424_c, Integer.MAX_VALUE, 3, true, false)));
        clanEffects.put("Ali", Arrays.asList(new PotionEffect(MobEffects.field_76420_g, Integer.MAX_VALUE, 2, true, false), new PotionEffect(MobEffects.field_76429_m, Integer.MAX_VALUE, 1, true, false), new PotionEffect(MobEffects.field_180152_w, Integer.MAX_VALUE, 1, true, false), new PotionEffect(MobEffects.field_76428_l, Integer.MAX_VALUE, 1, true, false)));
        clanEffects.put("King", Arrays.asList(new PotionEffect(MobEffects.field_76429_m, Integer.MAX_VALUE, 1, true, false), new PotionEffect(MobEffects.field_180152_w, Integer.MAX_VALUE, 1, true, false), new PotionEffect(MobEffects.field_76428_l, Integer.MAX_VALUE, 2, true, false), new PotionEffect(MobEffects.field_76426_n, Integer.MAX_VALUE, 0, true, false)));
        clanEffects.put("Tennyson", Arrays.asList(new PotionEffect(MobEffects.field_76429_m, Integer.MAX_VALUE, 1, true, false), new PotionEffect(MobEffects.field_76420_g, Integer.MAX_VALUE, 2, true, false), new PotionEffect(MobEffects.field_76428_l, Integer.MAX_VALUE, 1, true, false)));
        clanEffects.put("Yuji", Arrays.asList(new PotionEffect(MobEffects.field_76429_m, Integer.MAX_VALUE, 1, true, false), new PotionEffect(MobEffects.field_76420_g, Integer.MAX_VALUE, 2, true, false), new PotionEffect(MobEffects.field_76428_l, Integer.MAX_VALUE, 1, true, false)));
        clanEffects.put("Monkey", Arrays.asList(new PotionEffect(MobEffects.field_76429_m, Integer.MAX_VALUE, 1, true, false), new PotionEffect(MobEffects.field_76420_g, Integer.MAX_VALUE, 2, true, false), new PotionEffect(MobEffects.field_76428_l, Integer.MAX_VALUE, 1, true, false)));
        clanEffects.put("meewe", Arrays.asList(new PotionEffect(MobEffects.field_76429_m, Integer.MAX_VALUE, 1, true, false), new PotionEffect(MobEffects.field_76420_g, Integer.MAX_VALUE, 4, true, false)));
        clanEffects.put("Tylers-slave", Arrays.asList(new PotionEffect(MobEffects.field_76429_m, Integer.MAX_VALUE, 1, true, false), new PotionEffect(MobEffects.field_76420_g, Integer.MAX_VALUE, 2, true, false), new PotionEffect(MobEffects.field_76428_l, Integer.MAX_VALUE, 1, true, false)));
        clanEffects.put("Seiketsu", Arrays.asList(new PotionEffect(MobEffects.field_76429_m, Integer.MAX_VALUE, 1, true, false), new PotionEffect(MobEffects.field_76420_g, Integer.MAX_VALUE, 2, true, false), new PotionEffect(MobEffects.field_76428_l, Integer.MAX_VALUE, 1, true, false)));
        clanEffects.put("Galaxy", Arrays.asList(new PotionEffect(MobEffects.field_76439_r, Integer.MAX_VALUE, 0, true, false), new PotionEffect(MobEffects.field_76429_m, Integer.MAX_VALUE, 1, true, false)));
        clanEffects.put("The-Watchers", Arrays.asList(new PotionEffect(MobEffects.field_76429_m, Integer.MAX_VALUE, 1, true, false), new PotionEffect(MobEffects.field_76420_g, Integer.MAX_VALUE, 2, true, false), new PotionEffect(MobEffects.field_76428_l, Integer.MAX_VALUE, 1, true, false)));
        clanEffects.put("Crooked_Crown", Arrays.asList(new PotionEffect(MobEffects.field_180152_w, Integer.MAX_VALUE, 0, true, false)));
        clanEffects.put("KuroOkami", Arrays.asList(new PotionEffect(MobEffects.field_76439_r, Integer.MAX_VALUE, 0, true, false), new PotionEffect(MobEffects.field_76424_c, Integer.MAX_VALUE, 4, true, false), new PotionEffect(MobEffects.field_76427_o, Integer.MAX_VALUE, 0, true, false)));
        clanEffects.put("KokukoHazer", Arrays.asList(new PotionEffect(MobEffects.field_76429_m, Integer.MAX_VALUE, 1, true, false), new PotionEffect(MobEffects.field_76420_g, Integer.MAX_VALUE, 3, true, false), new PotionEffect(MobEffects.field_76439_r, Integer.MAX_VALUE, 0, true, false)));
        clanEffects.put("Ant", Arrays.asList(new PotionEffect(MobEffects.field_76429_m, Integer.MAX_VALUE, 0, true, false), new PotionEffect(MobEffects.field_76428_l, Integer.MAX_VALUE, 0, true, false)));
        clanEffects.put("Space", Arrays.asList(new PotionEffect(MobEffects.field_76429_m, Integer.MAX_VALUE, 1, true, false), new PotionEffect(MobEffects.field_76420_g, Integer.MAX_VALUE, 2, true, false), new PotionEffect(MobEffects.field_76428_l, Integer.MAX_VALUE, 0, true, false), new PotionEffect(MobEffects.field_76426_n, Integer.MAX_VALUE, 0, true, false)));
        ClanEffectRegistry.saveToJson();
    }

    private static class PotionEffectData {
        String effectName;
        int duration;
        int amplifier;

        public PotionEffectData(String effectName, int duration, int amplifier) {
            this.effectName = effectName;
            this.duration = duration;
            this.amplifier = amplifier;
        }
    }
}

