/*
 * Decompiled with CFR 0.152.
 */
package com.tyler.narutoorigin.coremod;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.tyler.narutoorigin.NarutoOriginMod;
import com.tyler.narutoorigin.coremod.PlayerData;
import com.tyler.narutoorigin.coremod.PlayerDataManager;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;

public class ClanGiver
extends CommandBase {
    private final String filePath;
    private Set<String> specialPlayerList;

    public ClanGiver(MinecraftServer server) {
        File worldDirectory = server.func_71218_a(0).func_72860_G().func_75765_b();
        File clanDir = new File(worldDirectory, "Clan");
        if (!clanDir.exists()) {
            clanDir.mkdirs();
        }
        this.filePath = Paths.get(clanDir.getPath(), "specialPlayerList.json").toString();
        this.specialPlayerList = new HashSet<String>();
        this.loadSpecialPlayerList();
    }

    public String func_71517_b() {
        return "checkClan";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/checkClan <playerName>";
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length != 1) {
            throw new CommandException("Incorrect number of arguments. Usage: " + this.func_71518_a(sender), new Object[0]);
        }
        String playerName = args[0];
        EntityPlayerMP player = server.func_184103_al().func_152612_a(playerName);
        if (player == null) {
            sender.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "Player " + playerName + " not found."));
            return;
        }
        this.checkAndGrantClanAdvancement(server, player, NarutoOriginMod.playerDataManager);
    }

    public void addPlayerToSpecialList(String playerName) {
        if (this.specialPlayerList.add(playerName)) {
            System.out.println("Player added: " + playerName);
            this.saveSpecialPlayerList();
        } else {
            System.out.println("Player was already in the list: " + playerName);
        }
    }

    public boolean isPlayerInSpecialList(String playerName) {
        return this.specialPlayerList.contains(playerName);
    }

    private void saveSpecialPlayerList() {
        Gson gson = new Gson();
        try (FileWriter writer = new FileWriter(this.filePath);){
            gson.toJson(this.specialPlayerList, (Appendable)writer);
            System.out.println("Saved successfully: " + this.filePath);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void loadSpecialPlayerList() {
        Gson gson = new Gson();
        File file = new File(this.filePath);
        if (!file.exists()) {
            this.saveSpecialPlayerList();
        }
        try (FileReader reader = new FileReader(this.filePath);){
            Type type = new TypeToken<Set<String>>(){}.getType();
            this.specialPlayerList = (Set)gson.fromJson((Reader)reader, type);
            if (this.specialPlayerList == null) {
                this.specialPlayerList = new HashSet<String>();
            }
            System.out.println("List loaded: " + this.specialPlayerList);
        }
        catch (FileNotFoundException e) {
            System.out.println("File not found, creating a new list.");
            this.specialPlayerList = new HashSet<String>();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void checkAndGrantClanAdvancement(MinecraftServer server, EntityPlayerMP player, PlayerDataManager playerDataManager) {
        String playerName = player.func_70005_c_();
        if (this.isPlayerInSpecialList(playerName)) {
            System.out.println("Player " + playerName + " is already in the special list.");
            player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.YELLOW + "You have already been checked."));
            return;
        }
        String worldName = player.func_71121_q().func_72912_H().func_76065_j();
        PlayerData playerData = playerDataManager.getPlayerData(playerName, worldName);
        String clan = playerData.getClan();
        if (!clan.isEmpty()) {
            System.out.println("Granting clan advancement for player: " + playerName + " with clan: " + clan);
            this.executeServerCommand(server, "/advancement grant " + playerName + " only narutoorigin:clan/" + clan.toLowerCase());
            this.addPlayerToSpecialList(playerName);
            player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Clan advancement granted successfully."));
        } else {
            System.out.println("Player " + playerName + " has no clan.");
            player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "You don't have a clan, so no advancement will be granted."));
        }
    }

    private void executeServerCommand(MinecraftServer server, String command) {
        System.out.println("Executing server command: " + command);
        server.func_71187_D().func_71556_a((ICommandSender)server, command);
    }
}

